/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.query;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gephi.desktop.filters.query.QueryChildren;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class QueryNode
extends AbstractNode {
    private final Query query;

    public QueryNode(Query query) {
        super((Children)new QueryChildren(query));
        this.query = query;
        this.setIconBaseWithExtension("DesktopFilters/query.png");
    }

    public String getHtmlDisplayName() {
        return this.isSelected() ? "<b>" + this.query.getName() + "</b>" : this.query.getName();
    }

    private boolean isSelected() {
        FilterController fc = (FilterController)Lookup.getDefault().lookup(FilterController.class);
        FilterModel fm = fc.getModel();
        return (fm.isFiltering() || fm.isSelecting()) && fc.getModel().getCurrentQuery() == this.query;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveAction(), new RenameAction(), new SaveAction(), new DuplicateAction()};
    }

    public Query getQuery() {
        return this.query;
    }

    private class DuplicateAction
    extends AbstractAction {
        public DuplicateAction() {
            super(NbBundle.getMessage(QueryNode.class, (String)"QueryNode.actions.duplicate"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
            Query ancestor = QueryNode.this.query;
            while (ancestor.getParent() != null) {
                ancestor = ancestor.getParent();
            }
            this.duplicateQuery(filterController, null, ancestor);
        }

        private void duplicateQuery(FilterController filterController, Query parent, Query child) {
            Filter filter = child.getFilter();
            FilterBuilder builder = filterController.getModel().getLibrary().getBuilder(filter);
            Query childQuery = filterController.createQuery(builder);
            childQuery.setName(child.getName());
            Filter filterCopy = childQuery.getFilter();
            FilterProperty[] filterProperties = filter.getProperties();
            FilterProperty[] filterCopyProperties = filterCopy.getProperties();
            if (filterProperties != null && filterCopyProperties != null) {
                for (int i = 0; i < filterProperties.length; ++i) {
                    filterCopyProperties[i].setValue(filterProperties[i].getValue());
                }
            }
            if (parent == null) {
                filterController.add(childQuery);
            } else {
                filterController.setSubQuery(parent, childQuery);
            }
            if (child.getChildrenSlotsCount() > 0) {
                for (Query grandChild : child.getChildren()) {
                    this.duplicateQuery(filterController, childQuery, grandChild);
                }
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(NbBundle.getMessage(QueryNode.class, (String)"QueryNode.actions.save"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
            FilterLibrary filterLibrary = filterController.getModel().getLibrary();
            if (QueryNode.this.query.getParent() == null) {
                filterLibrary.saveQuery(QueryNode.this.query);
            } else {
                filterLibrary.saveQuery(QueryNode.this.query.getParent());
            }
        }
    }

    private class RenameAction
    extends AbstractAction {
        public RenameAction() {
            super(NbBundle.getMessage(QueryNode.class, (String)"QueryNode.actions.rename"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String input;
            FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
            NotifyDescriptor.InputLine question = new NotifyDescriptor.InputLine(NbBundle.getMessage(QueryNode.class, (String)"QueryNode.actions.rename.text"), NbBundle.getMessage(QueryNode.class, (String)"QueryNode.actions.rename.title"));
            question.setInputText(QueryNode.this.query.getName());
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)question) == NotifyDescriptor.OK_OPTION && (input = question.getInputText()) != null && !input.isEmpty()) {
                filterController.rename(QueryNode.this.query, input);
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(NbBundle.getMessage(QueryNode.class, (String)"QueryNode.actions.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
            if (QueryNode.this.query.getParent() == null) {
                filterController.remove(QueryNode.this.query);
            } else {
                filterController.removeSubQuery(QueryNode.this.query, QueryNode.this.query.getParent());
            }
        }
    }
}

