/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables.popup;

import java.awt.Point;
import java.util.List;
import javax.swing.JPopupMenu;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.spi.edges.EdgesManipulator;
import org.gephi.desktop.datalab.tables.AbstractElementsDataTable;
import org.gephi.desktop.datalab.tables.popup.AbstractPopupAdapter;
import org.gephi.desktop.datalab.utils.PopupMenuUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;

public class EdgesPopupAdapter
extends AbstractPopupAdapter<Edge> {
    public EdgesPopupAdapter(AbstractElementsDataTable<Edge> elementsDataTable) {
        super(elementsDataTable);
    }

    @Override
    protected JPopupMenu createPopup(Point p) {
        List<Edge> selectedElements = this.elementsDataTable.getElementsFromSelectedRows();
        Edge clickedElement = (Edge)this.elementsDataTable.getElementFromRow(this.table.rowAtPoint(p));
        JPopupMenu contextMenu = new JPopupMenu();
        DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
        Integer lastManipulatorType = null;
        for (EdgesManipulator em : dlh.getEdgesManipulators()) {
            em.setup(selectedElements.toArray(new Edge[0]), clickedElement);
            if (lastManipulatorType == null) {
                lastManipulatorType = em.getType();
            }
            if (lastManipulatorType.intValue() != em.getType()) {
                contextMenu.addSeparator();
            }
            lastManipulatorType = em.getType();
            if (!em.isAvailable()) continue;
            contextMenu.add(PopupMenuUtils.createMenuItemFromEdgesManipulator(em, clickedElement, selectedElements.toArray(new Edge[0])));
        }
        Column column = this.elementsDataTable.getColumnAtIndex(this.table.columnAtPoint(p));
        if (column != null) {
            contextMenu.add(PopupMenuUtils.createSubMenuFromRowColumn((Element)clickedElement, column));
        }
        return contextMenu;
    }
}

