/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.gephi.desktop.search.api.SearchController;
import org.gephi.desktop.search.api.SearchListener;
import org.gephi.desktop.search.api.SearchRequest;
import org.gephi.desktop.search.api.SearchResult;
import org.gephi.desktop.search.impl.SearchResultImpl;
import org.gephi.desktop.search.impl.SearchResultsBuilderImpl;
import org.gephi.desktop.search.spi.SearchProvider;
import org.openide.util.Lookup;

public class SearchControllerImpl
implements SearchController {
    private final ExecutorService pool;
    private final List<Future<Void>> currentSearch = new ArrayList<Future<Void>>();
    private SearchSession currentSession;
    private SearchListener currentListener;
    private static final int MAX_RESULTS = 10;

    public SearchControllerImpl() {
        this.pool = Executors.newCachedThreadPool();
    }

    protected void shutdown() {
        this.pool.shutdown();
    }

    @Override
    public <T> List<SearchResult<T>> search(SearchRequest request, Class<T> typeFilter) {
        SearchSession<T> session = new SearchSession<T>(request, Collections.singleton(typeFilter));
        if (request.inParallel()) {
            ForkJoinPool commonPool = ForkJoinPool.commonPool();
            this.getProviderTasks(request, session).stream().map(commonPool::submit).forEach(ForkJoinTask::join);
        } else {
            this.getProviderTasks(request, session).forEach(Runnable::run);
        }
        return session.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(SearchRequest request, SearchListener listener) {
        List<Future<Void>> list = this.currentSearch;
        synchronized (list) {
            this.currentSearch.forEach(f -> f.cancel(false));
            this.currentSearch.clear();
            if (this.currentSession != null && this.currentSession.markObsolete()) {
                this.currentListener.cancelled();
            }
            this.currentSession = new SearchSession(request);
            this.currentListener = listener;
            this.currentListener.started(request);
            this.getProviderTasks(request, this.currentSession).stream().map(r -> this.pool.submit((Runnable)r)).forEach(f -> this.currentSearch.add((Future)f));
            List<Future<Void>> providerTasks = this.currentSearch;
            SearchSession session = this.currentSession;
            this.pool.submit(() -> {
                for (Future f : providerTasks) {
                    try {
                        f.get();
                    }
                    catch (InterruptedException | CancellationException exception) {
                    }
                    catch (ExecutionException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (!session.isObsolete()) {
                    listener.finished(session.request, session.getResults());
                }
            });
        }
    }

    protected <T> List<Runnable> getProviderTasks(SearchRequest request, SearchSession<T> session) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        int position = 0;
        for (SearchProvider provider : Lookup.getDefault().lookupAll(SearchProvider.class)) {
            int providerPosition = position++;
            tasks.add(() -> {
                SearchResultsBuilderImpl resultsBuilder = new SearchResultsBuilderImpl(provider, providerPosition, request.isLimitResults() ? 10 : Integer.MAX_VALUE);
                session.addBuilder(resultsBuilder);
                provider.search(request, resultsBuilder);
                session.addResult(resultsBuilder.getResults());
            });
        }
        return tasks;
    }

    private static class SearchSession<T> {
        final SearchRequest request;
        final Set<Class<T>> classFilters;
        final Map<T, SearchResultImpl<T>> resultSet;
        final Queue<SearchResultsBuilderImpl<T>> builders;
        volatile boolean obsolete;
        volatile boolean finished;

        public SearchSession(SearchRequest request) {
            this(request, Collections.emptySet());
        }

        public SearchSession(SearchRequest request, Set<Class<T>> classFilters) {
            this.request = request;
            this.classFilters = classFilters;
            this.resultSet = new ConcurrentHashMap<T, SearchResultImpl<T>>();
            this.builders = new ConcurrentLinkedQueue<SearchResultsBuilderImpl<T>>();
        }

        protected void addBuilder(SearchResultsBuilderImpl<T> builder) {
            this.builders.add(builder);
        }

        protected boolean markObsolete() {
            SearchResultsBuilderImpl<T> builder;
            this.obsolete = true;
            while ((builder = this.builders.poll()) != null) {
                builder.markObsolete();
            }
            return !this.finished;
        }

        public boolean isObsolete() {
            return this.obsolete;
        }

        protected void addResult(List<SearchResultImpl<T>> results) {
            results.stream().filter(r -> this.passClassFilters(r.getResult())).forEach(key -> this.resultSet.merge(key.getResult(), (SearchResultImpl<T>)key, (oldValue, newValue) -> {
                if (newValue.getPosition() < oldValue.getPosition()) {
                    return newValue;
                }
                return oldValue;
            }));
        }

        protected List<SearchResult<T>> getResults() {
            this.finished = true;
            return this.resultSet.values().stream().sorted().collect(Collectors.toList());
        }

        protected boolean passClassFilters(T result) {
            if (this.classFilters.isEmpty()) {
                return true;
            }
            for (Class<T> cls : this.classFilters) {
                if (!cls.isAssignableFrom(result.getClass())) continue;
                return true;
            }
            return false;
        }
    }
}

