/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.EOFException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ColonizationSaveGameReader {
    private static final int PLAYER_DATA = 158;
    private static final int COLONY_DATA = 390;
    private static final String[] NATIONS = new String[]{"English", "French", "Spanish", "Dutch"};
    private final byte[] data;

    private ColonizationSaveGameReader(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
    }

    public static void main(String[] args) throws Exception {
        try (RandomAccessFile reader = new RandomAccessFile(args[0], "r");){
            byte[] data = new byte[(int)reader.length()];
            reader.readFully(data);
            new ColonizationSaveGameReader(data).run();
        }
        catch (EOFException ee) {
            System.err.println("Could not read from " + args[0] + ": " + ee);
            System.exit(1);
        }
    }

    private void run() {
        GameData gameData = new GameData(this.data);
        gameData.print();
        for (int index = 0; index < 4; ++index) {
            System.out.println("Nation is " + NATIONS[index]);
            PlayerData playerData = new PlayerData(this.data, 158 + index * 52);
            playerData.print();
        }
        int count = gameData.getNumberOfColonies();
        for (int index = 0; index < count; ++index) {
            ColonyData colonyData = new ColonyData(this.data, 390 + index * 202);
            colonyData.print();
        }
    }

    public static String getString(byte[] data, int start, int length) {
        byte[] bytes = Arrays.copyOfRange(data, start, start + length);
        String value = new String(bytes, StandardCharsets.UTF_8);
        int index = value.indexOf(0);
        return index < 0 ? value : value.substring(0, index);
    }

    public static class Colonist {
        public final String[] OCCUPATION = new String[]{"Farmer", "Sugar planter", "Tobacco planter", "Cotton planter", "Fur trapper", "Lumberjack", "Ore miner", "Silver miner", "Fisherman", "Distiller", "Tobacconist", "Weaver", "Fur Trader", "Carpenter", "Blacksmith", "Gunsmith", "Preacher", "Statesman", "Teacher", "", "Pioneer", "Veteran Soldier", "Scout", "Veteran Dragoon", "Missionary", "Indentured Servant", "Petty Criminal", "Indian convert", "Free colonist", "Armed brave", "Mounted brave"};
        public final String[] TILES = new String[]{"N", "E", "S", "W", "NW", "NE", "SE", "SW"};
        final int occupation;
        final int speciality;
        final int tile;

        public Colonist(int occupation, int speciality, int tile) {
            this.occupation = occupation;
            this.speciality = speciality;
            this.tile = tile;
        }

        public void print() {
            String tileString = this.tile >= 0 ? " [tile " + this.TILES[this.tile] + "]" : "";
            System.out.println(this.OCCUPATION[this.speciality] + " working as " + this.OCCUPATION[this.occupation] + tileString);
        }
    }

    private static class ColonyData {
        public static final int LENGTH = 202;
        public static final int COLONIST_OCCUPATION = 32;
        public static final int COLONIST_SPECIALITY = 64;
        public static final int TILES = 112;
        private final int x;
        private final int y;
        private final int numberOfColonists;
        private final String name;
        private final Colonist[] colonists;

        public ColonyData(byte[] data, int offset) {
            this.x = data[offset];
            this.y = data[offset + 1];
            this.name = ColonizationSaveGameReader.getString(data, offset + 2, offset + 25);
            this.numberOfColonists = data[offset + 31];
            this.colonists = new Colonist[this.numberOfColonists];
            for (int index = 0; index < this.numberOfColonists; ++index) {
                int tile = -1;
                for (int tileIndex = 0; tileIndex < 8; ++tileIndex) {
                    if (data[offset + 112 + tileIndex] != index) continue;
                    tile = tileIndex;
                    break;
                }
                this.colonists[index] = new Colonist(data[offset + 32 + index], data[offset + 64 + index], tile);
            }
        }

        public void print() {
            System.out.println(this.name + " [" + this.x + ", " + this.y + "], " + this.numberOfColonists + " colonists");
            for (Colonist colonist : this.colonists) {
                colonist.print();
            }
        }
    }

    private static class PlayerData {
        public static final int LENGTH = 52;
        private final String newLandName;
        private final String playerName;
        private final boolean humanPlayer;

        public PlayerData(byte[] data, int offset) {
            this.playerName = ColonizationSaveGameReader.getString(data, offset, 23);
            this.newLandName = ColonizationSaveGameReader.getString(data, offset + 24, 23);
            this.humanPlayer = data[offset + 49] == 0;
        }

        public void print() {
            System.out.println("Player name is " + this.playerName + (this.humanPlayer ? " [human]" : " [AI]"));
            System.out.println("New land name is " + this.newLandName);
        }
    }

    private static class GameData {
        private final int mapWidth;
        private final int mapHeight;
        private final int numberOfColonies;
        private final int difficulty;

        public GameData(byte[] data) {
            this.mapWidth = data[12];
            this.mapHeight = data[14];
            this.numberOfColonies = data[46];
            this.difficulty = data[54];
        }

        public void print() {
            System.out.println("Map size is " + this.mapWidth + " x " + this.mapHeight);
            System.out.println("Difficulty is " + this.difficulty);
            System.out.println(this.numberOfColonies + " colonies found");
        }

        public int getNumberOfColonies() {
            return this.numberOfColonies;
        }
    }
}

