/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.utils.HashUtils;

public class Downloader
extends Thread {
    private URL url;
    private Proxy proxy;
    private File targetFile;
    private Exception exception = null;
    private long size = 0L;
    private boolean complete = false;
    private Date started = null;
    private Date finished = null;
    private boolean cancelDownload = false;
    private String hash = null;
    private boolean validated = false;
    private static final Logger logger = LogManager.getLogger(Downloader.class);

    public Downloader(URL url, Proxy proxy, File targetFile, String hash) {
        this(url, proxy, targetFile, 0L, hash);
    }

    public Downloader(URL url, Proxy proxy, File targetFile, long size, String hash) {
        this.url = url;
        this.proxy = proxy;
        this.targetFile = targetFile;
        this.size = size;
        this.hash = hash;
    }

    @Override
    public void run() {
        this.started = new Date();
        if (this.hash != null) {
            if (this.hash.indexOf(":") > 0) {
                this.downloadFile();
                if (!this.cancelDownload) {
                    this.validateHashDownload();
                }
            } else {
                logger.debug("Not downloading file, hash field does not have valid content (\"<ALGORITHM>:<HASH>\"): " + this.hash);
            }
        } else {
            logger.debug("Not downloading file, does not have a hash: " + this.url);
        }
        this.complete = true;
        this.finished = new Date();
        if (this.cancelDownload) {
            this.targetFile.delete();
        }
    }

    private void downloadFile() {
        try (BufferedInputStream in = new BufferedInputStream(this.url.openConnection(this.proxy).getInputStream());
             FileOutputStream out = new FileOutputStream(this.targetFile);){
            int count;
            byte[] data = new byte[1024];
            while (!this.cancelDownload && (count = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void validateHashDownload() {
        try {
            String algorithm = this.hash.substring(0, this.hash.indexOf(":"));
            String hashValue = this.hash.substring(this.hash.indexOf(":") + 1);
            String realHash = HashUtils.getHash(this.targetFile, algorithm);
            if (realHash.equalsIgnoreCase(hashValue)) {
                this.validated = true;
            } else {
                logger.debug("Wrong hash - expected " + hashValue + " got " + realHash);
            }
        }
        catch (Exception e) {
            logger.debug("Error checking hash", (Throwable)e);
        }
    }

    boolean isCancelled() {
        return this.cancelDownload;
    }

    public void cancelDownload() {
        this.cancelDownload = true;
        if (this.complete && this.targetFile.exists()) {
            this.targetFile.delete();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public int getProgressPercent() {
        if (this.complete) {
            return 100;
        }
        if (this.size == 0L) {
            return 0;
        }
        return (int)(this.targetFile.length() * 100L / this.size);
    }

    public Date getStarted() {
        return this.started;
    }

    public Date getFinished() {
        return this.finished;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isValidated() {
        return this.validated;
    }
}

