/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.zaproxy.zap.control.BaseZapAddOnXmlData;

public class ZapAddOnXmlFile
extends BaseZapAddOnXmlData {
    private static final String ASCANRULE_ELEMENT = "ascanrule";
    private static final String ASCANRULES_ALL_ELEMENTS = "ascanrules/ascanrule";
    private static final String PSCANRULE_ELEMENT = "pscanrule";
    private static final String PSCANRULES_ALL_ELEMENTS = "pscanrules/pscanrule";
    private static final String FILE_ELEMENT = "file";
    private static final String FILES_ALL_ELEMENTS = "files/file";
    private static final String LIB_ELEMENT = "lib";
    private static final String LIBS_ALL_ELEMENTS = "libs/lib";
    private static final String BUNDLE_ELEMENT = "bundle";
    private static final String BUNDLE_PREFIX_ATT = "bundle/@prefix";
    private static final String HELPSET_ELEMENT = "helpset";
    private static final String HELPSET_LOCALE_TOKEN_ATT = "helpset/@localetoken";
    private List<String> ascanrules;
    private List<String> pscanrules;
    private List<String> files;
    private List<String> libs;
    private String bundleBaseName;
    private String bundlePrefix;
    private String helpSetBaseName;
    private String helpSetLocaleToken;

    public ZapAddOnXmlFile(InputStream is) throws IOException {
        super(is);
    }

    @Override
    protected void readAdditionalData(HierarchicalConfiguration zapAddOnXml) {
        this.ascanrules = this.getStrings(zapAddOnXml, ASCANRULES_ALL_ELEMENTS, ASCANRULE_ELEMENT);
        this.pscanrules = this.getStrings(zapAddOnXml, PSCANRULES_ALL_ELEMENTS, PSCANRULE_ELEMENT);
        this.files = this.getStrings(zapAddOnXml, FILES_ALL_ELEMENTS, FILE_ELEMENT);
        this.libs = this.getStrings(zapAddOnXml, LIBS_ALL_ELEMENTS, LIB_ELEMENT);
        this.bundleBaseName = zapAddOnXml.getString(BUNDLE_ELEMENT, "");
        this.bundlePrefix = zapAddOnXml.getString(BUNDLE_PREFIX_ATT, "");
        this.helpSetBaseName = zapAddOnXml.getString(HELPSET_ELEMENT, "");
        this.helpSetLocaleToken = zapAddOnXml.getString(HELPSET_LOCALE_TOKEN_ATT, "");
    }

    public List<String> getAscanrules() {
        return this.ascanrules;
    }

    public List<String> getPscanrules() {
        return this.pscanrules;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public List<String> getLibs() {
        return this.libs;
    }

    public String getBundleBaseName() {
        return this.bundleBaseName;
    }

    public String getBundlePrefix() {
        return this.bundlePrefix;
    }

    public String getHelpSetBaseName() {
        return this.helpSetBaseName;
    }

    public String getHelpSetLocaleToken() {
        return this.helpSetLocaleToken;
    }
}

