/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.filters.CsrfPreventionFilterBase;
import org.apache.catalina.filters.FilterBase;

public class RestCsrfPreventionFilter
extends CsrfPreventionFilterBase {
    private static final Pattern NON_MODIFYING_METHODS_PATTERN = Pattern.compile("GET|HEAD|OPTIONS");
    private Set<String> pathsAcceptingParams = new HashSet<String>();
    private String pathsDelimiter = ",";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        filterConfig.getServletContext().setAttribute("org.apache.catalina.filters.CSRF_REST_NONCE_HEADER_NAME", (Object)"X-CSRF-Token");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            RestCsrfPreventionStrategy restCsrfPreventionStrategy;
            MethodType methodType = MethodType.MODIFYING_METHOD;
            String string = ((HttpServletRequest)servletRequest).getMethod();
            if (string != null && NON_MODIFYING_METHODS_PATTERN.matcher(string).matches()) {
                methodType = MethodType.NON_MODIFYING_METHOD;
            }
            switch (methodType) {
                case NON_MODIFYING_METHOD: {
                    restCsrfPreventionStrategy = new FetchRequest();
                    break;
                }
                default: {
                    restCsrfPreventionStrategy = new StateChangingRequest();
                }
            }
            if (!restCsrfPreventionStrategy.apply((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse)) {
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void setPathsAcceptingParams(String string) {
        if (string != null) {
            for (String string2 : string.split(this.pathsDelimiter)) {
                this.pathsAcceptingParams.add(string2.trim());
            }
        }
    }

    public Set<String> getPathsAcceptingParams() {
        return this.pathsAcceptingParams;
    }

    private class FetchRequest
    extends RestCsrfPreventionStrategy {
        private FetchRequest() {
        }

        @Override
        public boolean apply(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            if ("Fetch".equalsIgnoreCase(this.extractNonceFromRequestHeader(httpServletRequest, "X-CSRF-Token"))) {
                String string = this.extractNonceFromSession(httpServletRequest.getSession(false), "org.apache.catalina.filters.CSRF_REST_NONCE");
                if (string == null) {
                    string = RestCsrfPreventionFilter.this.generateNonce(httpServletRequest);
                    this.storeNonceToSession(Objects.requireNonNull(httpServletRequest.getSession(true)), "org.apache.catalina.filters.CSRF_REST_NONCE", string);
                }
                this.storeNonceToResponse(httpServletResponse, "X-CSRF-Token", string);
                if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                    RestCsrfPreventionFilter.this.getLogger().debug((Object)FilterBase.sm.getString("restCsrfPreventionFilter.fetch.debug", new Object[]{httpServletRequest.getMethod(), httpServletRequest.getRequestURI()}));
                }
            }
            return true;
        }
    }

    private class StateChangingRequest
    extends RestCsrfPreventionStrategy {
        private StateChangingRequest() {
        }

        @Override
        public boolean apply(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
            HttpSession httpSession;
            String string;
            String string2 = this.extractNonceFromRequest(httpServletRequest);
            if (this.isValidStateChangingRequest(string2, string = this.extractNonceFromSession(httpSession = httpServletRequest.getSession(false), "org.apache.catalina.filters.CSRF_REST_NONCE"))) {
                return true;
            }
            this.storeNonceToResponse(httpServletResponse, "X-CSRF-Token", "Required");
            httpServletResponse.sendError(RestCsrfPreventionFilter.this.getDenyStatus(), FilterBase.sm.getString("restCsrfPreventionFilter.invalidNonce"));
            if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                RestCsrfPreventionFilter.this.getLogger().debug((Object)FilterBase.sm.getString("restCsrfPreventionFilter.invalidNonce.debug", new Object[]{httpServletRequest.getMethod(), httpServletRequest.getRequestURI(), httpServletRequest.getRequestedSessionId() != null, httpSession, string2 != null, string != null}));
            }
            return false;
        }

        private boolean isValidStateChangingRequest(String string, String string2) {
            return string != null && string2 != null && Objects.equals(string, string2);
        }

        private String extractNonceFromRequest(HttpServletRequest httpServletRequest) {
            String string = this.extractNonceFromRequestHeader(httpServletRequest, "X-CSRF-Token");
            if ((string == null || Objects.equals("", string)) && !RestCsrfPreventionFilter.this.getPathsAcceptingParams().isEmpty() && RestCsrfPreventionFilter.this.getPathsAcceptingParams().contains(RestCsrfPreventionFilter.this.getRequestedPath(httpServletRequest))) {
                string = this.extractNonceFromRequestParams(httpServletRequest);
            }
            return string;
        }

        private String extractNonceFromRequestParams(HttpServletRequest httpServletRequest) {
            String[] stringArray = this.extractNonceFromRequestParams(httpServletRequest, "X-CSRF-Token");
            if (stringArray != null && stringArray.length > 0) {
                String string = stringArray[0];
                for (String string2 : stringArray) {
                    if (Objects.equals(string2, string)) continue;
                    if (RestCsrfPreventionFilter.this.getLogger().isDebugEnabled()) {
                        RestCsrfPreventionFilter.this.getLogger().debug((Object)FilterBase.sm.getString("restCsrfPreventionFilter.multipleNonce.debug", new Object[]{httpServletRequest.getMethod(), httpServletRequest.getRequestURI()}));
                    }
                    return null;
                }
                return string;
            }
            return null;
        }
    }

    private static abstract class RestCsrfPreventionStrategy {
        private RestCsrfPreventionStrategy() {
        }

        abstract boolean apply(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

        protected String extractNonceFromRequestHeader(HttpServletRequest httpServletRequest, String string) {
            return httpServletRequest.getHeader(string);
        }

        protected String[] extractNonceFromRequestParams(HttpServletRequest httpServletRequest, String string) {
            return httpServletRequest.getParameterValues(string);
        }

        protected void storeNonceToResponse(HttpServletResponse httpServletResponse, String string, String string2) {
            httpServletResponse.setHeader(string, string2);
        }

        protected String extractNonceFromSession(HttpSession httpSession, String string) {
            return httpSession == null ? null : (String)httpSession.getAttribute(string);
        }

        protected void storeNonceToSession(HttpSession httpSession, String string, Object object) {
            httpSession.setAttribute(string, object);
        }
    }

    private static enum MethodType {
        NON_MODIFYING_METHOD,
        MODIFYING_METHOD;

    }
}

