/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;

public class TextOptimizer {
    public static void concatenate(Compiler compiler, Node.Nodes nodes) throws JasperException {
        TextCatVisitor textCatVisitor = new TextCatVisitor(compiler);
        nodes.visit(textCatVisitor);
        textCatVisitor.collectText();
    }

    private static class TextCatVisitor
    extends Node.Visitor {
        private static final String EMPTY_TEXT = "";
        private final Options options;
        private final PageInfo pageInfo;
        private int textNodeCount = 0;
        private Node.TemplateText firstTextNode = null;
        private StringBuilder textBuffer;

        TextCatVisitor(Compiler compiler) {
            this.options = compiler.getCompilationContext().getOptions();
            this.pageInfo = compiler.getPageInfo();
        }

        @Override
        public void doVisit(Node node) throws JasperException {
            this.collectText();
        }

        @Override
        public void visit(Node.PageDirective pageDirective) throws JasperException {
        }

        @Override
        public void visit(Node.TagDirective tagDirective) throws JasperException {
        }

        @Override
        public void visit(Node.TaglibDirective taglibDirective) throws JasperException {
        }

        @Override
        public void visit(Node.AttributeDirective attributeDirective) throws JasperException {
        }

        @Override
        public void visit(Node.VariableDirective variableDirective) throws JasperException {
        }

        @Override
        public void visitBody(Node node) throws JasperException {
            super.visitBody(node);
            this.collectText();
        }

        @Override
        public void visit(Node.TemplateText templateText) throws JasperException {
            if ((this.options.getTrimSpaces() || this.pageInfo.isTrimDirectiveWhitespaces()) && templateText.isAllSpace()) {
                templateText.setText(EMPTY_TEXT);
                return;
            }
            if (this.textNodeCount++ == 0) {
                this.firstTextNode = templateText;
                this.textBuffer = new StringBuilder(templateText.getText());
            } else {
                this.textBuffer.append(templateText.getText());
                templateText.setText(EMPTY_TEXT);
            }
        }

        private void collectText() {
            if (this.textNodeCount > 1) {
                this.firstTextNode.setText(this.textBuffer.toString());
            }
            this.textNodeCount = 0;
        }
    }
}

