/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.AbsoluteOrder;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;

public class SimpleCoordinator
extends ChannelInterceptorBase {
    private Member[] view;
    private final AtomicBoolean membershipChanged = new AtomicBoolean();

    private void membershipChanged() {
        this.membershipChanged.set(true);
    }

    @Override
    public void memberAdded(Member member) {
        super.memberAdded(member);
        this.membershipChanged();
        this.installViewWhenStable();
    }

    @Override
    public void memberDisappeared(Member member) {
        super.memberDisappeared(member);
        this.membershipChanged();
        this.installViewWhenStable();
    }

    protected void viewChange(Member[] memberArray) {
    }

    @Override
    public void start(int n) throws ChannelException {
        super.start(n);
        this.installViewWhenStable();
    }

    private void installViewWhenStable() {
        int n = 0;
        while (n < 10) {
            n = this.membershipChanged.compareAndSet(true, false) ? 0 : ++n;
            try {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        Member[] memberArray = this.getMembers();
        Object[] objectArray = new Member[memberArray.length + 1];
        System.arraycopy(memberArray, 0, objectArray, 0, memberArray.length);
        objectArray[memberArray.length] = this.getLocalMember(false);
        Arrays.sort(objectArray, AbsoluteOrder.comp);
        if (Arrays.equals(objectArray, this.view)) {
            return;
        }
        this.view = objectArray;
        this.viewChange((Member[])objectArray);
    }

    @Override
    public void stop(int n) throws ChannelException {
        super.stop(n);
    }

    public Member[] getView() {
        return this.view;
    }

    public Member getCoordinator() {
        return this.view == null ? null : this.view[0];
    }

    public boolean isCoordinator() {
        return this.view == null ? false : this.getLocalMember(false).equals(this.getCoordinator());
    }
}

