/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.catalina.storeconfig.StoreFactoryRule;
import org.apache.catalina.storeconfig.StoreRegistry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.SAXException;

public class StoreLoader {
    private static Log log = LogFactory.getLog(StoreLoader.class);
    protected static final Digester digester = StoreLoader.createDigester();
    private StoreRegistry registry;
    private URL registryResource;

    public StoreRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(StoreRegistry storeRegistry) {
        this.registry = storeRegistry;
    }

    protected static Digester createDigester() {
        long l = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(StoreRegistry.class.getClassLoader());
        digester.addObjectCreate("Registry", "org.apache.catalina.storeconfig.StoreRegistry", "className");
        digester.addSetProperties("Registry");
        digester.addObjectCreate("Registry/Description", "org.apache.catalina.storeconfig.StoreDescription", "className");
        digester.addSetProperties("Registry/Description");
        digester.addRule("Registry/Description", (Rule)new StoreFactoryRule("org.apache.catalina.storeconfig.StoreFactoryBase", "storeFactoryClass", "org.apache.catalina.storeconfig.StoreAppender", "storeAppenderClass"));
        digester.addSetNext("Registry/Description", "registerDescription", "org.apache.catalina.storeconfig.StoreDescription");
        digester.addCallMethod("Registry/Description/TransientAttribute", "addTransientAttribute", 0);
        digester.addCallMethod("Registry/Description/TransientChild", "addTransientChild", 0);
        long l2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digester for server-registry.xml created " + (l2 - l)));
        }
        return digester;
    }

    protected File serverFile(String string) {
        File file;
        if (string == null || string.length() < 1) {
            string = "server-registry.xml";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(System.getProperty("catalina.base") + "/conf", string);
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) {
        Digester digester = StoreLoader.digester;
        synchronized (digester) {
            File file = this.serverFile(string);
            try {
                this.registry = (StoreRegistry)StoreLoader.digester.parse(file);
                this.registryResource = file.toURI().toURL();
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
            catch (SAXException sAXException) {
                log.error((Object)sAXException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object;
        InputStream inputStream = null;
        this.registryResource = null;
        try {
            object = StoreLoader.getConfigUrl();
            if (object != null) {
                inputStream = new URL((String)object).openStream();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Find registry server-registry.xml from system property at url " + (String)object));
                }
                this.registryResource = new URL((String)object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                object = new File(StoreLoader.getCatalinaBase());
                File file = new File((File)object, "conf");
                File file2 = new File(file, "server-registry.xml");
                inputStream = new FileInputStream(file2);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Find registry server-registry.xml at file " + file2.getCanonicalPath()));
                }
                this.registryResource = file2.toURI().toURL();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            try {
                inputStream = StoreLoader.class.getResourceAsStream("/org/apache/catalina/storeconfig/server-registry.xml");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Find registry server-registry.xml at classpath resource");
                }
                this.registryResource = StoreLoader.class.getResource("/org/apache/catalina/storeconfig/server-registry.xml");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                object = digester;
                synchronized (object) {
                    this.registry = (StoreRegistry)digester.parse(inputStream);
                }
            }
            catch (Throwable throwable) {
                log.error((Object)throwable);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (inputStream == null) {
            log.error((Object)"Failed to load server-registry.xml");
        }
    }

    private static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    private static String getCatalinaBase() {
        return System.getProperty("catalina.base", StoreLoader.getCatalinaHome());
    }

    private static String getConfigUrl() {
        return System.getProperty("catalina.storeconfig");
    }

    public URL getRegistryResource() {
        return this.registryResource;
    }
}

