/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import java.io.IOException;

public class EndElement
extends HtmlTag {
    private String name;
    private boolean appendCR = false;

    public EndElement(String string) {
        this(string, false);
    }

    public EndElement(String string, boolean bl) {
        super(String.format("</%s>", string));
        if (string.contains("[^a-zA-Z]")) {
            throw new IllegalArgumentException(String.format("Invalid element name '%s'", string));
        }
        this.name = string;
        this.appendCR = bl;
    }

    @Override
    public Object clone() {
        return new EndElement(this.getName(), this.appendCR);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        if (this.appendCR) {
            teXParser.getListener().getWriteable().writeliteralln("");
        }
    }
}

