/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.auxfile;

import com.dickimawbooks.texparserlib.AssignedControlSequence;
import com.dickimawbooks.texparserlib.CatCodeChanger;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.auxfile.AuxCommand;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.AuxIgnoreable;
import com.dickimawbooks.texparserlib.auxfile.AuxProvideCommand;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import com.dickimawbooks.texparserlib.latex.Input;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Vector;

public class AuxParser
extends DefaultTeXParserListener
implements Writeable {
    private Vector<AuxData> auxData;
    private TeXApp texApp;
    private Charset charset = null;
    private String labelPrefix = null;
    private boolean allowCatChangers = true;

    public AuxParser(TeXApp teXApp) throws IOException {
        this(teXApp, null);
    }

    public AuxParser(TeXApp teXApp, Charset charset) throws IOException {
        this(teXApp, charset, null);
    }

    public AuxParser(TeXApp teXApp, Charset charset, String string) throws IOException {
        super(null);
        this.texApp = teXApp;
        this.charset = charset;
        this.labelPrefix = string;
        this.setWriteable(this);
        this.auxData = new Vector();
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    public TeXParser parseAuxFile(File file) throws IOException {
        return this.parseAuxFile(file, null);
    }

    public TeXParser parseAuxFile(File file, Charset charset) throws IOException {
        if (charset != null) {
            this.charset = charset;
        }
        TeXParser teXParser = new TeXParser(this);
        int n = teXParser.getCatCode(64);
        teXParser.setCatCode(64, 11);
        teXParser.parse(file);
        teXParser.setCatCode(64, n);
        return teXParser;
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.putControlSequence(new Input("@input", 1));
        this.addAuxCommand("newlabel", 2, this.labelPrefix);
        this.addAuxCommand("bibstyle", 1);
        this.addAuxCommand("citation", 1);
        this.addAuxCommand("bibdata", 1);
        this.addAuxCommand("bibcite", 2, this.labelPrefix);
        this.putControlSequence(new AuxProvideCommand());
        this.putControlSequence(new AuxIgnoreable("@writefile", false, new boolean[]{true, true}));
        this.putControlSequence(new AuxIgnoreable("selectlanguage", true, new boolean[]{true}));
    }

    public void addAuxCommand(String string, int n) {
        this.addAuxCommand(string, n, null);
    }

    public void addAuxCommand(String string, int n, String string2) {
        this.putControlSequence(new AuxCommand(string, n, string2));
    }

    public boolean isAllowedAuxCommand(ControlSequence controlSequence) {
        if (controlSequence instanceof CatCodeChanger) {
            return this.allowCatChangers;
        }
        return controlSequence instanceof Input || controlSequence instanceof AuxCommand || controlSequence instanceof AuxIgnoreable || controlSequence instanceof AssignedControlSequence || controlSequence instanceof AuxProvideCommand || controlSequence instanceof Primitive;
    }

    @Override
    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(string);
        if (controlSequence instanceof CatCodeChanger && !this.allowCatChangers) {
            return ((CatCodeChanger)((Object)controlSequence)).getNoOpCommand();
        }
        return this.isAllowedAuxCommand(controlSequence) ? controlSequence : new AuxIgnoreable(string);
    }

    public void setAllowCatCodeChangers(boolean bl) {
        this.allowCatChangers = bl;
    }

    public boolean isAllowCatCodeChangersOn() {
        return this.allowCatChangers;
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new AuxIgnoreable(string);
    }

    @Override
    public Writeable getWriteable() {
        return this;
    }

    @Override
    public void writeliteral(String string) throws IOException {
    }

    @Override
    public void writeliteralln(String string) throws IOException {
    }

    @Override
    public void write(String string) throws IOException {
    }

    @Override
    public void writeln(String string) throws IOException {
    }

    @Override
    public void write(char c) throws IOException {
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        this.getParser().message("message.reading", file);
        if (charset != null) {
            this.getParser().message("message.charset", charset);
        }
    }

    public void addAuxData(AuxData auxData) {
        this.auxData.add(auxData);
    }

    public Vector<AuxData> getAuxData(String string) {
        Vector<AuxData> vector = new Vector<AuxData>();
        for (AuxData auxData : this.auxData) {
            if (!auxData.getName().equals(string)) continue;
            vector.add(auxData);
        }
        return vector;
    }

    public Vector<AuxData> getAuxData() {
        return this.auxData;
    }

    @Override
    public Charset getCharSet() {
        return this.charset;
    }

    @Override
    public float emToPt(float f) {
        this.getParser().warning("Can't convert from em to pt, no font information loaded");
        return 9.5f * f;
    }

    @Override
    public float exToPt(float f) {
        this.getParser().warning("Can't convert from ex to pt, no font information loaded");
        return 4.4f * f;
    }
}

