/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.traps;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Fire;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.FlameParticle;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.BArray;
import com.watabou.utils.PathFinder;

public class BlazingTrap
extends Trap {
    public BlazingTrap() {
        this.color = 1;
        this.shape = 3;
    }

    @Override
    public void activate() {
        PathFinder.buildDistanceMap(this.pos, BArray.not(Dungeon.level.solid, null), 2);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE) continue;
            if (Dungeon.level.pit[i] || Dungeon.level.water[i]) {
                GameScene.add(Blob.seed(i, 1, Fire.class));
            } else {
                GameScene.add(Blob.seed(i, 5, Fire.class));
            }
            CellEmitter.get(i).burst(FlameParticle.FACTORY, 5);
        }
        Sample.INSTANCE.play("sounds/burning.mp3");
    }
}

