/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Manifest;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;

public class OSGiManifestParser
implements ModuleDescriptorParser {
    private static final OSGiManifestParser INSTANCE = new OSGiManifestParser();
    private ExecutionEnvironmentProfileProvider profileProvider;

    public static OSGiManifestParser getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean accept(Resource resource) {
        if (resource == null || resource.getName() == null || resource.getName().trim().equals("")) {
            return false;
        }
        return resource.getName().toUpperCase(Locale.US).endsWith("MANIFEST.MF");
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings object, URL uRL, Resource resource, boolean bl) throws ParseException, IOException {
        object = new Manifest(resource.openStream());
        object = ManifestParser.parseManifest((Manifest)object);
        try {
            ((BundleInfo)object).setUri(new URI(resource.getName()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Unsupported repository, resources names are not uris", uRISyntaxException);
        }
        return BundleInfoAdapter.toModuleDescriptor(this, null, (BundleInfo)object, this.profileProvider);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void toIvyFile(InputStream inputStream, Resource resource, File file, ModuleDescriptor moduleDescriptor) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(moduleDescriptor, file);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) throws ParseException, IOException {
        URLResource uRLResource = new URLResource(uRL);
        return this.parseDescriptor(parserSettings, uRL, uRLResource, bl);
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newIvyArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    public String toString() {
        return "manifest parser";
    }
}

