from typing import Any, ClassVar, Literal

FIELDNAME: Any

class Limit:
    offset: Any
    count: Any
    def __init__(self, offset: int = 0, count: int = 0) -> None: ...
    def build_args(self): ...

class Reducer:
    NAME: ClassVar[None]
    def __init__(self, *args) -> None: ...
    def alias(self, alias): ...
    @property
    def args(self): ...

class SortDirection:
    DIRSTRING: ClassVar[str | None]
    field: Any
    def __init__(self, field) -> None: ...

class Asc(SortDirection):
    DIRSTRING: ClassVar[Literal["ASC"]]

class Desc(SortDirection):
    DIRSTRING: ClassVar[Literal["DESC"]]

class AggregateRequest:
    def __init__(self, query: str = "*") -> None: ...
    def load(self, *fields): ...
    def group_by(self, fields, *reducers): ...
    def apply(self, **kwexpr): ...
    def limit(self, offset, num): ...
    def sort_by(self, *fields, **kwargs): ...
    def filter(self, expressions): ...
    def with_schema(self): ...
    def verbatim(self): ...
    def cursor(self, count: int = 0, max_idle: float = 0.0): ...
    def build_args(self): ...

class Cursor:
    cid: Any
    max_idle: int
    count: int
    def __init__(self, cid) -> None: ...
    def build_args(self): ...

class AggregateResult:
    rows: Any
    cursor: Any
    schema: Any
    def __init__(self, rows, cursor, schema) -> None: ...
