/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.wizard.move.bytype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.ui.ontology.wizard.move.FilteredAxiomsModel;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKit;
import org.protege.editor.owl.ui.ontology.wizard.move.MoveAxiomsKitConfigurationPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.SelectAxiomsPanel;
import org.protege.editor.owl.ui.ontology.wizard.move.bytype.AxiomTypeSelectorPanel;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class MoveAxiomsByTypeKit
extends MoveAxiomsKit
implements FilteredAxiomsModel {
    private Set<AxiomType> types;
    private AxiomTypeSelectorPanel axiomTypeSelectorPanel;
    private SelectAxiomsPanel selectAxiomsPanel;
    private Set<OWLAxiom> axioms;

    @Override
    public List<MoveAxiomsKitConfigurationPanel> getConfigurationPanels() {
        ArrayList<MoveAxiomsKitConfigurationPanel> panels = new ArrayList<MoveAxiomsKitConfigurationPanel>();
        panels.add(this.axiomTypeSelectorPanel);
        panels.add(this.selectAxiomsPanel);
        return panels;
    }

    @Override
    public Set<OWLAxiom> getAxioms(Set<OWLOntology> sourceOntologies) {
        return this.axioms;
    }

    public void initialise() throws Exception {
        this.types = new HashSet<AxiomType>();
        this.axiomTypeSelectorPanel = new AxiomTypeSelectorPanel(this);
        this.selectAxiomsPanel = new SelectAxiomsPanel(this, "axioms.type");
    }

    public void dispose() throws Exception {
        this.axiomTypeSelectorPanel.dispose();
    }

    public void setTypes(Set<AxiomType> types) {
        this.types.clear();
        this.types.addAll(types);
    }

    public Set<AxiomType> getTypes() {
        return this.types;
    }

    @Override
    public void setFilteredAxioms(Set<OWLAxiom> axioms) {
        this.axioms = axioms;
    }

    @Override
    public Set<OWLAxiom> getUnfilteredAxioms(Set<OWLOntology> sourceOntologies) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLOntology ont : sourceOntologies) {
            for (AxiomType type : this.types) {
                axioms.addAll(ont.getAxioms(type));
            }
        }
        return axioms;
    }
}

