/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.prefix.PrefixedNameRenderer;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.protege.editor.owl.ui.renderer.AbstractOWLEntityRenderer;
import org.protege.editor.owl.ui.renderer.prefix.PrefixBasedRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.PrefixManager;

public class OWLEntityPrefixedNameRenderer
extends AbstractOWLEntityRenderer
implements PrefixBasedRenderer {
    private PrefixedNameRenderer renderer;

    @Override
    public void initialise() {
        PrefixManager manager = PrefixUtilities.getPrefixOWLOntologyFormat(this.getOWLModelManager());
        PrefixedNameRenderer.Builder builder = PrefixedNameRenderer.builder();
        manager.getPrefixName2PrefixMap().forEach(builder::withPrefix);
        this.renderer = builder.withOwlPrefixes().withWellKnownPrefixes().build();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean configure(OWLEditorKit eKit) {
        throw new RuntimeException("This renderer is not configurable");
    }

    @Override
    public String render(IRI iri) {
        if (this.renderer == null) {
            throw new RuntimeException("Renderer has not been initialised");
        }
        return this.renderer.getPrefixedNameOrQuotedIri(iri);
    }

    @Override
    protected void disposeRenderer() {
    }
}

