/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.about.AboutPanel;
import org.protege.editor.core.ui.preferences.PreferencesDialogPanel;
import org.protege.editor.core.ui.split.ViewSplitPane;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginLoader;
import org.protege.editor.core.ui.view.ViewHolder;
import org.protege.editor.core.ui.workspace.WorkspaceViewManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Workspace
extends JComponent
implements Disposable {
    public static final int BOTTOM_RESULTS_VIEW = 0;
    public static final int LEFT_RESULTS_VIEW = 1;
    private final Logger logger = LoggerFactory.getLogger(Workspace.class);
    public static final String FILE_MENU_NAME = "File";
    public static final String WINDOW_MENU_NAME = "Window";
    private static final String HELP_MENU_NAME = "Help";
    public static final String RESULT_PANE_ID = "org.protege.editor.core.resultspane";
    private final ViewSplitPane bottomResultsSplitPane = new ViewSplitPane(0);
    private final ViewSplitPane leftResultsSplitPane = new ViewSplitPane(1);
    private final ViewHolder bottomResultsViewHolder = new ViewHolder("Results", "bottom", this.bottomResultsSplitPane);
    private final ViewHolder leftResultsViewHolder = new ViewHolder("R", "left", this.leftResultsSplitPane);
    private final WorkspaceViewManager viewManager = new WorkspaceViewManager();
    private EditorKit editorKit;
    private int fontSize = 12;

    public Workspace() {
        this.setLayout(new BorderLayout());
        this.leftResultsSplitPane.setResizeWeight(0.2);
        this.add(this.leftResultsSplitPane);
        this.bottomResultsSplitPane.setResizeWeight(0.65);
        this.leftResultsSplitPane.add((Component)this.bottomResultsSplitPane, "right");
        Workspace.adjustBorder(this.bottomResultsViewHolder);
        Workspace.adjustBorder(this.leftResultsViewHolder);
    }

    public void setup(EditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void changeFontSize(int delta) {
        this.fontSize += delta;
        if (this.fontSize < 1) {
            this.fontSize = 1;
        }
    }

    private static void adjustBorder(ViewHolder holder) {
        Border currentBorder = holder.getBorder();
        holder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), currentBorder));
    }

    protected void initialiseExtraMenuItems(JMenuBar menuBar) {
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu == null) continue;
            String menuText = menu.getText();
            if (WINDOW_MENU_NAME.equals(menuText)) {
                this.installLookAndFeelMenu(menu);
                continue;
            }
            if (FILE_MENU_NAME.equals(menuText)) {
                this.installFileMenu(menu);
                continue;
            }
            if (!HELP_MENU_NAME.equals(menuText)) continue;
            this.installHelpMenu(menu);
        }
    }

    private void installHelpMenu(JMenu helpMenu) {
        if (OSUtils.isOSX()) {
            return;
        }
        helpMenu.addSeparator();
        JMenuItem aboutMenuItem = helpMenu.add("About");
        aboutMenuItem.addActionListener(e -> AboutPanel.showDialog());
    }

    private void installFileMenu(JMenu fileMenu) {
        if (OSUtils.isOSX()) {
            return;
        }
        fileMenu.addSeparator();
        JMenuItem prefsMenuItem = fileMenu.add("Preferences...");
        prefsMenuItem.addActionListener(e -> PreferencesDialogPanel.showPreferencesDialog(null, this.getEditorKit()));
        prefsMenuItem.setAccelerator(KeyStroke.getKeyStroke(","));
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = fileMenu.add("Exit");
        exitMenuItem.addActionListener(e -> ProtegeApplication.handleQuit());
    }

    private void installLookAndFeelMenu(JMenu windowMenu) {
        windowMenu.addSeparator();
        JMenu menu = new JMenu("Look & Feel");
        ButtonGroup lafMenuItemGroup = new ButtonGroup();
        windowMenu.add(menu);
        String currentLookAndFeelName = UIManager.getLookAndFeel().getClass().getName();
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences("LOOK_AND_FEEL_KEY");
        String selectedLookAndFeelClassName = p.getString("LOOK_AND_FEEL_CLASS_NAME", currentLookAndFeelName);
        this.addLookAndFeelMenuItem(menu, lafMenuItemGroup, selectedLookAndFeelClassName, "com.jgoodies.looks.plastic.PlasticLookAndFeel", (com.google.common.base.Optional<String>)com.google.common.base.Optional.of((Object)"Prot\u00e9g\u00e9"));
        this.addLookAndFeelMenuItem(menu, lafMenuItemGroup, selectedLookAndFeelClassName, UIManager.getSystemLookAndFeelClassName(), (com.google.common.base.Optional<String>)com.google.common.base.Optional.absent());
        this.addLookAndFeelMenuItem(menu, lafMenuItemGroup, selectedLookAndFeelClassName, UIManager.getCrossPlatformLookAndFeelClassName(), (com.google.common.base.Optional<String>)com.google.common.base.Optional.of((Object)"Cross-platform"));
    }

    private void addLookAndFeelMenuItem(JMenu menu, ButtonGroup lafMenuItemGroup, String selectedLookAndFeelName, final String lookAndFeelClassName, com.google.common.base.Optional<String> shortName) {
        try {
            String lafShortName;
            if (shortName.isPresent()) {
                lafShortName = (String)shortName.get();
            } else {
                Class<?> cls = Class.forName(lookAndFeelClassName);
                LookAndFeel laf = (LookAndFeel)cls.newInstance();
                lafShortName = laf.getName();
            }
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(new AbstractAction(lafShortName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Workspace.this.setLookAndFeel(lookAndFeelClassName, lafShortName);
                }
            });
            lafMenuItemGroup.add(menuItem);
            menuItem.setSelected(selectedLookAndFeelName.equals(lookAndFeelClassName));
            menu.add(menuItem);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.logger.error("Error whilst adding menu item: {}", (Throwable)e);
        }
    }

    private void setLookAndFeel(String clsName, String shortName) {
        try {
            Class<?> lookAndFeelClass = Class.forName(clsName);
            LookAndFeel lookAndFeel = (LookAndFeel)lookAndFeelClass.newInstance();
            UIManager.setLookAndFeel(lookAndFeel);
            SwingUtilities.updateComponentTreeUI(this);
            Preferences p = PreferencesManager.getInstance().getApplicationPreferences("LOOK_AND_FEEL_KEY");
            p.putString("LOOK_AND_FEEL_CLASS_NAME", clsName);
            JOptionPane.showMessageDialog(this, "<html><body><div style=\"font-weight: bold;\">The Look & Feel has been set to " + shortName + ".</div><div>Please restart " + "Prot\u00e9g\u00e9" + " for the changes to take effect.<div></body></html>");
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "There was a problem setting the look and feel.", "Error", 0);
            this.logger.error("Error whilst setting look and feel: {}", (Throwable)e1);
        }
    }

    protected void setContent(JComponent component) {
        this.bottomResultsSplitPane.setTopComponent(component);
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public WorkspaceViewManager getViewManager() {
        return this.viewManager;
    }

    public abstract Optional<JComponent> getStatusArea();

    public void showResultsView(String id, String headerLabel, Color headerColor, ViewComponent viewComponent, boolean replace, int location) {
        ResultsViewComponentPlugin plugin = new ResultsViewComponentPlugin(id, headerLabel, headerColor, viewComponent);
        this.showResultsView(plugin, replace, location);
    }

    public View showResultsView(String id, boolean replace, int location) {
        ViewComponentPluginLoader pluginLoader = new ViewComponentPluginLoader(this);
        for (ViewComponentPlugin plugin : pluginLoader.getPlugins()) {
            if (!id.equals(plugin.getId())) continue;
            return this.showResultsView(plugin, replace, location);
        }
        return null;
    }

    public View showResultsView(ViewComponentPlugin plugin, boolean replace, int location) {
        try {
            View v;
            ViewHolder viewHolder = location == 0 ? this.bottomResultsViewHolder : this.leftResultsViewHolder;
            if (replace && (v = viewHolder.getView(plugin.getId())) != null) {
                v.closeView();
            }
            View view = new View(plugin, this);
            ViewComponent viewComponent = (ViewComponent)plugin.newInstance();
            viewComponent.setup(plugin);
            viewHolder.addView(view);
            return view;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.logger.error("An error occurred whilst instantiating the results view: {}", (Throwable)e);
            return null;
        }
    }

    public void save() throws Exception {
    }

    @Override
    public void dispose() {
        this.leftResultsViewHolder.dispose();
        this.bottomResultsViewHolder.dispose();
    }

    protected String getTitle() {
        return "";
    }

    public void handleActivated() {
    }

    private class ResultsViewComponentPlugin
    implements ViewComponentPlugin {
        private String id;
        private ViewComponent viewComponent;
        private String headerLabel;
        private Color headerColor;

        protected ResultsViewComponentPlugin(String id, String headerLabel, Color headerColor, ViewComponent viewComponent) {
            this.id = id;
            this.headerColor = headerColor;
            this.headerLabel = headerLabel;
            this.viewComponent = viewComponent;
        }

        @Override
        public Color getBackgroundColor() {
            return this.headerColor;
        }

        @Override
        public String getLabel() {
            return this.headerLabel;
        }

        @Override
        public Workspace getWorkspace() {
            return Workspace.this;
        }

        @Override
        public boolean isUserCreatable() {
            return false;
        }

        @Override
        public String getDocumentation() {
            return null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return this.viewComponent;
        }

        @Override
        public Set<String> getCategorisations() {
            return Collections.singleton("Results");
        }

        @Override
        public Set<String> getNavigates() {
            return Collections.emptySet();
        }
    }
}

