/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.rdf.model.AbstractTranslator;
import org.semanticweb.owlapi.util.AxiomAppearance;
import org.semanticweb.owlapi.util.IndividualAppearance;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFTranslator
extends AbstractTranslator<RDFNode, RDFResource, RDFResourceIRI, RDFLiteral> {
    public RDFTranslator(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntology ontology, boolean useStrongTyping, IndividualAppearance occurrences, AxiomAppearance axiomOccurrences, AtomicInteger nextNode, Map<Object, Integer> blankNodeMap) {
        super(manager, ontology, useStrongTyping, occurrences, axiomOccurrences, nextNode, blankNodeMap);
    }

    @Override
    protected void addTriple(@Nonnull RDFResource subject, @Nonnull RDFResourceIRI pred, @Nonnull RDFNode object) {
        this.graph.addTriple(new RDFTriple(OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null"), OWLAPIPreconditions.checkNotNull(pred, "pred cannot be null"), OWLAPIPreconditions.checkNotNull(object, "object cannot be null")));
    }

    @Override
    protected RDFResourceBlankNode getAnonymousNode(Object key) {
        OWLAPIPreconditions.checkNotNull(key, "key cannot be null");
        boolean isIndividual = key instanceof OWLAnonymousIndividual;
        boolean isAxiom = false;
        boolean needId = false;
        if (isIndividual) {
            OWLAnonymousIndividual anonymousIndividual = (OWLAnonymousIndividual)key;
            needId = this.multipleOccurrences.appearsMultipleTimes(anonymousIndividual);
            key = anonymousIndividual.getID().getID();
        } else if (key instanceof OWLAxiom) {
            isIndividual = false;
            isAxiom = true;
            needId = this.axiomOccurrences.appearsMultipleTimes((OWLAxiom)key);
        }
        return this.getBlankNodeFor(key, isIndividual, needId, isAxiom);
    }

    @Override
    protected RDFResource getAnonymousNodeForExpressions(Object key, boolean isAxiom) {
        OWLAPIPreconditions.checkNotNull(key, "key cannot be null");
        return new RDFResourceBlankNode(false, false, isAxiom);
    }

    @Override
    protected RDFLiteral getLiteralNode(@Nonnull OWLLiteral literal) {
        return new RDFLiteral(literal);
    }

    @Override
    protected RDFResourceIRI getPredicateNode(@Nonnull IRI iri) {
        return new RDFResourceIRI(iri);
    }

    @Override
    protected RDFResourceIRI getResourceNode(@Nonnull IRI iri) {
        return new RDFResourceIRI(iri);
    }
}

