/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;

public final class JavaByteSyntaxChecker
extends SyntaxChecker {
    public static final JavaByteSyntaxChecker INSTANCE = new JavaByteSyntaxChecker("1.3.6.1.4.1.18060.0.4.1.0.0");

    private JavaByteSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        int pos = 0;
        char c = strValue.charAt(pos);
        if (c == '-') {
            pos = 1;
        } else {
            if (!Chars.isDigit(c)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
                return false;
            }
            if (c == '0') {
                boolean result;
                boolean bl = result = strValue.length() <= 1;
                if (LOG.isDebugEnabled()) {
                    if (result) {
                        LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                    } else {
                        LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
                    }
                }
                return result;
            }
        }
        if (!Chars.isDigit(strValue, pos) || Strings.isCharASCII(strValue, pos, '0')) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        ++pos;
        while (Chars.isDigit(strValue, pos)) {
            ++pos;
        }
        if (pos != strValue.length()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        try {
            Byte.valueOf(strValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            }
            return true;
        }
        catch (NumberFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<JavaByteSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.1.0.0");
        }

        @Override
        public JavaByteSyntaxChecker build() {
            return new JavaByteSyntaxChecker(this.oid);
        }
    }
}

