/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.preproc2.PreprocessorIncludeStrategy;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;

public class EaterInclude
extends Eater {
    private String what;
    private PreprocessorIncludeStrategy strategy = PreprocessorIncludeStrategy.DEFAULT;

    public EaterInclude(StringLocated s2) {
        super(s2);
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException {
        this.skipSpaces();
        this.checkAndEatChar("!include");
        char peekChar = this.peekChar();
        if (peekChar == 'u') {
            this.checkAndEatChar("url");
        } else if (peekChar == '_') {
            this.checkAndEatChar("_");
            char peekChar2 = this.peekChar();
            if (peekChar2 == 'm') {
                this.checkAndEatChar("many");
                this.strategy = PreprocessorIncludeStrategy.MANY;
            } else {
                this.checkAndEatChar("once");
                this.strategy = PreprocessorIncludeStrategy.ONCE;
            }
        }
        this.skipSpaces();
        this.what = context.applyFunctionsAndVariables(memory, new StringLocated(this.eatAllToEnd(), this.getLineLocation()));
    }

    public final String getWhat() {
        return this.what;
    }

    public final PreprocessorIncludeStrategy getPreprocessorIncludeStrategy() {
        return this.strategy;
    }
}

