/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.util.concurrent.FutureUtils;

public class NettyListener
implements BiConsumer<Void, Exception>,
ChannelPromise {
    private final ChannelPromise promise;

    private NettyListener(ChannelPromise promise) {
        this.promise = promise;
    }

    @Override
    public void accept(Void v, Exception exception) {
        if (exception == null) {
            this.promise.setSuccess();
        } else {
            this.promise.setFailure((Throwable)exception);
        }
    }

    public Channel channel() {
        return this.promise.channel();
    }

    public ChannelPromise setSuccess(Void result) {
        return this.promise.setSuccess(result);
    }

    public boolean trySuccess(Void result) {
        return this.promise.trySuccess((Object)result);
    }

    public ChannelPromise setSuccess() {
        return this.promise.setSuccess();
    }

    public boolean trySuccess() {
        return this.promise.trySuccess();
    }

    public ChannelPromise setFailure(Throwable cause) {
        return this.promise.setFailure(cause);
    }

    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFailure(cause);
    }

    public boolean setUncancellable() {
        return this.promise.setUncancellable();
    }

    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    public boolean isCancellable() {
        return this.promise.isCancellable();
    }

    public Throwable cause() {
        return this.promise.cause();
    }

    public ChannelPromise addListener(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>> listener) {
        return this.promise.addListener(listener);
    }

    @SafeVarargs
    public final ChannelPromise addListeners(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>> ... listeners) {
        return this.promise.addListeners(listeners);
    }

    public ChannelPromise removeListener(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>> listener) {
        return this.promise.removeListener(listener);
    }

    @SafeVarargs
    public final ChannelPromise removeListeners(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>> ... listeners) {
        return this.promise.removeListeners(listeners);
    }

    public ChannelPromise sync() throws InterruptedException {
        return this.promise.sync();
    }

    public ChannelPromise syncUninterruptibly() {
        return this.promise.syncUninterruptibly();
    }

    public ChannelPromise await() throws InterruptedException {
        return this.promise.await();
    }

    public ChannelPromise awaitUninterruptibly() {
        return this.promise.awaitUninterruptibly();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.promise.await(timeout, unit);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.promise.await(timeoutMillis);
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.promise.awaitUninterruptibly(timeout, unit);
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.promise.awaitUninterruptibly(timeoutMillis);
    }

    public Void getNow() {
        return (Void)this.promise.getNow();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return FutureUtils.cancel((Future)this.promise);
    }

    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    public boolean isDone() {
        return this.promise.isDone();
    }

    public Void get() throws InterruptedException, ExecutionException {
        return (Void)this.promise.get();
    }

    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Void)this.promise.get(timeout, unit);
    }

    public boolean isVoid() {
        return this.promise.isVoid();
    }

    public ChannelPromise unvoid() {
        return this.promise.unvoid();
    }

    public static NettyListener fromBiConsumer(BiConsumer<Void, Exception> biConsumer, Channel channel) {
        if (biConsumer instanceof NettyListener) {
            return (NettyListener)biConsumer;
        }
        ChannelPromise channelPromise = channel.newPromise();
        channelPromise.addListener(f -> {
            Throwable cause = f.cause();
            if (cause == null) {
                biConsumer.accept(null, null);
            } else if (cause instanceof Error) {
                ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                biConsumer.accept(null, new Exception(cause));
            } else {
                biConsumer.accept(null, (Exception)cause);
            }
        });
        return new NettyListener(channelPromise);
    }

    public static NettyListener fromChannelPromise(ChannelPromise channelPromise) {
        if (channelPromise instanceof NettyListener) {
            return (NettyListener)channelPromise;
        }
        return new NettyListener(channelPromise);
    }
}

