/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;

public interface FsVolumeSpi
extends Checkable<VolumeCheckContext, VolumeCheckResult> {
    public FsVolumeReference obtainReference() throws ClosedChannelException;

    public String getStorageID();

    public String[] getBlockPoolList();

    public long getAvailable() throws IOException;

    public URI getBaseURI();

    public DF getUsageStats(Configuration var1);

    public StorageLocation getStorageLocation();

    public StorageType getStorageType();

    public boolean isTransientStorage();

    public void reserveSpaceForReplica(long var1);

    public void releaseReservedSpace(long var1);

    public void releaseLockedMemory(long var1);

    public BlockIterator newBlockIterator(String var1, String var2);

    public BlockIterator loadBlockIterator(String var1, String var2) throws IOException;

    public FsDatasetSpi getDataset();

    public byte[] loadLastPartialChunkChecksum(File var1, File var2) throws IOException;

    public void compileReport(String var1, Collection<ScanInfo> var2, DirectoryScanner.ReportCompiler var3) throws InterruptedException, IOException;

    public FileIoProvider getFileIoProvider();

    public DataNodeVolumeMetrics getMetrics();

    public static class VolumeCheckContext {
    }

    public static class ScanInfo
    implements Comparable<ScanInfo> {
        private final long blockId;
        private final File basePath;
        private final String blockFile;
        private final String metaFile;
        private final FsVolumeSpi volume;
        private final FileRegion fileRegion;
        private final long blockLength;
        private static final Pattern CONDENSED_PATH_REGEX = Pattern.compile("(?<!^)(\\\\|/){2,}");
        private static final String QUOTED_FILE_SEPARATOR = Matcher.quoteReplacement(File.separator);

        private static String getSuffix(String f, String prefix) {
            if (f.startsWith(prefix)) {
                return f.substring(prefix.length());
            }
            throw new RuntimeException(prefix + " is not a prefix of " + f);
        }

        public ScanInfo(long blockId, File basePath, String blockFile, String metaFile, FsVolumeSpi vol) {
            this.blockId = blockId;
            this.basePath = basePath;
            this.blockFile = blockFile;
            this.metaFile = blockFile != null && metaFile != null ? ScanInfo.getSuffix(metaFile, blockFile) : metaFile;
            this.blockLength = blockFile != null ? new File(basePath, blockFile).length() : 0L;
            this.volume = vol;
            this.fileRegion = null;
        }

        public ScanInfo(long blockId, FsVolumeSpi vol, FileRegion fileRegion, long length) {
            this.blockId = blockId;
            this.blockLength = length;
            this.volume = vol;
            this.fileRegion = fileRegion;
            this.basePath = null;
            this.blockFile = null;
            this.metaFile = null;
        }

        public File getBlockFile() {
            return this.blockFile == null ? null : new File(this.basePath.getAbsolutePath(), this.blockFile);
        }

        public long getBlockLength() {
            return this.blockLength;
        }

        public File getMetaFile() {
            if (this.metaFile == null) {
                return null;
            }
            return new File(this.basePath.getAbsolutePath(), this.fullMetaFile());
        }

        public long getBlockId() {
            return this.blockId;
        }

        public FsVolumeSpi getVolume() {
            return this.volume;
        }

        @Override
        public int compareTo(ScanInfo b) {
            return Long.compare(this.blockId, b.blockId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScanInfo)) {
                return false;
            }
            return this.blockId == ((ScanInfo)o).blockId;
        }

        public int hashCode() {
            return Long.hashCode(this.blockId);
        }

        public long getGenStamp() {
            return this.metaFile != null ? Block.getGenerationStamp((String)this.fullMetaFile()) : 0L;
        }

        public FileRegion getFileRegion() {
            return this.fileRegion;
        }

        private String fullMetaFile() {
            if (this.metaFile == null) {
                return null;
            }
            if (this.blockFile == null) {
                return this.metaFile;
            }
            return this.blockFile + this.metaFile;
        }
    }

    public static interface BlockIterator
    extends Closeable {
        public ExtendedBlock nextBlock() throws IOException;

        public boolean atEnd();

        public void rewind();

        public void save() throws IOException;

        public void setMaxStalenessMs(long var1);

        public long getIterStartMs();

        public long getLastSavedMs();

        public String getBlockPoolId();
    }
}

