"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat) => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeSQLQuery", async request => {
      return this.describeQueryInternal(request, 'sql.sqlQuery', 'json');
    });

    _defineProperty(this, "describePPLQuery", async request => {
      return this.describeQueryInternal(request, 'sql.pplQuery', 'json');
    });

    _defineProperty(this, "describeSQLCsv", async request => {
      return this.describeQueryInternal(request, 'sql.sqlCsv', null);
    });

    _defineProperty(this, "describePPLCsv", async request => {
      return this.describeQueryInternal(request, 'sql.pplCsv', null);
    });

    _defineProperty(this, "describeSQLJson", async request => {
      return this.describeQueryInternal(request, 'sql.sqlJson', 'json');
    });

    _defineProperty(this, "describePPLJson", async request => {
      return this.describeQueryInternal(request, 'sql.pplJson', 'json');
    });

    _defineProperty(this, "describeSQLText", async request => {
      return this.describeQueryInternal(request, 'sql.sqlText', null);
    });

    _defineProperty(this, "describePPLText", async request => {
      return this.describeQueryInternal(request, 'sql.pplText', null);
    });

    this.client = client;
  }

}

exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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