"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTraceAnalyticsDslRouter = registerTraceAnalyticsDslRouter;

var _configSchema = require("@osd/config-schema");

var _trace_analytics = require("../../common/constants/trace_analytics");

var _metrics_helper = require("../common/metrics/metrics_helper");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerTraceAnalyticsDslRouter(router) {
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE,
    validate: false
  }, async (context, request, response) => {
    const params = {
      index: [_trace_analytics.DATA_PREPPER_INDEX_NAME, _trace_analytics.DATA_PREPPER_SERVICE_INDEX_NAME],
      allow_no_indices: false
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.exists', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE,
    validate: false
  }, async (context, request, response) => {
    const params = {
      index: [_trace_analytics.JAEGER_INDEX_NAME, _trace_analytics.JAEGER_SERVICE_INDEX_NAME],
      allow_no_indices: false
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.exists', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_DSL_ROUTE,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.maybe(_configSchema.schema.string()),
        from: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.number(),
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          bool: _configSchema.schema.object({
            filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            must: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            should: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            must_not: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            minimum_should_match: _configSchema.schema.maybe(_configSchema.schema.number()),
            adjust_pure_negative: _configSchema.schema.maybe(_configSchema.schema.boolean()),
            boost: _configSchema.schema.maybe(_configSchema.schema.any())
          })
        })),
        aggs: _configSchema.schema.maybe(_configSchema.schema.any()),
        aggregations: _configSchema.schema.maybe(_configSchema.schema.any()),
        sort: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
        _source: _configSchema.schema.maybe(_configSchema.schema.object({
          includes: _configSchema.schema.arrayOf(_configSchema.schema.string())
        })),
        script_fields: _configSchema.schema.maybe(_configSchema.schema.any())
      })
    }
  }, async (context, request, response) => {
    (0, _metrics_helper.addRequestToMetric)('trace_analytics', 'get', 'count');
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index: index || _trace_analytics.DATA_PREPPER_INDEX_NAME,
      size,
      body: rest
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      (0, _metrics_helper.addRequestToMetric)('trace_analytics', 'get', error);
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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