"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEK_IN_MILLI_SECS = exports.SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = exports.STACK_TRACE_PATTERN = exports.SORT_DIRECTION = exports.SEC_IN_MILLI_SECS = exports.SAMPLE_TYPE = exports.REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPES = exports.OPENSEARCH_EXCEPTION_PREFIX = exports.MODEL_ID_FIELD = exports.MIN_IN_MILLI_SECS = exports.MAX_MONITORS = exports.MAX_FORECASTER = exports.MAX_DETECTORS = exports.MAX_ANOMALY_GRADE_FIELD = exports.MAX_ALERTS = exports.KEY_FIELD = exports.HOUR_IN_MILLI_SECS = exports.HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPES = exports.HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.FORECAST_RUN_ONCE_TASK_TYPES = exports.FORECAST_REALTIME_TASK_TYPES = exports.FORECAST_API_ROUTE_PREFIX = exports.FORECASTER_STATE_TO_DISPLAY = exports.FORECASTER_STATE_DISPLAY = exports.FORECASTER_STATE = exports.FORECASTER_DOC_FIELDS = exports.ENTITY_VALUE_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = exports.ENTITY_LIST_FIELD = exports.ENTITY_LIST_DELIMITER = exports.ENTITY_FIELD = exports.DOC_COUNT_FIELD = exports.DETECTOR_STATE = exports.DETECTORS_QUERY_PARAMS = exports.DEFAULT_HEADERS = exports.DEFAULT_FORECAST_RESULT_INDEX_WILDCARD = exports.DAY_IN_MILLI_SECS = exports.CUSTOM_FORECAST_RESULT_INDEX_WILDCARD = exports.CUSTOM_FORECAST_RESULT_INDEX_PREFIX = exports.CUSTOM_FORECASTER_RESULT_INDEX_PREFIX = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CLUSTER = exports.API = exports.ALERTING_API_ROUTE_PREFIX = exports.AD_DOC_FIELDS = exports.AD_API_ROUTE_PREFIX = void 0;
exports.isActiveState = isActiveState;
exports.isForecasterErrorState = void 0;
exports.isTestState = isTestState;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const AD_API_ROUTE_PREFIX = exports.AD_API_ROUTE_PREFIX = '/_plugins/_anomaly_detection';
const ALERTING_API_ROUTE_PREFIX = exports.ALERTING_API_ROUTE_PREFIX = '/_plugins/_alerting';
const FORECAST_API_ROUTE_PREFIX = exports.FORECAST_API_ROUTE_PREFIX = '/_plugins/_forecast';
// custom forecast result index starts with opensearch-forecast-result-
// while default forecast result index starts with opensearch-forecast-results
const DEFAULT_FORECAST_RESULT_INDEX_WILDCARD = exports.DEFAULT_FORECAST_RESULT_INDEX_WILDCARD = 'opensearch-forecast-results*';
const CUSTOM_FORECAST_RESULT_INDEX_PREFIX = exports.CUSTOM_FORECAST_RESULT_INDEX_PREFIX = 'opensearch-forecast-result-';
const CUSTOM_FORECAST_RESULT_INDEX_WILDCARD = exports.CUSTOM_FORECAST_RESULT_INDEX_WILDCARD = `${CUSTOM_FORECAST_RESULT_INDEX_PREFIX}*`;
const API = exports.API = {
  DETECTOR_BASE: `${AD_API_ROUTE_PREFIX}/detectors`,
  ALERTING_BASE: `${ALERTING_API_ROUTE_PREFIX}/monitors`,
  FORECASTER_BASE: `${FORECAST_API_ROUTE_PREFIX}/forecasters`,
  FORECAST_RESULT_SEARCH: `/${DEFAULT_FORECAST_RESULT_INDEX_WILDCARD}/_search`
};
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch Dashboards'
};
const SEC_IN_MILLI_SECS = exports.SEC_IN_MILLI_SECS = 1000;
const MIN_IN_MILLI_SECS = exports.MIN_IN_MILLI_SECS = 60 * SEC_IN_MILLI_SECS;
const HOUR_IN_MILLI_SECS = exports.HOUR_IN_MILLI_SECS = 60 * MIN_IN_MILLI_SECS;
const DAY_IN_MILLI_SECS = exports.DAY_IN_MILLI_SECS = 24 * HOUR_IN_MILLI_SECS;
const WEEK_IN_MILLI_SECS = exports.WEEK_IN_MILLI_SECS = 7 * DAY_IN_MILLI_SECS;
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["AES_AD"] = "aes_ad";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
let SORT_DIRECTION = exports.SORT_DIRECTION = /*#__PURE__*/function (SORT_DIRECTION) {
  SORT_DIRECTION["ASC"] = "asc";
  SORT_DIRECTION["DESC"] = "desc";
  return SORT_DIRECTION;
}({});
let DETECTORS_QUERY_PARAMS = exports.DETECTORS_QUERY_PARAMS = /*#__PURE__*/function (DETECTORS_QUERY_PARAMS) {
  DETECTORS_QUERY_PARAMS["FROM"] = "from";
  DETECTORS_QUERY_PARAMS["SIZE"] = "size";
  DETECTORS_QUERY_PARAMS["SEARCH"] = "search";
  DETECTORS_QUERY_PARAMS["INDICES"] = "indices";
  DETECTORS_QUERY_PARAMS["SORT_FIELD"] = "sortField";
  DETECTORS_QUERY_PARAMS["SORT_DIRECTION"] = "sortDirection";
  DETECTORS_QUERY_PARAMS["NAME"] = "name";
  DETECTORS_QUERY_PARAMS["DATASOURCEID"] = "dataSourceId";
  return DETECTORS_QUERY_PARAMS;
}({});
let AD_DOC_FIELDS = exports.AD_DOC_FIELDS = /*#__PURE__*/function (AD_DOC_FIELDS) {
  AD_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  AD_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  AD_DOC_FIELDS["DETECTOR_ID"] = "detector_id";
  AD_DOC_FIELDS["TASK_ID"] = "task_id";
  AD_DOC_FIELDS["DETECTOR_NAME"] = "name";
  AD_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  AD_DOC_FIELDS["ANOMALY_GRADE"] = "anomaly_grade";
  AD_DOC_FIELDS["ERROR"] = "error";
  AD_DOC_FIELDS["INDICES"] = "indices";
  return AD_DOC_FIELDS;
}({});
const MAX_DETECTORS = exports.MAX_DETECTORS = 1000;
const MAX_FORECASTER = exports.MAX_FORECASTER = 1000;
const MAX_MONITORS = exports.MAX_MONITORS = 1000;
const MAX_ALERTS = exports.MAX_ALERTS = 1000;

// TODO: maybe move types/interfaces/constants/helpers shared between client and server
// side as many as possible into single place
let DETECTOR_STATE = exports.DETECTOR_STATE = /*#__PURE__*/function (DETECTOR_STATE) {
  DETECTOR_STATE["DISABLED"] = "Stopped";
  DETECTOR_STATE["INIT"] = "Initializing";
  DETECTOR_STATE["RUNNING"] = "Running";
  DETECTOR_STATE["FINISHED"] = "Finished";
  DETECTOR_STATE["FEATURE_REQUIRED"] = "Feature required";
  DETECTOR_STATE["INIT_FAILURE"] = "Initialization failure";
  DETECTOR_STATE["UNEXPECTED_FAILURE"] = "Unexpected failure";
  DETECTOR_STATE["FAILED"] = "Failed";
  return DETECTOR_STATE;
}({}); // The keys are INACTIVE_STOPPED, etc.
// The values are Inactive, etc.
let FORECASTER_STATE = exports.FORECASTER_STATE = /*#__PURE__*/function (FORECASTER_STATE) {
  FORECASTER_STATE["INACTIVE_STOPPED"] = "Inactive stopped";
  FORECASTER_STATE["INACTIVE_NOT_STARTED"] = "Inactive not started";
  FORECASTER_STATE["AWAITING_DATA_TO_INIT"] = "Awaiting data to init";
  FORECASTER_STATE["AWAITING_DATA_TO_RESTART"] = "Awaiting data to restart";
  FORECASTER_STATE["INIT_TEST"] = "Initializing test";
  FORECASTER_STATE["INITIALIZING_FORECAST"] = "Initializing forecast";
  FORECASTER_STATE["TEST_COMPLETE"] = "Test complete";
  FORECASTER_STATE["RUNNING"] = "Running";
  FORECASTER_STATE["INIT_ERROR"] = "Init forecast failure";
  FORECASTER_STATE["FORECAST_FAILURE"] = "Forecast failure";
  FORECASTER_STATE["INIT_TEST_FAILED"] = "Init test failure";
  return FORECASTER_STATE;
}({});
let FORECASTER_STATE_DISPLAY = exports.FORECASTER_STATE_DISPLAY = /*#__PURE__*/function (FORECASTER_STATE_DISPLAY) {
  FORECASTER_STATE_DISPLAY["INACTIVE_STOPPED"] = "Inactive";
  FORECASTER_STATE_DISPLAY["INACTIVE_NOT_STARTED"] = "Inactive";
  FORECASTER_STATE_DISPLAY["AWAITING_DATA_TO_INIT"] = "Awaiting data";
  FORECASTER_STATE_DISPLAY["AWAITING_DATA_TO_RESTART"] = "Awaiting data";
  FORECASTER_STATE_DISPLAY["INITIALIZING_TEST"] = "Initializing...";
  FORECASTER_STATE_DISPLAY["INITIALIZING_FORECAST"] = "Initializing...";
  FORECASTER_STATE_DISPLAY["TEST_COMPLETE"] = "Test complete";
  FORECASTER_STATE_DISPLAY["RUNNING"] = "Running";
  FORECASTER_STATE_DISPLAY["INIT_FORECAST_FAILURE"] = "Error";
  FORECASTER_STATE_DISPLAY["FORECAST_FAILURE"] = "Error";
  FORECASTER_STATE_DISPLAY["INIT_TEST_FAILURE"] = "Error";
  return FORECASTER_STATE_DISPLAY;
}({});
const FORECASTER_STATE_TO_DISPLAY = exports.FORECASTER_STATE_TO_DISPLAY = {
  [FORECASTER_STATE.INACTIVE_STOPPED]: FORECASTER_STATE_DISPLAY.INACTIVE_STOPPED,
  [FORECASTER_STATE.INACTIVE_NOT_STARTED]: FORECASTER_STATE_DISPLAY.INACTIVE_NOT_STARTED,
  [FORECASTER_STATE.AWAITING_DATA_TO_INIT]: FORECASTER_STATE_DISPLAY.AWAITING_DATA_TO_INIT,
  [FORECASTER_STATE.AWAITING_DATA_TO_RESTART]: FORECASTER_STATE_DISPLAY.AWAITING_DATA_TO_RESTART,
  [FORECASTER_STATE.INIT_TEST]: FORECASTER_STATE_DISPLAY.INITIALIZING_TEST,
  [FORECASTER_STATE.INITIALIZING_FORECAST]: FORECASTER_STATE_DISPLAY.INITIALIZING_FORECAST,
  [FORECASTER_STATE.TEST_COMPLETE]: FORECASTER_STATE_DISPLAY.TEST_COMPLETE,
  [FORECASTER_STATE.RUNNING]: FORECASTER_STATE_DISPLAY.RUNNING,
  [FORECASTER_STATE.INIT_ERROR]: FORECASTER_STATE_DISPLAY.INIT_FORECAST_FAILURE,
  [FORECASTER_STATE.FORECAST_FAILURE]: FORECASTER_STATE_DISPLAY.FORECAST_FAILURE,
  [FORECASTER_STATE.INIT_TEST_FAILED]: FORECASTER_STATE_DISPLAY.INIT_TEST_FAILURE
};
let SAMPLE_TYPE = exports.SAMPLE_TYPE = /*#__PURE__*/function (SAMPLE_TYPE) {
  SAMPLE_TYPE["HTTP_RESPONSES"] = "http-responses";
  SAMPLE_TYPE["HOST_HEALTH"] = "host-health";
  SAMPLE_TYPE["ECOMMERCE"] = "ecommerce";
  return SAMPLE_TYPE;
}({});
const ENTITY_FIELD = exports.ENTITY_FIELD = 'entity';
const ENTITY_VALUE_PATH_FIELD = exports.ENTITY_VALUE_PATH_FIELD = 'entity.value';
const ENTITY_NAME_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = 'entity.name';
const MODEL_ID_FIELD = exports.MODEL_ID_FIELD = 'model_id';
const DOC_COUNT_FIELD = exports.DOC_COUNT_FIELD = 'doc_count';
const KEY_FIELD = exports.KEY_FIELD = 'key';
const ENTITY_LIST_FIELD = exports.ENTITY_LIST_FIELD = 'entity_list';
const MAX_ANOMALY_GRADE_FIELD = exports.MAX_ANOMALY_GRADE_FIELD = 'max_anomaly_grade';

// y-axis values in the heatmap chart should be in the form:
// <category-field-value-1><br><category-field-value-2>
const ENTITY_LIST_DELIMITER = exports.ENTITY_LIST_DELIMITER = '<br>';

// when hovering over a cell, the entity list should be in the form:
// <category-field-name-1>: <category-field-value-1>, <category-field-name-2>: <category-field-value-2>
const HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CELL_ENTITY_DELIMITER = ', ';
const HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = ': ';
const STACK_TRACE_PATTERN = exports.STACK_TRACE_PATTERN = '.java:';
const OPENSEARCH_EXCEPTION_PREFIX = exports.OPENSEARCH_EXCEPTION_PREFIX = 'org.opensearch.OpenSearchException: ';
const REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPE_PREFIX = 'REALTIME';
const HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPE_PREFIX = 'HISTORICAL';
const REALTIME_TASK_TYPES = exports.REALTIME_TASK_TYPES = ['REALTIME_HC_DETECTOR', 'REALTIME_SINGLE_ENTITY'];
const HISTORICAL_TASK_TYPES = exports.HISTORICAL_TASK_TYPES = ['HISTORICAL_SINGLE_ENTITY', 'HISTORICAL_HC_DETECTOR', 'HISTORICAL'];
const FORECAST_REALTIME_TASK_TYPES = exports.FORECAST_REALTIME_TASK_TYPES = ['REALTIME_FORECAST_HC_FORECASTER', 'REALTIME_FORECAST_SINGLE_STREAM'];
const FORECAST_RUN_ONCE_TASK_TYPES = exports.FORECAST_RUN_ONCE_TASK_TYPES = ['RUN_ONCE_FORECAST_HC_FORECASTER', 'RUN_ONCE_FORECAST_SINGLE_STREAM'];
const CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = 'opensearch-ad-plugin-result-';
const CUSTOM_FORECASTER_RESULT_INDEX_PREFIX = exports.CUSTOM_FORECASTER_RESULT_INDEX_PREFIX = 'opensearch-forecast-result-';
const SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = exports.SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = 'os_suggest_ad';
let FORECASTER_DOC_FIELDS = exports.FORECASTER_DOC_FIELDS = /*#__PURE__*/function (FORECASTER_DOC_FIELDS) {
  FORECASTER_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  FORECASTER_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  FORECASTER_DOC_FIELDS["FORECASTER_ID"] = "forecaster_id";
  FORECASTER_DOC_FIELDS["TASK_ID"] = "task_id";
  FORECASTER_DOC_FIELDS["FORECASTER_NAME"] = "name";
  FORECASTER_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  FORECASTER_DOC_FIELDS["FORECAST_VALUE"] = "forecast_value";
  FORECASTER_DOC_FIELDS["FORECAST_LOWER_BOUND"] = "forecast_lower_bound";
  FORECASTER_DOC_FIELDS["FORECAST_UPPER_BOUND"] = "forecast_upper_bound";
  FORECASTER_DOC_FIELDS["ERROR"] = "error";
  FORECASTER_DOC_FIELDS["INDICES"] = "indices";
  FORECASTER_DOC_FIELDS["EXECUTION_END_TIME"] = "execution_end_time";
  FORECASTER_DOC_FIELDS["FORECAST_DATA_END_TIME"] = "forecast_data_end_time";
  return FORECASTER_DOC_FIELDS;
}({});
const isForecasterErrorState = state => {
  return [FORECASTER_STATE.INIT_ERROR, FORECASTER_STATE.FORECAST_FAILURE, FORECASTER_STATE.INIT_TEST_FAILED].includes(state);
};
exports.isForecasterErrorState = isForecasterErrorState;
function isActiveState(state) {
  if (!state) return false;
  return state.startsWith('AWAITING_') || state === FORECASTER_STATE.RUNNING || state === FORECASTER_STATE.INITIALIZING_FORECAST;
}
function isTestState(state) {
  return state === FORECASTER_STATE.INIT_TEST || state === FORECASTER_STATE.TEST_COMPLETE;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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