"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerProxyService = void 0;
const monaco_1 = require("../monaco");
const constants_1 = require("./constants");
class WorkerProxyService {
    async getAnnos(modelUri) {
        if (!this.worker) {
            throw new Error('Worker Proxy Service has not been setup!');
        }
        await this.worker.withSyncedResources([modelUri]);
        const proxy = await this.worker.getProxy();
        return proxy.parse(modelUri.toString());
    }
    setup() {
        this.worker = monaco_1.monaco.editor.createWebWorker({ label: constants_1.ID, moduleId: '' });
    }
    stop() {
        if (this.worker)
            this.worker.dispose();
    }
}
exports.WorkerProxyService = WorkerProxyService;
//# sourceMappingURL=worker_proxy_service.js.map