/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.common.exception.InternalFailure;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.transport.DeleteModelAction;
import org.opensearch.ad.transport.DeleteModelRequest;
import org.opensearch.ad.transport.StopDetectorAction;
import org.opensearch.ad.transport.StopDetectorRequest;
import org.opensearch.ad.transport.StopDetectorResponse;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class StopDetectorTransportAction
extends HandledTransportAction<ActionRequest, StopDetectorResponse> {
    private static final Logger LOG = LogManager.getLogger(StopDetectorTransportAction.class);
    private final Client client;
    private final DiscoveryNodeFilterer nodeFilter;

    @Inject
    public StopDetectorTransportAction(TransportService transportService, DiscoveryNodeFilterer nodeFilter, ActionFilters actionFilters, Client client) {
        super(StopDetectorAction.NAME, transportService, actionFilters, StopDetectorRequest::new);
        this.client = client;
        this.nodeFilter = nodeFilter;
    }

    protected void doExecute(Task task, ActionRequest actionRequest, ActionListener<StopDetectorResponse> listener) {
        StopDetectorRequest request = StopDetectorRequest.fromActionRequest(actionRequest);
        String adID = request.getAdID();
        try {
            DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
            DeleteModelRequest modelDeleteRequest = new DeleteModelRequest(adID, dataNodes);
            this.client.execute((ActionType)DeleteModelAction.INSTANCE, (ActionRequest)modelDeleteRequest, ActionListener.wrap(response -> {
                if (response.hasFailures()) {
                    LOG.warn("Cannot delete all models of detector {}", (Object)adID);
                    for (FailedNodeException failedNodeException : response.failures()) {
                        LOG.warn("Deleting models of node has exception", (Throwable)failedNodeException);
                    }
                    listener.onResponse((Object)new StopDetectorResponse(false));
                } else {
                    LOG.info("models of detector {} get deleted", (Object)adID);
                    listener.onResponse((Object)new StopDetectorResponse(true));
                }
            }, exception -> {
                LOG.error((Message)new ParameterizedMessage("Deletion of detector [{}] has exception.", (Object)adID), (Throwable)exception);
                listener.onResponse((Object)new StopDetectorResponse(false));
            }));
        }
        catch (Exception e) {
            LOG.error(CommonErrorMessages.FAIL_TO_STOP_DETECTOR + " " + adID, (Throwable)e);
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            listener.onFailure((Exception)new InternalFailure(adID, CommonErrorMessages.FAIL_TO_STOP_DETECTOR, cause));
        }
    }
}

