/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.ad.cluster.ADVersionUtil;
import org.opensearch.ad.common.exception.ADVersionException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskAction;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectionDateRange;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ForwardADTaskRequest
extends ActionRequest {
    private AnomalyDetector detector;
    private ADTask adTask;
    private DetectionDateRange detectionDateRange;
    private List<String> staleRunningEntities;
    private User user;
    private Integer availableTaskSlots;
    private ADTaskAction adTaskAction;

    public ForwardADTaskRequest(AnomalyDetector detector, DetectionDateRange detectionDateRange, User user, ADTaskAction adTaskAction, Integer availableTaskSlots, Version remoteAdVersion) {
        if (!ADVersionUtil.compatibleWithVersionOnOrAfter1_1(remoteAdVersion)) {
            throw new ADVersionException(detector.getDetectorId(), "Can't forward AD task request to node running AD version " + remoteAdVersion);
        }
        this.detector = detector;
        this.detectionDateRange = detectionDateRange;
        this.user = user;
        this.availableTaskSlots = availableTaskSlots;
        this.adTaskAction = adTaskAction;
    }

    public ForwardADTaskRequest(AnomalyDetector detector, DetectionDateRange detectionDateRange, User user, ADTaskAction adTaskAction) {
        this.detector = detector;
        this.detectionDateRange = detectionDateRange;
        this.user = user;
        this.adTaskAction = adTaskAction;
    }

    public ForwardADTaskRequest(ADTask adTask, ADTaskAction adTaskAction) {
        this(adTask, adTaskAction, null);
    }

    public ForwardADTaskRequest(ADTask adTask, Integer availableTaskSLots, ADTaskAction adTaskAction) {
        this(adTask, adTaskAction, null);
        this.availableTaskSlots = availableTaskSLots;
    }

    public ForwardADTaskRequest(ADTask adTask, ADTaskAction adTaskAction, List<String> staleRunningEntities) {
        this.adTask = adTask;
        this.adTaskAction = adTaskAction;
        if (adTask != null) {
            this.detector = adTask.getDetector();
        }
        this.staleRunningEntities = staleRunningEntities;
    }

    public ForwardADTaskRequest(StreamInput in) throws IOException {
        super(in);
        this.detector = new AnomalyDetector(in);
        if (in.readBoolean()) {
            this.user = new User(in);
        }
        this.adTaskAction = (ADTaskAction)in.readEnum(ADTaskAction.class);
        if (in.available() == 0) {
            throw new ADVersionException("Can't process ForwardADTaskRequest of old version");
        }
        if (in.readBoolean()) {
            this.adTask = new ADTask(in);
        }
        if (in.readBoolean()) {
            this.detectionDateRange = new DetectionDateRange(in);
        }
        this.staleRunningEntities = in.readOptionalStringList();
        this.availableTaskSlots = in.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.detector.writeTo(out);
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeEnum((Enum)this.adTaskAction);
        if (this.adTask != null) {
            out.writeBoolean(true);
            this.adTask.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.detectionDateRange != null) {
            out.writeBoolean(true);
            this.detectionDateRange.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalStringCollection(this.staleRunningEntities);
        out.writeOptionalInt(this.availableTaskSlots);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.detector == null) {
            validationException = ValidateActions.addValidationError((String)CommonErrorMessages.DETECTOR_MISSING, validationException);
        } else if (this.detector.getDetectorId() == null) {
            validationException = ValidateActions.addValidationError((String)"AD ID is missing", (ActionRequestValidationException)validationException);
        }
        if (this.adTaskAction == null) {
            validationException = ValidateActions.addValidationError((String)CommonErrorMessages.AD_TASK_ACTION_MISSING, (ActionRequestValidationException)validationException);
        }
        if (this.adTaskAction == ADTaskAction.CLEAN_STALE_RUNNING_ENTITIES && (this.staleRunningEntities == null || this.staleRunningEntities.isEmpty())) {
            validationException = ValidateActions.addValidationError((String)CommonErrorMessages.EMPTY_STALE_RUNNING_ENTITIES, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public AnomalyDetector getDetector() {
        return this.detector;
    }

    public ADTask getAdTask() {
        return this.adTask;
    }

    public DetectionDateRange getDetectionDateRange() {
        return this.detectionDateRange;
    }

    public User getUser() {
        return this.user;
    }

    public ADTaskAction getAdTaskAction() {
        return this.adTaskAction;
    }

    public List<String> getStaleRunningEntities() {
        return this.staleRunningEntities;
    }

    public Integer getAvailableTaskSLots() {
        return this.availableTaskSlots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ForwardADTaskRequest request = (ForwardADTaskRequest)((Object)o);
        return Objects.equals(this.detector, request.detector) && Objects.equals(this.adTask, request.adTask) && Objects.equals(this.detectionDateRange, request.detectionDateRange) && Objects.equals(this.staleRunningEntities, request.staleRunningEntities) && Objects.equals(this.user, request.user) && Objects.equals(this.availableTaskSlots, request.availableTaskSlots) && this.adTaskAction == request.adTaskAction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detector, this.adTask, this.detectionDateRange, this.staleRunningEntities, this.user, this.availableTaskSlots, this.adTaskAction});
    }
}

