/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.ad.ExpiringState;
import org.opensearch.ad.ml.EntityModel;

public class ModelState<T>
implements ExpiringState {
    public static String MODEL_TYPE_KEY = "model_type";
    public static String LAST_USED_TIME_KEY = "last_used_time";
    public static String LAST_CHECKPOINT_TIME_KEY = "last_checkpoint_time";
    public static String PRIORITY_KEY = "priority";
    private T model;
    private String modelId;
    private String detectorId;
    private String modelType;
    private Instant lastUsedTime;
    private Instant lastCheckpointTime;
    private Clock clock;
    private float priority;

    public ModelState(T model, String modelId, String detectorId, String modelType, Clock clock, float priority) {
        this.model = model;
        this.modelId = modelId;
        this.detectorId = detectorId;
        this.modelType = modelType;
        this.lastUsedTime = clock.instant();
        this.lastCheckpointTime = Instant.MIN;
        this.clock = clock;
        this.priority = priority;
    }

    public static <T> ModelState<T> createSingleEntityModelState(T model, String modelId, String detectorId, String modelType, Clock clock) {
        return new ModelState<T>(model, modelId, detectorId, modelType, clock, 0.0f);
    }

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Instant getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(Instant lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
    }

    public Instant getLastCheckpointTime() {
        return this.lastCheckpointTime;
    }

    public void setLastCheckpointTime(Instant lastCheckpointTime) {
        this.lastCheckpointTime = lastCheckpointTime;
    }

    public float getPriority() {
        return this.priority;
    }

    public void setPriority(float priority) {
        this.priority = priority;
    }

    public Map<String, Object> getModelStateAsMap() {
        return new HashMap<String, Object>(){
            {
                EntityModel summary;
                this.put("model_id", ModelState.this.modelId);
                this.put("detector_id", ModelState.this.detectorId);
                this.put(MODEL_TYPE_KEY, ModelState.this.modelType);
                this.put(LAST_USED_TIME_KEY, ModelState.this.lastUsedTime.toEpochMilli());
                if (ModelState.this.lastCheckpointTime != Instant.MIN) {
                    this.put(LAST_CHECKPOINT_TIME_KEY, ModelState.this.lastCheckpointTime.toEpochMilli());
                }
                if (ModelState.this.model != null && ModelState.this.model instanceof EntityModel && (summary = (EntityModel)ModelState.this.model).getEntity().isPresent()) {
                    this.put("entity", summary.getEntity().get().toStat());
                }
            }
        };
    }

    @Override
    public boolean expired(Duration stateTtl) {
        return this.expired(this.lastUsedTime, stateTtl, this.clock.instant());
    }
}

