/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.feature;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.ad.CleanState;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.dataprocessor.Interpolator;
import org.opensearch.ad.feature.Features;
import org.opensearch.ad.feature.SearchFeatureDao;
import org.opensearch.ad.feature.SinglePointFeatures;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.Entity;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;

public class FeatureManager
implements CleanState {
    private static final Logger logger = LogManager.getLogger(FeatureManager.class);
    private final Map<String, ArrayDeque<Map.Entry<Long, Optional<double[]>>>> detectorIdsToTimeShingles;
    private final SearchFeatureDao searchFeatureDao;
    private final Interpolator interpolator;
    private final Clock clock;
    private final int maxTrainSamples;
    private final int maxSampleStride;
    private final int trainSampleTimeRangeInHours;
    private final int minTrainSamples;
    private final double maxMissingPointsRate;
    private final int maxNeighborDistance;
    private final double previewSampleRate;
    private final int maxPreviewSamples;
    private final Duration featureBufferTtl;
    private final ThreadPool threadPool;
    private final String adThreadPoolName;

    public FeatureManager(SearchFeatureDao searchFeatureDao, Interpolator interpolator, Clock clock, int maxTrainSamples, int maxSampleStride, int trainSampleTimeRangeInHours, int minTrainSamples, double maxMissingPointsRate, int maxNeighborDistance, double previewSampleRate, int maxPreviewSamples, Duration featureBufferTtl, ThreadPool threadPool, String adThreadPoolName) {
        this.searchFeatureDao = searchFeatureDao;
        this.interpolator = interpolator;
        this.clock = clock;
        this.maxTrainSamples = maxTrainSamples;
        this.maxSampleStride = maxSampleStride;
        this.trainSampleTimeRangeInHours = trainSampleTimeRangeInHours;
        this.minTrainSamples = minTrainSamples;
        this.maxMissingPointsRate = maxMissingPointsRate;
        this.maxNeighborDistance = maxNeighborDistance;
        this.previewSampleRate = previewSampleRate;
        this.maxPreviewSamples = maxPreviewSamples;
        this.featureBufferTtl = featureBufferTtl;
        this.detectorIdsToTimeShingles = new ConcurrentHashMap<String, ArrayDeque<Map.Entry<Long, Optional<double[]>>>>();
        this.threadPool = threadPool;
        this.adThreadPoolName = adThreadPoolName;
    }

    public void getCurrentFeatures(AnomalyDetector detector, long startTime, long endTime, ActionListener<SinglePointFeatures> listener) {
        long maxTimeDifference;
        int shingleSize = detector.getShingleSize();
        Deque shingle = this.detectorIdsToTimeShingles.computeIfAbsent(detector.getDetectorId(), id -> new ArrayDeque(shingleSize));
        Map<Long, Map.Entry<Long, Optional<double[]>>> featuresMap = this.getNearbyPointsForShingle(detector, shingle, endTime, maxTimeDifference = detector.getDetectorIntervalInMilliseconds() / 2L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<Map.Entry<Long, Long>> missingRanges = this.getMissingRangesInShingle(detector, featuresMap, endTime);
        if (missingRanges.size() > 0) {
            try {
                this.searchFeatureDao.getFeatureSamplesForPeriods(detector, missingRanges, (ActionListener<List<Optional<double[]>>>)ActionListener.wrap(points -> {
                    for (int i = 0; i < points.size(); ++i) {
                        Optional point = (Optional)points.get(i);
                        long rangeEndTime = (Long)((Map.Entry)missingRanges.get(i)).getValue();
                        featuresMap.put(rangeEndTime, new AbstractMap.SimpleImmutableEntry<Long, Optional>(rangeEndTime, point));
                    }
                    this.updateUnprocessedFeatures(detector, shingle, featuresMap, endTime, listener);
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (IOException e) {
                listener.onFailure((Exception)new EndRunException(detector.getDetectorId(), "Invalid search query.", e, true));
            }
        } else {
            listener.onResponse((Object)this.getProcessedFeatures(shingle, detector, endTime));
        }
    }

    private List<Map.Entry<Long, Long>> getMissingRangesInShingle(AnomalyDetector detector, Map<Long, Map.Entry<Long, Optional<double[]>>> featuresMap, long endTime) {
        long intervalMilli = detector.getDetectorIntervalInMilliseconds();
        int shingleSize = detector.getShingleSize();
        return this.getFullShingleEndTimes(endTime, intervalMilli, shingleSize).filter(time -> !featuresMap.containsKey(time)).mapToObj(time -> new AbstractMap.SimpleImmutableEntry<Long, Long>(time - intervalMilli, time)).collect(Collectors.toList());
    }

    private void updateUnprocessedFeatures(AnomalyDetector detector, Deque<Map.Entry<Long, Optional<double[]>>> shingle, Map<Long, Map.Entry<Long, Optional<double[]>>> featuresMap, long endTime, ActionListener<SinglePointFeatures> listener) {
        shingle.clear();
        this.getFullShingleEndTimes(endTime, detector.getDetectorIntervalInMilliseconds(), detector.getShingleSize()).mapToObj(time -> featuresMap.getOrDefault(time, new AbstractMap.SimpleImmutableEntry(time, Optional.empty()))).forEach(e -> shingle.add((Map.Entry<Long, Optional<double[]>>)e));
        listener.onResponse((Object)this.getProcessedFeatures(shingle, detector, endTime));
    }

    private double[][] filterAndFill(Deque<Map.Entry<Long, Optional<double[]>>> shingle, long endTime, AnomalyDetector detector) {
        long maxMillisecondsDifference;
        int shingleSize = detector.getShingleSize();
        Deque filteredShingle = shingle.stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toCollection(ArrayDeque::new));
        double[][] result = null;
        if (filteredShingle.size() >= shingleSize - this.getMaxMissingPoints(shingleSize) && (result = (double[][])this.getNearbyPointsForShingle(detector, filteredShingle, endTime, maxMillisecondsDifference = (long)this.maxNeighborDistance * detector.getDetectorIntervalInMilliseconds()).map(e -> ((Optional)((Map.Entry)e.getValue()).getValue()).orElse(null)).filter(d -> d != null).toArray(x$0 -> new double[x$0][])).length < shingleSize) {
            result = null;
        }
        return result;
    }

    private Stream<Map.Entry<Long, Map.Entry<Long, Optional<double[]>>>> getNearbyPointsForShingle(AnomalyDetector detector, Deque<Map.Entry<Long, Optional<double[]>>> shingle, long endTime, long maxMillisecondsDifference) {
        long intervalMilli = detector.getDetectorIntervalInMilliseconds();
        int shingleSize = detector.getShingleSize();
        TreeMap<Long, Optional> search = new TreeMap<Long, Optional>(shingle.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return this.getFullShingleEndTimes(endTime, intervalMilli, shingleSize).mapToObj(t -> {
            Optional after = Optional.ofNullable(search.ceilingEntry(t));
            Optional before = Optional.ofNullable(search.floorEntry(t));
            return after.filter(a -> Math.abs(t - (Long)a.getKey()) <= before.map(b -> Math.abs(t - (Long)b.getKey())).orElse(Long.MAX_VALUE)).map(Optional::of).orElse(before).filter(e -> Math.abs(t - (Long)e.getKey()) < maxMillisecondsDifference).map(e -> new AbstractMap.SimpleImmutableEntry<Long, Map.Entry>(t, (Map.Entry)e));
        }).filter(Optional::isPresent).map(Optional::get);
    }

    private LongStream getFullShingleEndTimes(long endTime, long intervalMilli, int shingleSize) {
        return LongStream.rangeClosed(1L, shingleSize).map(i -> endTime - ((long)shingleSize - i) * intervalMilli);
    }

    public void getColdStartData(AnomalyDetector detector, ActionListener<Optional<double[][]>> listener) {
        ActionListener latestTimeListener = ActionListener.wrap(latest -> this.getColdStartSamples((Optional<Long>)latest, detector, listener), arg_0 -> listener.onFailure(arg_0));
        this.searchFeatureDao.getLatestDataTime(detector, (ActionListener<Optional<Long>>)new ThreadedActionListener(logger, this.threadPool, this.adThreadPoolName, latestTimeListener, false));
    }

    private void getColdStartSamples(Optional<Long> latest, AnomalyDetector detector, ActionListener<Optional<double[][]>> listener) {
        int shingleSize = detector.getShingleSize();
        if (latest.isPresent()) {
            List<Map.Entry<Long, Long>> sampleRanges = this.getColdStartSampleRanges(detector, latest.get());
            try {
                ActionListener getFeaturesListener = ActionListener.wrap(samples -> this.processColdStartSamples((List<Optional<double[]>>)samples, shingleSize, listener), arg_0 -> listener.onFailure(arg_0));
                this.searchFeatureDao.getFeatureSamplesForPeriods(detector, sampleRanges, (ActionListener<List<Optional<double[]>>>)new ThreadedActionListener(logger, this.threadPool, this.adThreadPoolName, getFeaturesListener, false));
            }
            catch (IOException e) {
                listener.onFailure((Exception)new EndRunException(detector.getDetectorId(), "Invalid search query.", e, true));
            }
        } else {
            listener.onResponse(Optional.empty());
        }
    }

    private void processColdStartSamples(List<Optional<double[]>> samples, int shingleSize, ActionListener<Optional<double[][]>> listener) {
        ArrayList shingles = new ArrayList();
        LinkedList<Optional<double[]>> currentShingle = new LinkedList<Optional<double[]>>();
        for (Optional<double[]> sample : samples) {
            currentShingle.addLast(sample);
            if (currentShingle.size() != shingleSize) continue;
            sample.ifPresent(s -> this.fillAndShingle(currentShingle, shingleSize).ifPresent(shingles::add));
            currentShingle.remove();
        }
        listener.onResponse(Optional.of((double[][])shingles.toArray((T[])new double[0][0])).filter(results -> ((double[][])results).length > 0));
    }

    private Optional<double[]> fillAndShingle(LinkedList<Optional<double[]>> shingle, int shingleSize) {
        Optional<double[]> result = null;
        if (shingle.stream().filter(s -> s.isPresent()).count() >= (long)(shingleSize - this.getMaxMissingPoints(shingleSize))) {
            TreeMap<Integer, double[]> search = new TreeMap<Integer, double[]>(IntStream.range(0, shingleSize).filter(i -> ((Optional)shingle.get(i)).isPresent()).boxed().collect(Collectors.toMap(i -> i, i -> (double[])((Optional)shingle.get((int)i)).get())));
            result = Optional.of((double[][])IntStream.range(0, shingleSize).mapToObj(i -> {
                Optional after = Optional.ofNullable(search.ceilingEntry(i));
                Optional before = Optional.ofNullable(search.floorEntry(i));
                return after.filter(a -> Math.abs(i - (Integer)a.getKey()) <= before.map(b -> Math.abs(i - (Integer)b.getKey())).orElse(Integer.MAX_VALUE)).map(Optional::of).orElse(before).filter(e -> Math.abs(i - (Integer)e.getKey()) <= this.maxNeighborDistance).map(Map.Entry::getValue).orElse(null);
            }).filter(d -> d != null).toArray(x$0 -> new double[x$0][])).filter(d -> ((double[][])d).length == shingleSize).map(d -> this.batchShingle((double[][])d, shingleSize)[0]);
        } else {
            result = Optional.empty();
        }
        return result;
    }

    private List<Map.Entry<Long, Long>> getColdStartSampleRanges(AnomalyDetector detector, long endMillis) {
        long interval = detector.getDetectorIntervalInMilliseconds();
        int numSamples = Math.max((int)(Duration.ofHours(this.trainSampleTimeRangeInHours).toMillis() / interval), this.minTrainSamples);
        return IntStream.rangeClosed(1, numSamples).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<Long, Long>(endMillis - (long)(numSamples - i + 1) * interval, endMillis - (long)(numSamples - i) * interval)).collect(Collectors.toList());
    }

    public double[][] batchShingle(double[][] points, int shingleSize) {
        if (points.length == 0 || points[0].length == 0 || points.length < shingleSize || shingleSize < 1) {
            throw new IllegalArgumentException("Invalid data for shingling.");
        }
        int numPoints = points.length;
        int dimPoint = points[0].length;
        int numShingles = numPoints - shingleSize + 1;
        int dimShingle = dimPoint * shingleSize;
        double[][] shingles = new double[numShingles][dimShingle];
        for (int i = 0; i < numShingles; ++i) {
            for (int j = 0; j < shingleSize; ++j) {
                System.arraycopy(points[i + j], 0, shingles[i], j * dimPoint, dimPoint);
            }
        }
        return shingles;
    }

    @Override
    public void clear(String detectorId) {
        this.detectorIdsToTimeShingles.remove(detectorId);
    }

    public void maintenance() {
        try {
            this.detectorIdsToTimeShingles.entrySet().removeIf(idQueue -> Optional.ofNullable((Map.Entry)((ArrayDeque)idQueue.getValue()).peekLast()).map(p -> Instant.ofEpochMilli((Long)p.getKey()).plus(this.featureBufferTtl).isBefore(this.clock.instant())).orElse(true));
        }
        catch (Exception e) {
            logger.warn("Caught exception during maintenance", (Throwable)e);
        }
    }

    public void getPreviewEntities(AnomalyDetector detector, long startTime, long endTime, ActionListener<List<Entity>> listener) {
        this.searchFeatureDao.getHighestCountEntities(detector, startTime, endTime, listener);
    }

    public void getPreviewFeaturesForEntity(AnomalyDetector detector, Entity entity, long startMilli, long endMilli, ActionListener<Features> listener) throws IOException {
        Map.Entry<List<Map.Entry<Long, Long>>, Integer> sampleRangeResults = this.getSampleRanges(detector, startMilli, endMilli);
        List<Map.Entry<Long, Long>> sampleRanges = sampleRangeResults.getKey();
        int stride = sampleRangeResults.getValue();
        int shingleSize = detector.getShingleSize();
        this.getPreviewSamplesInRangesForEntity(detector, sampleRanges, entity, this.getFeatureSamplesListener(stride, shingleSize, listener));
    }

    private ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> getFeatureSamplesListener(int stride, int shingleSize, ActionListener<Features> listener) {
        return ActionListener.wrap(samples -> {
            List searchTimeRange = (List)samples.getKey();
            if (searchTimeRange.size() == 0) {
                listener.onFailure((Exception)new IllegalArgumentException("No data to preview anomaly detection."));
                return;
            }
            double[][] sampleFeatures = (double[][])samples.getValue();
            List<Map.Entry<Long, Long>> previewRanges = this.getPreviewRanges(searchTimeRange, stride, shingleSize);
            Map.Entry<double[][], double[][]> previewFeatures = this.getPreviewFeatures(sampleFeatures, stride, shingleSize);
            listener.onResponse((Object)new Features(previewRanges, previewFeatures.getKey(), previewFeatures.getValue()));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void getPreviewFeatures(AnomalyDetector detector, long startMilli, long endMilli, ActionListener<Features> listener) throws IOException {
        Map.Entry<List<Map.Entry<Long, Long>>, Integer> sampleRangeResults = this.getSampleRanges(detector, startMilli, endMilli);
        List<Map.Entry<Long, Long>> sampleRanges = sampleRangeResults.getKey();
        int stride = sampleRangeResults.getValue();
        int shingleSize = detector.getShingleSize();
        this.getSamplesForRanges(detector, sampleRanges, this.getFeatureSamplesListener(stride, shingleSize, listener));
    }

    private Map.Entry<List<Map.Entry<Long, Long>>, Integer> getSampleRanges(AnomalyDetector detector, long startMilli, long endMilli) {
        long start = this.truncateToMinute(startMilli);
        long end = this.truncateToMinute(endMilli);
        long bucketSize = detector.getDetectorIntervalInMilliseconds();
        int numBuckets = (int)Math.floor((double)(end - start) / (double)bucketSize);
        int numSamples = (int)Math.max(Math.min((double)numBuckets * this.previewSampleRate, (double)this.maxPreviewSamples), 1.0);
        int stride = (int)Math.max(1.0, Math.floor((double)numBuckets / (double)numSamples));
        int numStrides = (int)Math.ceil((double)numBuckets / (double)stride);
        List sampleRanges = Stream.iterate(start, i -> i + (long)stride * bucketSize).limit(numStrides).map(time -> new AbstractMap.SimpleImmutableEntry<Long, Long>((Long)time, time + bucketSize)).collect(Collectors.toList());
        return new AbstractMap.SimpleImmutableEntry<List<Map.Entry<Long, Long>>, Integer>(sampleRanges, stride);
    }

    void getPreviewSamplesInRangesForEntity(AnomalyDetector detector, List<Map.Entry<Long, Long>> sampleRanges, Entity entity, ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> listener) throws IOException {
        this.searchFeatureDao.getColdStartSamplesForPeriods(detector, sampleRanges, entity, true, this.getSamplesRangesListener(sampleRanges, listener));
    }

    private ActionListener<List<Optional<double[]>>> getSamplesRangesListener(List<Map.Entry<Long, Long>> sampleRanges, ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> listener) {
        return ActionListener.wrap(featureSamples -> {
            ArrayList ranges = new ArrayList(featureSamples.size());
            ArrayList samples = new ArrayList(featureSamples.size());
            for (int i = 0; i < featureSamples.size(); ++i) {
                Map.Entry currentRange = (Map.Entry)sampleRanges.get(i);
                ((Optional)featureSamples.get(i)).ifPresent(sample -> {
                    ranges.add(currentRange);
                    samples.add(sample);
                });
            }
            listener.onResponse(new AbstractMap.SimpleImmutableEntry(ranges, (double[][])samples.toArray((T[])new double[0][0])));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    void getSamplesForRanges(AnomalyDetector detector, List<Map.Entry<Long, Long>> sampleRanges, ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> listener) throws IOException {
        this.searchFeatureDao.getFeatureSamplesForPeriods(detector, sampleRanges, this.getSamplesRangesListener(sampleRanges, listener));
    }

    private List<Map.Entry<Long, Long>> getPreviewRanges(List<Map.Entry<Long, Long>> ranges, int stride, int shingleSize) {
        double[] rangeStarts = ranges.stream().mapToDouble(Map.Entry::getKey).toArray();
        double[] rangeEnds = ranges.stream().mapToDouble(Map.Entry::getValue).toArray();
        double[] previewRangeStarts = this.interpolator.interpolate(new double[][]{rangeStarts}, stride * (ranges.size() - 1) + 1)[0];
        double[] previewRangeEnds = this.interpolator.interpolate(new double[][]{rangeEnds}, stride * (ranges.size() - 1) + 1)[0];
        List<Map.Entry<Long, Long>> previewRanges = IntStream.range(shingleSize - 1, previewRangeStarts.length).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<Long, Long>((long)previewRangeStarts[i], (long)previewRangeEnds[i])).collect(Collectors.toList());
        return previewRanges;
    }

    private Map.Entry<double[][], double[][]> getPreviewFeatures(double[][] samples, int stride, int shingleSize) {
        Map.Entry unprocessedAndProcessed = Optional.of(samples).map(m -> this.transpose((double[][])m)).map(m -> this.interpolator.interpolate((double[][])m, stride * (samples.length - 1) + 1)).map(m -> this.transpose((double[][])m)).map(m -> new AbstractMap.SimpleImmutableEntry<double[][], double[][]>((double[][])Arrays.copyOfRange(m, shingleSize - 1, ((double[][])m).length), this.batchShingle((double[][])m, shingleSize))).get();
        return unprocessedAndProcessed;
    }

    public double[][] transpose(double[][] matrix) {
        return MatrixUtils.createRealMatrix((double[][])matrix).transpose().getData();
    }

    private long truncateToMinute(long epochMillis) {
        return Instant.ofEpochMilli(epochMillis).truncatedTo(ChronoUnit.MINUTES).toEpochMilli();
    }

    private int getMaxMissingPoints(int shingleSize) {
        return (int)Math.floor((double)shingleSize * this.maxMissingPointsRate);
    }

    public int getShingleSize(String detectorId) {
        Deque shingle = this.detectorIdsToTimeShingles.get(detectorId);
        if (shingle != null) {
            return Math.toIntExact(shingle.stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).count());
        }
        return -1;
    }

    public void getFeatureDataPointsByBatch(AnomalyDetector detector, Entity entity, long startTime, long endTime, ActionListener<Map<Long, Optional<double[]>>> listener) {
        try {
            this.searchFeatureDao.getFeaturesForPeriodByBatch(detector, entity, startTime, endTime, (ActionListener<Map<Long, Optional<double[]>>>)ActionListener.wrap(points -> {
                logger.debug("features size: {}", (Object)points.size());
                listener.onResponse(points);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            logger.error("Failed to get features for detector: " + detector.getDetectorId());
            listener.onFailure(e);
        }
    }

    public SinglePointFeatures getShingledFeatureForHistoricalAnalysis(AnomalyDetector detector, Deque<Map.Entry<Long, Optional<double[]>>> shingle, Optional<double[]> dataPoint, long endTime) {
        while (shingle.size() >= detector.getShingleSize()) {
            shingle.poll();
        }
        shingle.add(new AbstractMap.SimpleEntry<Long, Optional<double[]>>(endTime, dataPoint));
        return this.getProcessedFeatures(shingle, detector, endTime);
    }

    private SinglePointFeatures getProcessedFeatures(Deque<Map.Entry<Long, Optional<double[]>>> shingle, AnomalyDetector detector, long endTime) {
        Optional<double[]> currentPoint;
        int shingleSize = detector.getShingleSize();
        return new SinglePointFeatures(currentPoint, Optional.ofNullable((currentPoint = shingle.peekLast().getValue()).isPresent() ? this.filterAndFill(shingle, endTime, detector) : null).map(points -> this.batchShingle((double[][])points, shingleSize)[0]));
    }
}

