/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.engine.DocumentMissingException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.rule.RuleEntityParser;
import org.opensearch.rule.RulePersistenceService;
import org.opensearch.rule.RuleQueryMapper;
import org.opensearch.rule.RuleUtils;
import org.opensearch.rule.action.CreateRuleRequest;
import org.opensearch.rule.action.CreateRuleResponse;
import org.opensearch.rule.action.DeleteRuleRequest;
import org.opensearch.rule.action.GetRuleRequest;
import org.opensearch.rule.action.GetRuleResponse;
import org.opensearch.rule.action.UpdateRuleRequest;
import org.opensearch.rule.action.UpdateRuleResponse;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.autotagging.Rule;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.client.Client;

public class IndexStoredRulePersistenceService
implements RulePersistenceService {
    private final String indexName;
    private final Client client;
    private final ClusterService clusterService;
    private final int maxRulesPerPage;
    private final RuleEntityParser parser;
    private final RuleQueryMapper<QueryBuilder> queryBuilder;
    private static final Logger logger = LogManager.getLogger(IndexStoredRulePersistenceService.class);

    public IndexStoredRulePersistenceService(String indexName, Client client, ClusterService clusterService, int maxRulesPerPage, RuleEntityParser parser, RuleQueryMapper<QueryBuilder> queryBuilder) {
        this.indexName = indexName;
        this.client = client;
        this.clusterService = clusterService;
        this.maxRulesPerPage = maxRulesPerPage;
        this.parser = parser;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public void createRule(CreateRuleRequest request, ActionListener<CreateRuleResponse> listener) {
        try (ThreadContext.StoredContext ctx = this.stashContext();){
            if (!this.clusterService.state().metadata().hasIndex(this.indexName)) {
                logger.error("Index {} does not exist", (Object)this.indexName);
                listener.onFailure((Exception)new IllegalStateException("Index" + this.indexName + " does not exist"));
            } else {
                Rule rule = request.getRule();
                this.validateNoDuplicateRule(rule, (ActionListener<Void>)ActionListener.wrap(unused -> this.persistRule(rule, listener), arg_0 -> listener.onFailure(arg_0)));
            }
        }
    }

    private void validateNoDuplicateRule(final Rule rule, final ActionListener<Void> listener) {
        QueryBuilder query = this.queryBuilder.from(new GetRuleRequest(null, rule.getAttributeMap(), null, rule.getFeatureType()));
        this.getRuleFromIndex(null, query, null, new ActionListener<GetRuleResponse>(this){

            public void onResponse(GetRuleResponse getRuleResponse) {
                Optional<String> duplicateRuleId = RuleUtils.getDuplicateRuleId(rule, getRuleResponse.getRules());
                duplicateRuleId.ifPresentOrElse(id -> listener.onFailure((Exception)new IllegalArgumentException("Duplicate rule exists under id " + id)), () -> listener.onResponse(null));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void persistRule(Rule rule, ActionListener<CreateRuleResponse> listener) {
        try {
            IndexRequest indexRequest = new IndexRequest(this.indexName).id(rule.getId()).source(rule.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            this.client.index(indexRequest).get();
            listener.onResponse((Object)new CreateRuleResponse(rule));
        }
        catch (Exception e) {
            logger.error("Error saving rule to index: {}", (Object)this.indexName);
            listener.onFailure((Exception)new RuntimeException("Failed to save rule to index."));
        }
    }

    @Override
    public void getRule(GetRuleRequest getRuleRequest, ActionListener<GetRuleResponse> listener) {
        try (ThreadContext.StoredContext context = this.stashContext();){
            QueryBuilder getQueryBuilder = this.queryBuilder.from(getRuleRequest);
            this.getRuleFromIndex(getRuleRequest.getId(), getQueryBuilder, getRuleRequest.getSearchAfter(), listener);
        }
    }

    private void getRuleFromIndex(String id, QueryBuilder queryBuilder, String searchAfter, ActionListener<GetRuleResponse> listener) {
        try {
            SearchResponse searchResponse;
            List<SearchHit> hits;
            SearchRequestBuilder searchRequest = this.client.prepareSearch(new String[]{this.indexName}).setQuery(queryBuilder).setSize(this.maxRulesPerPage);
            if (searchAfter != null) {
                searchRequest.addSort("_id", SortOrder.ASC).searchAfter(new Object[]{searchAfter});
            }
            if (IndexStoredRulePersistenceService.hasNoResults(id, listener, hits = Arrays.asList((searchResponse = (SearchResponse)searchRequest.get()).getHits().getHits()))) {
                return;
            }
            this.handleGetRuleResponse(hits, listener);
        }
        catch (Exception e) {
            logger.error("Failed to fetch all rules: {}", (Object)e.getMessage());
            listener.onFailure(e);
        }
    }

    private static boolean hasNoResults(String id, ActionListener<GetRuleResponse> listener, List<SearchHit> hits) {
        if (id != null && hits.isEmpty()) {
            logger.error("Rule with ID " + id + " not found.");
            listener.onFailure((Exception)new ResourceNotFoundException("Rule with ID " + id + " not found.", new Object[0]));
            return true;
        }
        return false;
    }

    void handleGetRuleResponse(List<SearchHit> hits, ActionListener<GetRuleResponse> listener) {
        List<Rule> ruleList = hits.stream().map(hit -> this.parser.parse(hit.getSourceAsString())).toList();
        String nextSearchAfter = hits.isEmpty() || hits.size() < this.maxRulesPerPage ? null : hits.get(hits.size() - 1).getId();
        listener.onResponse((Object)new GetRuleResponse(ruleList, nextSearchAfter));
    }

    @Override
    public void deleteRule(DeleteRuleRequest request, ActionListener<AcknowledgedResponse> listener) {
        try (ThreadContext.StoredContext context = this.stashContext();){
            DeleteRequest deleteRequest = new DeleteRequest(this.indexName).id(request.getRuleId());
            this.client.delete(deleteRequest, ActionListener.wrap(deleteResponse -> {
                boolean acknowledged;
                boolean bl = acknowledged = deleteResponse.getResult() == DocWriteResponse.Result.DELETED;
                if (!acknowledged) {
                    logger.warn("Rule with ID " + request.getRuleId() + " was not found or already deleted.");
                }
                listener.onResponse((Object)new AcknowledgedResponse(acknowledged));
            }, e -> {
                if (e instanceof DocumentMissingException) {
                    logger.error("Rule with ID " + request.getRuleId() + " not found.");
                    listener.onFailure((Exception)new ResourceNotFoundException("Rule with ID " + request.getRuleId() + " not found.", new Object[0]));
                } else {
                    logger.error("Failed to delete rule: {}", (Object)e.getMessage());
                    listener.onFailure(e);
                }
            }));
        }
    }

    @Override
    public void updateRule(final UpdateRuleRequest request, final ActionListener<UpdateRuleResponse> listener) {
        final String ruleId = request.getId();
        final FeatureType featureType = request.getFeatureType();
        try (ThreadContext.StoredContext context = this.stashContext();){
            QueryBuilder query = this.queryBuilder.from(new GetRuleRequest(ruleId, new HashMap<Attribute, Set<String>>(), null, featureType));
            this.getRuleFromIndex(ruleId, query, null, new ActionListener<GetRuleResponse>(){

                public void onResponse(GetRuleResponse getRuleResponse) {
                    if (getRuleResponse == null || getRuleResponse.getRules().isEmpty()) {
                        listener.onFailure((Exception)new ResourceNotFoundException("Rule with ID " + ruleId + " not found.", new Object[0]));
                        return;
                    }
                    List<Rule> ruleList = getRuleResponse.getRules();
                    assert (ruleList.size() == 1);
                    Rule updatedRule = RuleUtils.composeUpdatedRule(ruleList.get(0), request, featureType);
                    IndexStoredRulePersistenceService.this.validateNoDuplicateRule(updatedRule, (ActionListener<Void>)ActionListener.wrap(unused -> IndexStoredRulePersistenceService.this.persistUpdatedRule(ruleId, updatedRule, (ActionListener<UpdateRuleResponse>)listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void persistUpdatedRule(String ruleId, Rule updatedRule, ActionListener<UpdateRuleResponse> listener) {
        try {
            UpdateRequest updateRequest = new UpdateRequest(this.indexName, ruleId).doc(updatedRule.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            this.client.update(updateRequest).get();
            listener.onResponse((Object)new UpdateRuleResponse(updatedRule));
        }
        catch (Exception e) {
            logger.error("Error updating rule in index: {}", (Object)this.indexName);
            listener.onFailure((Exception)new RuntimeException("Failed to update rule to index."));
        }
    }

    private ThreadContext.StoredContext stashContext() {
        return this.client.threadPool().getThreadContext().stashContext();
    }
}

