/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.net.InetSocketAddress;
import org.opensearch.common.network.CloseableChannel;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;

public interface TcpChannel
extends CloseableChannel {
    public boolean isServerChannel();

    public String getProfile();

    public InetSocketAddress getLocalAddress();

    public InetSocketAddress getRemoteAddress();

    public void sendMessage(BytesReference var1, ActionListener<Void> var2);

    public void addConnectListener(ActionListener<Void> var1);

    public ChannelStats getChannelStats();

    public static class ChannelStats {
        private volatile long lastAccessedTime = TimeValue.nsecToMSec((long)System.nanoTime());

        void markAccessed(long relativeMillisTime) {
            this.lastAccessedTime = relativeMillisTime;
        }

        long lastAccessedTime() {
            return this.lastAccessedTime;
        }
    }
}

