/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opensearch.Version;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class CollectorResult
implements ToXContentObject,
Writeable {
    public static final String REASON_SEARCH_COUNT = "search_count";
    public static final String REASON_SEARCH_TOP_HITS = "search_top_hits";
    public static final String REASON_SEARCH_TERMINATE_AFTER_COUNT = "search_terminate_after_count";
    public static final String REASON_SEARCH_POST_FILTER = "search_post_filter";
    public static final String REASON_SEARCH_MIN_SCORE = "search_min_score";
    public static final String REASON_SEARCH_MULTI = "search_multi";
    public static final String REASON_AGGREGATION = "aggregation";
    public static final String REASON_AGGREGATION_GLOBAL = "aggregation_global";
    public static final String COLLECTOR_MANAGER = "CollectorManager";
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField TIME = new ParseField("time", new String[0]);
    private static final ParseField TIME_NANOS = new ParseField("time_in_nanos", new String[0]);
    private static final ParseField REDUCE_TIME_NANOS = new ParseField("reduce_time_in_nanos", new String[0]);
    private static final ParseField MAX_SLICE_TIME_NANOS = new ParseField("max_slice_time_in_nanos", new String[0]);
    private static final ParseField MIN_SLICE_TIME_IN_NANOS = new ParseField("min_slice_time_in_nanos", new String[0]);
    private static final ParseField AVG_SLICE_TIME_IN_NANOS = new ParseField("avg_slice_time_in_nanos", new String[0]);
    private static final ParseField SLICE_COUNT = new ParseField("slice_count", new String[0]);
    private static final ParseField CHILDREN = new ParseField("children", new String[0]);
    private final String collectorName;
    private final String reason;
    private final long time;
    private final long reduceTime;
    private final long maxSliceTime;
    private final long minSliceTime;
    private final long avgSliceTime;
    private final int sliceCount;
    private List<CollectorResult> children;

    public CollectorResult(String collectorName, String reason, long time, List<CollectorResult> children) {
        this(collectorName, reason, time, 0L, time, time, time, 1, children);
    }

    public CollectorResult(String collectorName, String reason, long time, long reduceTime, long maxSliceTime, long minSliceTime, long avgSliceTime, int sliceCount, List<CollectorResult> children) {
        this.collectorName = collectorName;
        this.reason = reason;
        this.time = time;
        this.reduceTime = reduceTime;
        this.maxSliceTime = maxSliceTime;
        this.minSliceTime = minSliceTime;
        this.avgSliceTime = avgSliceTime;
        this.sliceCount = sliceCount;
        this.children = children;
    }

    public CollectorResult(StreamInput in) throws IOException {
        this.collectorName = in.readString();
        this.reason = in.readString();
        this.time = in.readLong();
        int size = in.readVInt();
        this.children = new ArrayList<CollectorResult>(size);
        for (int i = 0; i < size; ++i) {
            CollectorResult child = new CollectorResult(in);
            this.children.add(child);
        }
        if (in.getVersion().onOrAfter(Version.V_2_9_0)) {
            this.reduceTime = in.readLong();
            this.maxSliceTime = in.readLong();
            this.minSliceTime = in.readLong();
            this.avgSliceTime = in.readLong();
            this.sliceCount = in.readVInt();
        } else {
            this.reduceTime = 0L;
            this.maxSliceTime = this.time;
            this.minSliceTime = this.time;
            this.avgSliceTime = this.time;
            this.sliceCount = 1;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.collectorName);
        out.writeString(this.reason);
        out.writeLong(this.time);
        out.writeVInt(this.children.size());
        for (CollectorResult child : this.children) {
            child.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_2_9_0)) {
            out.writeLong(this.reduceTime);
            out.writeLong(this.maxSliceTime);
            out.writeLong(this.minSliceTime);
            out.writeLong(this.avgSliceTime);
            out.writeVInt(this.sliceCount);
        }
    }

    public long getTime() {
        return this.time;
    }

    public long getReduceTime() {
        return this.reduceTime;
    }

    public long getMaxSliceTime() {
        return this.maxSliceTime;
    }

    public long getMinSliceTime() {
        return this.minSliceTime;
    }

    public long getAvgSliceTime() {
        return this.avgSliceTime;
    }

    public int getSliceCount() {
        return this.sliceCount;
    }

    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.collectorName;
    }

    public List<CollectorResult> getProfiledChildren() {
        return this.children;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject();
        builder.field(NAME.getPreferredName(), this.getName());
        builder.field(REASON.getPreferredName(), this.getReason());
        if (builder.humanReadable()) {
            builder.field(TIME.getPreferredName(), new TimeValue(this.getTime(), TimeUnit.NANOSECONDS).toString());
        }
        builder.field(TIME_NANOS.getPreferredName(), this.getTime());
        if (this.getName().contains(COLLECTOR_MANAGER)) {
            builder.field(REDUCE_TIME_NANOS.getPreferredName(), this.getReduceTime());
            builder.field(MAX_SLICE_TIME_NANOS.getPreferredName(), this.getMaxSliceTime());
            builder.field(MIN_SLICE_TIME_IN_NANOS.getPreferredName(), this.getMinSliceTime());
            builder.field(AVG_SLICE_TIME_IN_NANOS.getPreferredName(), this.getAvgSliceTime());
            builder.field(SLICE_COUNT.getPreferredName(), this.getSliceCount());
        }
        if (!this.children.isEmpty()) {
            builder = builder.startArray(CHILDREN.getPreferredName());
            for (CollectorResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder = builder.endArray();
        }
        builder = builder.endObject();
        return builder;
    }

    public static CollectorResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        String currentFieldName = null;
        String name = null;
        String reason = null;
        long time = -1L;
        long reduceTime = -1L;
        long maxSliceTime = -1L;
        long minSliceTime = -1L;
        long avgSliceTime = -1L;
        int sliceCount = 0;
        ArrayList<CollectorResult> children = new ArrayList<CollectorResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                    name = parser.text();
                    continue;
                }
                if (REASON.match(currentFieldName, parser.getDeprecationHandler())) {
                    reason = parser.text();
                    continue;
                }
                if (TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    parser.text();
                    continue;
                }
                if (TIME_NANOS.match(currentFieldName, parser.getDeprecationHandler())) {
                    time = parser.longValue();
                    continue;
                }
                if (REDUCE_TIME_NANOS.match(currentFieldName, parser.getDeprecationHandler())) {
                    reduceTime = parser.longValue();
                    continue;
                }
                if (MAX_SLICE_TIME_NANOS.match(currentFieldName, parser.getDeprecationHandler())) {
                    maxSliceTime = parser.longValue();
                    continue;
                }
                if (MIN_SLICE_TIME_IN_NANOS.match(currentFieldName, parser.getDeprecationHandler())) {
                    minSliceTime = parser.longValue();
                    continue;
                }
                if (AVG_SLICE_TIME_IN_NANOS.match(currentFieldName, parser.getDeprecationHandler())) {
                    avgSliceTime = parser.longValue();
                    continue;
                }
                if (SLICE_COUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                    sliceCount = parser.intValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (CHILDREN.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        children.add(CollectorResult.fromXContent(parser));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        return new CollectorResult(name, reason, time, reduceTime, maxSliceTime, minSliceTime, avgSliceTime, sliceCount, children);
    }
}

