/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Collector;
import org.opensearch.common.CheckedFunction;
import org.opensearch.search.aggregations.AggregationCollectorManager;
import org.opensearch.search.aggregations.AggregationReduceableSearchResult;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.internal.SearchContext;

public class NonGlobalAggCollectorManager
extends AggregationCollectorManager {
    private Collector collector = Objects.requireNonNull(super.newCollector(), "collector instance is null");
    private final String collectorName = this.collector.toString();

    public NonGlobalAggCollectorManager(SearchContext context) throws IOException {
        super(context, (CheckedFunction<SearchContext, List<Aggregator>, IOException>)((CheckedFunction)context.aggregations().factories()::createTopLevelNonGlobalAggregators), "aggregation");
    }

    @Override
    public Collector newCollector() throws IOException {
        if (this.collector != null) {
            Collector toReturn = this.collector;
            this.collector = null;
            return toReturn;
        }
        return super.newCollector();
    }

    @Override
    protected AggregationReduceableSearchResult buildAggregationResult(InternalAggregations internalAggregations) {
        return new AggregationReduceableSearchResult(InternalAggregations.topLevelReduce(Collections.singletonList(internalAggregations), this.context.partialOnShard()));
    }

    @Override
    public String getCollectorName() {
        return this.collectorName;
    }
}

