/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.IOException;
import org.apache.lucene.util.Version;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.recovery.RecoveryTransportRequest;

public final class FileChunkRequest
extends RecoveryTransportRequest {
    private final boolean lastChunk;
    private final long recoveryId;
    private final ShardId shardId;
    private final long position;
    private final BytesReference content;
    private final StoreFileMetadata metadata;
    private final long sourceThrottleTimeInNanos;
    private final int totalTranslogOps;

    public FileChunkRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        String name = in.readString();
        this.position = in.readVLong();
        long length = in.readVLong();
        String checksum = in.readString();
        this.content = in.readBytesReference();
        Version writtenBy = Lucene.parseVersionLenient(in.readString(), null);
        assert (writtenBy != null);
        this.metadata = new StoreFileMetadata(name, length, checksum, writtenBy);
        this.lastChunk = in.readBoolean();
        this.totalTranslogOps = in.readVInt();
        this.sourceThrottleTimeInNanos = in.readLong();
    }

    public FileChunkRequest(long recoveryId, long requestSeqNo, ShardId shardId, StoreFileMetadata metadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, long sourceThrottleTimeInNanos) {
        super(requestSeqNo);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.metadata = metadata;
        this.position = position;
        this.content = content;
        this.lastChunk = lastChunk;
        this.totalTranslogOps = totalTranslogOps;
        this.sourceThrottleTimeInNanos = sourceThrottleTimeInNanos;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String name() {
        return this.metadata.name();
    }

    public long position() {
        return this.position;
    }

    public long length() {
        return this.metadata.length();
    }

    public BytesReference content() {
        return this.content;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long sourceThrottleTimeInNanos() {
        return this.sourceThrottleTimeInNanos;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.metadata.name());
        out.writeVLong(this.position);
        out.writeVLong(this.metadata.length());
        out.writeString(this.metadata.checksum());
        out.writeBytesReference(this.content);
        out.writeString(this.metadata.writtenBy().toString());
        out.writeBoolean(this.lastChunk);
        out.writeVInt(this.totalTranslogOps);
        out.writeLong(this.sourceThrottleTimeInNanos);
    }

    public String toString() {
        return this.shardId + ": name='" + this.name() + "', position=" + this.position + ", length=" + this.length();
    }

    public StoreFileMetadata metadata() {
        return this.metadata;
    }

    public boolean lastChunk() {
        return this.lastChunk;
    }
}

