/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ClusterName
implements Writeable {
    public static final Setting<ClusterName> CLUSTER_NAME_SETTING = new Setting<ClusterName>("cluster.name", "opensearch", s -> {
        if (s.isEmpty()) {
            throw new IllegalArgumentException("[cluster.name] must not be empty");
        }
        if (s.contains(":")) {
            throw new IllegalArgumentException("[cluster.name] must not contain ':'");
        }
        return new ClusterName((String)s);
    }, Setting.Property.NodeScope);
    public static final ClusterName DEFAULT = CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY);
    private final String value;

    public ClusterName(StreamInput input) throws IOException {
        this(input.readString());
    }

    public ClusterName(String value) {
        this.value = value.intern();
    }

    public String value() {
        return this.value;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterName that = (ClusterName)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Cluster [" + this.value + "]";
    }

    public Predicate<ClusterName> getEqualityPredicate() {
        return new Predicate<ClusterName>(){

            @Override
            public boolean test(ClusterName o) {
                return ClusterName.this.equals(o);
            }

            public String toString() {
                return "local cluster name [" + ClusterName.this.value() + "]";
            }
        };
    }
}

