/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.search.ListPitInfo;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class GetAllPitNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private final List<ListPitInfo> pitInfos;

    public GetAllPitNodeResponse(DiscoveryNode node, List<ListPitInfo> pitInfos) {
        super(node);
        if (pitInfos == null) {
            throw new IllegalArgumentException("Pits info cannot be null");
        }
        this.pitInfos = Collections.unmodifiableList(pitInfos);
    }

    public GetAllPitNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.pitInfos = Collections.unmodifiableList(in.readList(ListPitInfo::new));
    }

    public List<ListPitInfo> getPitInfos() {
        return this.pitInfos;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.pitInfos);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("node", this.getNode().getName());
        builder.startArray("pitInfos");
        for (ListPitInfo pit : this.pitInfos) {
            pit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

