/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt_PT extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Hora da \u00c1frica Central",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Hora padr\u00e3o de Moscovo",
               "MSK",
               "Hora de ver\u00e3o de Moscovo",
               "MSD",
               "Hora de Moscovo",
               "MT",
            };
        final String[] Japan = new String[] {
               "Hora padr\u00e3o do Jap\u00e3o",
               "JST",
               "Hora de ver\u00e3o do Jap\u00e3o",
               "JDT",
               "Hora do Jap\u00e3o",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Hora padr\u00e3o do Paquist\u00e3o",
               "PKT",
               "Hora de ver\u00e3o do Paquist\u00e3o",
               "PKST",
               "Hora do Paquist\u00e3o",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Hora padr\u00e3o de Taip\u00e9",
               "CST",
               "Hora de ver\u00e3o de Taip\u00e9",
               "CDT",
               "Hora de Taip\u00e9",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hora padr\u00e3o de Hovd",
               "HOVT",
               "Hora de ver\u00e3o de Hovd",
               "HOVST",
               "Hora de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Hora padr\u00e3o de Magadan",
               "MAGT",
               "Hora de ver\u00e3o de Magadan",
               "MAGST",
               "Hora de Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Central Ocidental",
               "ACWST",
               "Hora de ver\u00e3o da Austr\u00e1lia Central Ocidental",
               "ACWDT",
               "Hora da Austr\u00e1lia Central Ocidental",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Hora padr\u00e3o da Europa Central",
               "CET",
               "Hora de ver\u00e3o da Europa Central",
               "CEST",
               "Hora da Europa Central",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Hora padr\u00e3o de Sacalina",
               "SAKT",
               "Hora de ver\u00e3o de Sacalina",
               "SAKST",
               "Hora de Sacalina",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Hora padr\u00e3o do Paraguai",
               "PYT",
               "Hora de ver\u00e3o do Paraguai",
               "PYST",
               "Hora do Paraguai",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Hora padr\u00e3o do Acre",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o do Acre",
               "\u2205\u2205\u2205",
               "Hora do Acre",
               "\u2205\u2205\u2205",
            };
        final String[] Malaysia = new String[] {
               "Hora da Mal\u00e1sia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Hora padr\u00e3o Oriental",
               "EST",
               "Hora de ver\u00e3o Oriental",
               "EDT",
               "Hora Oriental",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Hora padr\u00e3o de Lord Howe",
               "LHST",
               "Hora de ver\u00e3o de Lord Howe",
               "LHDT",
               "Hora de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Hora padr\u00e3o da Nova Zel\u00e2ndia",
               "NZST",
               "Hora de ver\u00e3o da Nova Zel\u00e2ndia",
               "NZDT",
               "Hora da Nova Zel\u00e2ndia",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora do Oceano \u00cdndico",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Hora padr\u00e3o de Yakutsk",
               "YAKT",
               "Hora de ver\u00e3o de Yakutsk",
               "YAKST",
               "Hora de Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Hora padr\u00e3o da Maur\u00edcia",
               "MUT",
               "Hora de ver\u00e3o da Maur\u00edcia",
               "MUST",
               "Hora da Maur\u00edcia",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora da \u00c1frica Oriental",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Leste",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Hora das Ilhas Salom\u00e3o",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora das Ilhas Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora padr\u00e3o da Europa Oriental",
               "EET",
               "Hora de ver\u00e3o da Europa Oriental",
               "EEST",
               "Hora da Europa Oriental",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Hora padr\u00e3o da Terra Nova",
               "NST",
               "Hora de ver\u00e3o da Terra Nova",
               "NDT",
               "Hora da Terra Nova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Hora do Afeganist\u00e3o",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hora padr\u00e3o de Hong Kong",
               "HKT",
               "Hora de ver\u00e3o de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Hora padr\u00e3o da Argentina Ocidental",
               "ART",
               "Hora de ver\u00e3o da Argentina Ocidental",
               "ARST",
               "Hora da Argentina Ocidental",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Hora padr\u00e3o do Atl\u00e2ntico",
               "AST",
               "Hora de ver\u00e3o do Atl\u00e2ntico",
               "ADT",
               "Hora do Atl\u00e2ntico",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Hora da Bol\u00edvia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora padr\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "PMST",
               "Hora de ver\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "PMDT",
               "Hora de S\u00e3o Pedro e Miquel\u00e3o",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hora da Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora padr\u00e3o de Ecaterimburgo",
               "YEKT",
               "Hora de ver\u00e3o de Ecaterimburgo",
               "YEKST",
               "Hora de Ecaterimburgo",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Hora das Maldivas",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Hora do Taiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Hora padr\u00e3o de Israel",
               "IST",
               "Hora de ver\u00e3o de Israel",
               "IDT",
               "Hora de Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora da Indon\u00e9sia Central",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis e Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora da \u00c1frica do Sul",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Hora das Ilhas Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Hora padr\u00e3o do Uzbequist\u00e3o",
               "UZT",
               "Hora de ver\u00e3o do Uzbequist\u00e3o",
               "UZST",
               "Hora do Uzbequist\u00e3o",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Hora padr\u00e3o de Omsk",
               "OMST",
               "Hora de ver\u00e3o de Omsk",
               "OMSST",
               "Hora de Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Hora das Seicheles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Hora padr\u00e3o do Uruguai",
               "UYT",
               "Hora de ver\u00e3o do Uruguai",
               "UYST",
               "Hora do Uruguai",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Hora do Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Hora padr\u00e3o de Ulan Bator",
               "ULAT",
               "Hora de ver\u00e3o de Ulan Bator",
               "ULAST",
               "Hora de Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Hora padr\u00e3o Central",
               "CST",
               "Hora de ver\u00e3o Central",
               "CDT",
               "Hora Central",
               "CT",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Hora da Ilha Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Hora padr\u00e3o das Ilhas Falkland",
               "FKT",
               "Hora de ver\u00e3o das Ilhas Falkland",
               "FKST",
               "Hora das Ilhas Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Hora padr\u00e3o do Vanuatu",
               "VUT",
               "Hora de ver\u00e3o do Vanuatu",
               "VUST",
               "Hora do Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora padr\u00e3o de Novosibirsk",
               "NOVT",
               "Hora de ver\u00e3o de Novosibirsk",
               "NOVST",
               "Hora de Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Hora padr\u00e3o de Singapura",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Hora padr\u00e3o dos A\u00e7ores",
               "AZOT",
               "Hora de ver\u00e3o dos A\u00e7ores",
               "AZOST",
               "Hora dos A\u00e7ores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Hora padr\u00e3o de Apia",
               "WSST",
               "Hora de ver\u00e3o de Apia",
               "WSDT",
               "Hora de Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Hora do But\u00e3o",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Hora do Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora padr\u00e3o de Krasnoyarsk",
               "KRAT",
               "Hora de ver\u00e3o de Krasnoyarsk",
               "KRAST",
               "Hora de Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora do Cazaquist\u00e3o Ocidental",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Hora de Mianmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Hora da Ilha do Natal",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Hora padr\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora do Amazonas",
               "\u2205\u2205\u2205",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora do Cazaquist\u00e3o Oriental",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Hora padr\u00e3o de Fiji",
               "FJT",
               "Hora de ver\u00e3o de Fiji",
               "FJST",
               "Hora de Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Hora de Reuni\u00e3o",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Hora das Ilhas Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Hora padr\u00e3o do Chatham",
               "CHAST",
               "Hora de ver\u00e3o do Chatham",
               "CHADT",
               "Hora do Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Hora padr\u00e3o da Argentina",
               "ART",
               "Hora de ver\u00e3o da Argentina",
               "ARST",
               "Hora da Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Hora padr\u00e3o de Petropavlovsk-Kamchatski",
               "PETT",
               "Hora de ver\u00e3o de Petropavlovsk-Kamchatski",
               "PETST",
               "Hora de Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Hora das Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Hora da Ilha Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Hora da Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora padr\u00e3o do Havai e Aleutas",
               "HAST",
               "Hora de ver\u00e3o do Havai e Aleutas",
               "HADT",
               "Hora do Havai e Aleutas",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Central",
               "ACST",
               "Hora de ver\u00e3o da Austr\u00e1lia Central",
               "ACDT",
               "Hora da Austr\u00e1lia Central",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Hora padr\u00e3o do Pac\u00edfico",
               "PST",
               "Hora de ver\u00e3o do Pac\u00edfico",
               "PDT",
               "Hora do Pac\u00edfico",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora das Ilhas F\u00e9nix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora padr\u00e3o do Turquemenist\u00e3o",
               "TMT",
               "Hora de ver\u00e3o do Turquemenist\u00e3o",
               "TMST",
               "Hora do Turquemenist\u00e3o",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Hora padr\u00e3o da Europa Ocidental",
               "WET",
               "Hora de ver\u00e3o da Europa Ocidental",
               "WEST",
               "Hora da Europa Ocidental",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Hora padr\u00e3o de Cabo Verde",
               "CVT",
               "Hora de ver\u00e3o de Cabo Verde",
               "CVST",
               "Hora de Cabo Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Hora da Ilha Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Hora da Guiana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Hora padr\u00e3o de Samoa",
               "SST",
               "Hora de ver\u00e3o de Samoa",
               "SDT",
               "Hora de Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Hora do Extremo Leste da Europa",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Hora padr\u00e3o do Azerbaij\u00e3o",
               "AZT",
               "Hora de ver\u00e3o do Azerbaij\u00e3o",
               "AZST",
               "Hora do Azerbaij\u00e3o",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora padr\u00e3o do Pac\u00edfico Mexicano",
               "MST",
               "Hora de ver\u00e3o do Pac\u00edfico Mexicano",
               "MDT",
               "Hora do Pac\u00edfico Mexicano",
               "MT",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Hora padr\u00e3o de Cuba",
               "CST",
               "Hora de ver\u00e3o de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Hora padr\u00e3o da \u00c1frica Ocidental",
               "CAT",
               "Hora de ver\u00e3o da \u00c1frica Ocidental",
               "CAST",
               "Hora da \u00c1frica Ocidental",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Hora de Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Hora padr\u00e3o das Filipinas",
               "PHT",
               "Hora de ver\u00e3o das Filipinas",
               "PHST",
               "Hora das Filipinas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Hora das Terras Austrais e Ant\u00e1rcticas Francesas",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Hora da Ge\u00f3rgia do Sul",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Hora padr\u00e3o da Nova Caled\u00f3nia",
               "NCT",
               "Hora de ver\u00e3o da Nova Caled\u00f3nia",
               "NCST",
               "Hora da Nova Caled\u00f3nia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Hora do Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Hora padr\u00e3o do Ir\u00e3o",
               "IRST",
               "Hora de ver\u00e3o do Ir\u00e3o",
               "IRDT",
               "Hora do Ir\u00e3o",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Hora padr\u00e3o da Ilha da P\u00e1scoa",
               "EAST",
               "Hora de ver\u00e3o da Ilha da P\u00e1scoa",
               "EASST",
               "Hora da Ilha da P\u00e1scoa",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hora padr\u00e3o do Noroeste do M\u00e9xico",
               "PST",
               "Hora de ver\u00e3o do Noroeste do M\u00e9xico",
               "PDT",
               "Hora do Noroeste do M\u00e9xico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Hora do Tajiquist\u00e3o",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Hora padr\u00e3o de Tonga",
               "TOT",
               "Hora de ver\u00e3o de Tonga",
               "TOST",
               "Hora de Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Hora padr\u00e3o do Bangladesh",
               "BDT",
               "Hora de ver\u00e3o do Bangladesh",
               "BDST",
               "Hora do Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Hora padr\u00e3o do Peru",
               "PET",
               "Hora de ver\u00e3o do Peru",
               "PEST",
               "Hora do Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Hora padr\u00e3o da Gronel\u00e2ndia Ocidental",
               "WGT",
               "Hora de ver\u00e3o da Gronel\u00e2ndia Ocidental",
               "WGST",
               "Hora da Gronel\u00e2ndia Ocidental",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Hora do Equador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora padr\u00e3o da Gronel\u00e2ndia Oriental",
               "EGT",
               "Hora de ver\u00e3o da Gronel\u00e2ndia Oriental",
               "EGST",
               "Hora da Gronel\u00e2ndia Oriental",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Hora padr\u00e3o do Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora da Indon\u00e9sia Oriental",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Hora padr\u00e3o da Coreia",
               "KST",
               "Hora de ver\u00e3o da Coreia",
               "KDT",
               "Hora da Coreia",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Ocidental",
               "AWST",
               "Hora de ver\u00e3o da Austr\u00e1lia Ocidental",
               "AWDT",
               "Hora da Austr\u00e1lia Ocidental",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Hora do Quirguist\u00e3o",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora da Indon\u00e9sia Ocidental",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Oriental",
               "AEST",
               "Hora de ver\u00e3o da Austr\u00e1lia Oriental",
               "AEDT",
               "Hora da Austr\u00e1lia Oriental",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Hora da Guiana Francesa",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Hora padr\u00e3o da Col\u00f4mbia",
               "COT",
               "Hora de ver\u00e3o da Col\u00f4mbia",
               "COST",
               "Hora da Col\u00f4mbia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Hora padr\u00e3o do Chile",
               "CLT",
               "Hora de ver\u00e3o do Chile",
               "CLST",
               "Hora do Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora das Ilhas Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Hora padr\u00e3o da Montanha",
               "MST",
               "Hora de ver\u00e3o da Montanha",
               "MDT",
               "Hora de Montanha",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Hora das Ilhas Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Hora padr\u00e3o da Ar\u00e1bia",
               "AST",
               "Hora de ver\u00e3o da Ar\u00e1bia",
               "ADT",
               "Hora da Ar\u00e1bia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Hora padr\u00e3o do Alasca",
               "AKST",
               "Hora de ver\u00e3o do Alasca",
               "AKDT",
               "Hora do Alasca",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Hora padr\u00e3o de Vladivostok",
               "VLAT",
               "Hora de ver\u00e3o de Vladivostok",
               "VLAST",
               "Hora de Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Hora padr\u00e3o do Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Hora padr\u00e3o de Irkutsk",
               "IRKT",
               "Hora de ver\u00e3o de Irkutsk",
               "IRKST",
               "Hora de Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Hora padr\u00e3o da Ge\u00f3rgia",
               "GET",
               "Hora de ver\u00e3o da Ge\u00f3rgia",
               "GEST",
               "Hora da Ge\u00f3rgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Papua Nova Guin\u00e9",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Hora padr\u00e3o de Fernando de Noronha",
               "FNT",
               "Hora de ver\u00e3o de Fernando de Noronha",
               "FNST",
               "Hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Hora padr\u00e3o de Choibalsan",
               "CHOT",
               "Hora de ver\u00e3o de Choibalsan",
               "CHOST",
               "Hora de Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Hora padr\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de Bras\u00edlia",
               "\u2205\u2205\u2205",
            };
        final String[] China = new String[] {
               "Hora padr\u00e3o da China",
               "CST",
               "Hora de ver\u00e3o da China",
               "CDT",
               "Hora da China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Hora padr\u00e3o da Arm\u00e9nia",
               "AMT",
               "Hora de ver\u00e3o da Arm\u00e9nia",
               "AMST",
               "Hora da Arm\u00e9nia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Hora padr\u00e3o de Samara",
               "SAMT",
               "Hora de ver\u00e3o de Samara",
               "SAMST",
               "Hora de Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Hora padr\u00e3o da \u00cdndia",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Hora padr\u00e3o das Ilhas Cook",
               "CKT",
               "Hora de ver\u00e3o das Ilhas Cook",
               "CKHST",
               "Hora das Ilhas Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de Ver\u00e3o Brit\u00e2nica",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Hora de Greenwich",
                    "GMT",
                    "Hora de Ver\u00e3o da Irlanda",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
