/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import net.osmand.Location;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.data.QuadPoint;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.TargetPointsHelper;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.DirectOffroadLayer;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

public class PointNavigationLayer
extends OsmandMapLayer
implements DirectOffroadLayer,
IContextMenuProvider {
    protected static final int DIST_TO_SHOW = 80;
    private OsmBitmapPanel view;
    private float[] calculations = new float[2];
    private BufferedImage startPoint;
    private BufferedImage targetPoint;
    private BufferedImage intermediatePoint;
    private BufferedImage arrowToDestination;
    private final OsmWindow map;

    public PointNavigationLayer(OsmWindow map) {
        this.map = map;
    }

    private void initUI() {
        this.startPoint = this.readImage("map_start_point", this.view);
        this.targetPoint = this.readImage("map_target_point", this.view);
        this.intermediatePoint = this.readImage("map_intermediate_point", this.view);
        this.arrowToDestination = this.readImage("map_arrow_to_destination", this.view);
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.view = view;
        this.initUI();
    }

    @Override
    public void onDraw(Graphics2D canvasO, RotatedTileBox tb, OsmandMapLayer.DrawSettings nightMode) {
        Iterator<TargetPointsHelper.TargetPoint> it;
        if (tb.getZoom() < 3) {
            return;
        }
        Graphics2D canvas = this.view.createGraphics(canvasO);
        TargetPointsHelper targetPoints = this.map.getTargetPointsHelper();
        TargetPointsHelper.TargetPoint pointToStart = targetPoints.getPointToStart();
        if (pointToStart != null && this.isLocationVisible(tb, pointToStart)) {
            int marginX = this.startPoint.getWidth() / 6;
            int marginY = this.startPoint.getHeight();
            int locationX = (int)tb.getPixXFromLatLon(pointToStart.getLatitude(), pointToStart.getLongitude());
            int locationY = (int)tb.getPixYFromLatLon(pointToStart.getLatitude(), pointToStart.getLongitude());
            canvas.drawImage((Image)this.startPoint, locationX - marginX, locationY - marginY, null);
        }
        int index = 0;
        for (TargetPointsHelper.TargetPoint ip : targetPoints.getIntermediatePoints()) {
            ++index;
            if (!this.isLocationVisible(tb, ip)) continue;
            int marginX = this.intermediatePoint.getWidth() / 6;
            int marginY = this.intermediatePoint.getHeight();
            int locationX = (int)tb.getPixXFromLatLon(ip.getLatitude(), ip.getLongitude());
            int locationY = (int)tb.getPixYFromLatLon(ip.getLatitude(), ip.getLongitude());
            canvas.drawImage((Image)this.intermediatePoint, locationX - marginX, locationY - marginY, null);
            marginX = this.intermediatePoint.getWidth() / 3;
            Font textFont = canvas.getFont().deriveFont(18);
            canvas.setFont(textFont);
            canvas.drawString(index + "", locationX + marginX, locationY - 3 * marginY / 5);
        }
        TargetPointsHelper.TargetPoint pointToNavigate = targetPoints.getPointToNavigate();
        if (this.isLocationVisible(tb, pointToNavigate)) {
            int marginX = this.targetPoint.getWidth() / 6;
            int marginY = this.targetPoint.getHeight();
            int locationX = (int)tb.getPixXFromLatLon(pointToNavigate.getLatitude(), pointToNavigate.getLongitude());
            int locationY = (int)tb.getPixYFromLatLon(pointToNavigate.getLatitude(), pointToNavigate.getLongitude());
            canvas.drawImage((Image)this.targetPoint, locationX - marginX, locationY - marginY, null);
        }
        if ((it = targetPoints.getIntermediatePoints().iterator()).hasNext()) {
            pointToNavigate = it.next();
        }
        if (pointToNavigate != null && !this.isLocationVisible(tb, pointToNavigate)) {
            boolean show;
            boolean bl = show = !this.view.getApplication().getRoutingHelper().isRouteCalculated();
            if (this.view.getSettings().SHOW_DESTINATION_ARROW.isSet()) {
                show = this.view.getSettings().SHOW_DESTINATION_ARROW.get();
            }
            if (show) {
                LatLon latLon = this.map.getMouseLocation();
                Location.distanceBetween(latLon.getLatitude(), latLon.getLongitude(), pointToNavigate.getLatitude(), pointToNavigate.getLongitude(), this.calculations);
                float bearing = this.calculations[1] - 90.0f;
                float radiusBearing = 80.0f * tb.getDensity();
                QuadPoint cp = tb.getCenterPixelPoint();
                canvas.translate(-24.0f * tb.getDensity() + radiusBearing, -22.0f * tb.getDensity());
                canvas.drawImage((Image)this.arrowToDestination, (int)cp.x, (int)cp.y, null);
            }
        }
    }

    public boolean isLocationVisible(RotatedTileBox tb, TargetPointsHelper.TargetPoint p) {
        if (p == null || tb == null) {
            return false;
        }
        return tb.containsLatLon(p.getLatitude(), p.getLongitude());
    }

    @Override
    public void destroyLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    @Override
    public boolean disableSingleTap() {
        return false;
    }

    @Override
    public boolean disableLongPressOnMap() {
        return false;
    }

    @Override
    public boolean isObjectClickable(Object o) {
        return false;
    }

    @Override
    public void collectObjectsFromPoint(Point2D point, RotatedTileBox tileBox, List<Object> o) {
        TargetPointsHelper tg = this.map.getTargetPointsHelper();
        List<TargetPointsHelper.TargetPoint> intermediatePoints = tg.getAllPoints();
        int r = this.getRadiusPoi(tileBox);
        for (int i = 0; i < intermediatePoints.size(); ++i) {
            int y;
            int x;
            int ey;
            int ex;
            TargetPointsHelper.TargetPoint tp = intermediatePoints.get(i);
            LatLon latLon = tp.point;
            if (latLon == null || !this.calculateBelongs(ex = (int)point.getX(), ey = (int)point.getY(), x = (int)tileBox.getPixXFromLatLon(latLon.getLatitude(), latLon.getLongitude()), y = (int)tileBox.getPixYFromLatLon(latLon.getLatitude(), latLon.getLongitude()), r)) continue;
            o.add(tp);
        }
    }

    private boolean calculateBelongs(int ex, int ey, int objx, int objy, int radius) {
        return Math.abs(objx - ex) <= radius && ey - objy <= radius && (double)(objy - ey) <= 2.5 * (double)radius;
    }

    public int getRadiusPoi(RotatedTileBox tb) {
        int r = 0;
        double zoom = tb.getZoom();
        r = zoom <= 15.0 ? 10 : (zoom <= 16.0 ? 14 : (zoom <= 17.0 ? 16 : 18));
        return (int)((float)r * tb.getDensity());
    }

    @Override
    public LatLon getObjectLocation(Object o) {
        if (o instanceof TargetPointsHelper.TargetPoint) {
            return ((TargetPointsHelper.TargetPoint)o).point;
        }
        return null;
    }

    @Override
    public String getObjectDescription(Object o) {
        if (o instanceof TargetPointsHelper.TargetPoint) {
            return ((TargetPointsHelper.TargetPoint)o).getPointDescription(this.view.getContext()).getFullPlainName(this.view.getContext());
        }
        return null;
    }

    @Override
    public PointDescription getObjectName(Object o) {
        if (o instanceof TargetPointsHelper.TargetPoint) {
            return ((TargetPointsHelper.TargetPoint)o).getPointDescription(this.view.getContext());
        }
        return null;
    }
}

