/*! For license information please see bookmarks-src_components_ViewPublic_vue.js.LICENSE.txt */
"use strict";(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_ViewPublic_vue"],{6495:(t,r,n)=>{n.d(r,{Z:()=>s});var e=n(87537),o=n.n(e),a=n(23645),i=n.n(a)()(o());i.push([t.id,"\n#app-content {\n\tmax-width: 100%;\n}\n","",{version:3,sources:["webpack://./src/components/ViewPublic.vue"],names:[],mappings:";AAmHA;CACA,eAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcContent app-name=\"bookmarks\">\n\t\t<NcAppContent>\n\t\t\t<Controls />\n\t\t\t<BookmarksList :loading=\"!!loading.bookmarks\" :bookmarks=\"bookmarks\" />\n\t\t</NcAppContent>\n\t\t<BookmarkContent />\n\t</NcContent>\n</template>\n\n<script>\nimport { NcContent, NcAppContent } from '@nextcloud/vue'\nimport BookmarksList from './BookmarksList.vue'\nimport Controls from './Controls.vue'\nimport { actions, mutations } from '../store/index.js'\nimport BookmarkContent from './BookmarkContent.vue'\n\nexport default {\n\tname: 'ViewPublic',\n\tcomponents: {\n\t\tBookmarkContent,\n\t\tNcContent,\n\t\tNcAppContent,\n\t\tControls,\n\t\tBookmarksList,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewBookmark: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tbookmarks() {\n\t\t\treturn this.$store.state.bookmarks\n\t\t},\n\t\tfolders() {\n\t\t\treturn this.$store.state.folders\n\t\t},\n\t\ttags() {\n\t\t\treturn this.$store.state.tags\n\t\t},\n\t\tloading() {\n\t\t\treturn this.$store.state.loading\n\t\t},\n\t},\n\n\twatch: {\n\t\t$route: 'onRoute',\n\t},\n\n\tasync created() {\n\t\t// this.search = new OCA.Search(this.onSearch, this.onResetSearch)\n\t\tthis.$store.commit(mutations.SET_AUTH_TOKEN, this.$route.params.token)\n\t\t// set loading indicator\n\t\tthis.$store.commit(mutations.FETCH_START, { type: 'bookmarks' })\n\t\tawait Promise.all([\n\t\t\t// this.reloadTags(),\n\t\t\tthis.reloadFolders(),\n\t\t])\n\t\tthis.onRoute()\n\t},\n\n\tmethods: {\n\t\tasync onRoute() {\n\t\t\tconst route = this.$route\n\t\t\tswitch (route.name) {\n\t\t\tcase this.routes.HOME:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_FOLDER, '-1')\n\t\t\tcase this.routes.RECENT:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_RECENT)\n\t\t\tcase this.routes.UNTAGGED:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_UNTAGGED)\n\t\t\tcase this.routes.FOLDER:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_FOLDER, route.params.folder)\n\t\t\tcase this.routes.TAGS:\n\t\t\t\treturn this.$store.dispatch(\n\t\t\t\t\tactions.FILTER_BY_TAGS,\n\t\t\t\t\troute.params.tags.split(',')\n\t\t\t\t)\n\t\t\tcase this.routes.SEARCH:\n\t\t\t\treturn this.$store.dispatch(actions.FILTER_BY_SEARCH, route.params.search)\n\t\t\tdefault:\n\t\t\t\tthrow new Error('Nothing here. Move along.')\n\t\t\t}\n\t\t},\n\n\t\tasync reloadTags() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_TAGS)\n\t\t},\n\t\tasync reloadFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_FOLDERS)\n\t\t},\n\n\t\tonSearch(search) {\n\t\t\tthis.$router.push({ name: this.routes.SEARCH, params: { search } })\n\t\t},\n\n\t\tonResetSearch() {\n\t\t\tthis.$router.push({ name: this.routes.HOME })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\t#app-content {\n\t\tmax-width: 100%;\n\t}\n</style>\n"],sourceRoot:""}]);const s=i},44876:(t,r,n)=>{n.r(r),n.d(r,{default:()=>A});var e=n(15961),o=n(53642),a=n(85489),i=n(81283);function s(t){return s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},s(t)}function c(){c=function(){return t};var t={},r=Object.prototype,n=r.hasOwnProperty,e=Object.defineProperty||function(t,r,n){t[r]=n.value},o="function"==typeof Symbol?Symbol:{},a=o.iterator||"@@iterator",i=o.asyncIterator||"@@asyncIterator",u=o.toStringTag||"@@toStringTag";function h(t,r,n){return Object.defineProperty(t,r,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[r]}try{h({},"")}catch(t){h=function(t,r,n){return t[r]=n}}function l(t,r,n,o){var a=r&&r.prototype instanceof m?r:m,i=Object.create(a.prototype),s=new C(o||[]);return e(i,"_invoke",{value:L(t,n,s)}),i}function p(t,r,n){try{return{type:"normal",arg:t.call(r,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var f={};function m(){}function d(){}function v(){}var y={};h(y,a,(function(){return this}));var g=Object.getPrototypeOf,k=g&&g(g(x([])));k&&k!==r&&n.call(k,a)&&(y=k);var w=v.prototype=m.prototype=Object.create(y);function E(t){["next","throw","return"].forEach((function(r){h(t,r,(function(t){return this._invoke(r,t)}))}))}function b(t,r){function o(e,a,i,c){var u=p(t[e],t,a);if("throw"!==u.type){var h=u.arg,l=h.value;return l&&"object"==s(l)&&n.call(l,"__await")?r.resolve(l.__await).then((function(t){o("next",t,i,c)}),(function(t){o("throw",t,i,c)})):r.resolve(l).then((function(t){h.value=t,i(h)}),(function(t){return o("throw",t,i,c)}))}c(u.arg)}var a;e(this,"_invoke",{value:function(t,n){function e(){return new r((function(r,e){o(t,n,r,e)}))}return a=a?a.then(e,e):e()}})}function L(t,r,n){var e="suspendedStart";return function(o,a){if("executing"===e)throw new Error("Generator is already running");if("completed"===e){if("throw"===o)throw a;return N()}for(n.method=o,n.arg=a;;){var i=n.delegate;if(i){var s=_(i,n);if(s){if(s===f)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===e)throw e="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);e="executing";var c=p(t,r,n);if("normal"===c.type){if(e=n.done?"completed":"suspendedYield",c.arg===f)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(e="completed",n.method="throw",n.arg=c.arg)}}}function _(t,r){var n=r.method,e=t.iterator[n];if(void 0===e)return r.delegate=null,"throw"===n&&t.iterator.return&&(r.method="return",r.arg=void 0,_(t,r),"throw"===r.method)||"return"!==n&&(r.method="throw",r.arg=new TypeError("The iterator does not provide a '"+n+"' method")),f;var o=p(e,t.iterator,r.arg);if("throw"===o.type)return r.method="throw",r.arg=o.arg,r.delegate=null,f;var a=o.arg;return a?a.done?(r[t.resultName]=a.value,r.next=t.nextLoc,"return"!==r.method&&(r.method="next",r.arg=void 0),r.delegate=null,f):a:(r.method="throw",r.arg=new TypeError("iterator result is not an object"),r.delegate=null,f)}function T(t){var r={tryLoc:t[0]};1 in t&&(r.catchLoc=t[1]),2 in t&&(r.finallyLoc=t[2],r.afterLoc=t[3]),this.tryEntries.push(r)}function A(t){var r=t.completion||{};r.type="normal",delete r.arg,t.completion=r}function C(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(T,this),this.reset(!0)}function x(t){if(t){var r=t[a];if(r)return r.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var e=-1,o=function r(){for(;++e<t.length;)if(n.call(t,e))return r.value=t[e],r.done=!1,r;return r.value=void 0,r.done=!0,r};return o.next=o}}return{next:N}}function N(){return{value:void 0,done:!0}}return d.prototype=v,e(w,"constructor",{value:v,configurable:!0}),e(v,"constructor",{value:d,configurable:!0}),d.displayName=h(v,u,"GeneratorFunction"),t.isGeneratorFunction=function(t){var r="function"==typeof t&&t.constructor;return!!r&&(r===d||"GeneratorFunction"===(r.displayName||r.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,v):(t.__proto__=v,h(t,u,"GeneratorFunction")),t.prototype=Object.create(w),t},t.awrap=function(t){return{__await:t}},E(b.prototype),h(b.prototype,i,(function(){return this})),t.AsyncIterator=b,t.async=function(r,n,e,o,a){void 0===a&&(a=Promise);var i=new b(l(r,n,e,o),a);return t.isGeneratorFunction(n)?i:i.next().then((function(t){return t.done?t.value:i.next()}))},E(w),h(w,u,"Generator"),h(w,a,(function(){return this})),h(w,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var r=Object(t),n=[];for(var e in r)n.push(e);return n.reverse(),function t(){for(;n.length;){var e=n.pop();if(e in r)return t.value=e,t.done=!1,t}return t.done=!0,t}},t.values=x,C.prototype={constructor:C,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(A),!t)for(var r in this)"t"===r.charAt(0)&&n.call(this,r)&&!isNaN(+r.slice(1))&&(this[r]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var r=this;function e(n,e){return i.type="throw",i.arg=t,r.next=n,e&&(r.method="next",r.arg=void 0),!!e}for(var o=this.tryEntries.length-1;o>=0;--o){var a=this.tryEntries[o],i=a.completion;if("root"===a.tryLoc)return e("end");if(a.tryLoc<=this.prev){var s=n.call(a,"catchLoc"),c=n.call(a,"finallyLoc");if(s&&c){if(this.prev<a.catchLoc)return e(a.catchLoc,!0);if(this.prev<a.finallyLoc)return e(a.finallyLoc)}else if(s){if(this.prev<a.catchLoc)return e(a.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<a.finallyLoc)return e(a.finallyLoc)}}}},abrupt:function(t,r){for(var e=this.tryEntries.length-1;e>=0;--e){var o=this.tryEntries[e];if(o.tryLoc<=this.prev&&n.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var a=o;break}}a&&("break"===t||"continue"===t)&&a.tryLoc<=r&&r<=a.finallyLoc&&(a=null);var i=a?a.completion:{};return i.type=t,i.arg=r,a?(this.method="next",this.next=a.finallyLoc,f):this.complete(i)},complete:function(t,r){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&r&&(this.next=r),f},finish:function(t){for(var r=this.tryEntries.length-1;r>=0;--r){var n=this.tryEntries[r];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),A(n),f}},catch:function(t){for(var r=this.tryEntries.length-1;r>=0;--r){var n=this.tryEntries[r];if(n.tryLoc===t){var e=n.completion;if("throw"===e.type){var o=e.arg;A(n)}return o}}throw new Error("illegal catch attempt")},delegateYield:function(t,r,n){return this.delegate={iterator:x(t),resultName:r,nextLoc:n},"next"===this.method&&(this.arg=void 0),f}},t}function u(t,r,n,e,o,a,i){try{var s=t[a](i),c=s.value}catch(t){return void n(t)}s.done?r(c):Promise.resolve(c).then(e,o)}function h(t){return function(){var r=this,n=arguments;return new Promise((function(e,o){var a=t.apply(r,n);function i(t){u(a,e,o,i,s,"next",t)}function s(t){u(a,e,o,i,s,"throw",t)}i(void 0)}))}}const l={name:"ViewPublic",components:{BookmarkContent:n(94378).Z,NcContent:e.qF,NcAppContent:e.Mb,Controls:a.Z,BookmarksList:o.Z},data:function(){return{newBookmark:!1}},computed:{bookmarks:function(){return this.$store.state.bookmarks},folders:function(){return this.$store.state.folders},tags:function(){return this.$store.state.tags},loading:function(){return this.$store.state.loading}},watch:{$route:"onRoute"},created:function(){var t=this;return h(c().mark((function r(){return c().wrap((function(r){for(;;)switch(r.prev=r.next){case 0:return t.$store.commit(i.P$.SET_AUTH_TOKEN,t.$route.params.token),t.$store.commit(i.P$.FETCH_START,{type:"bookmarks"}),r.next=4,Promise.all([t.reloadFolders()]);case 4:t.onRoute();case 5:case"end":return r.stop()}}),r)})))()},methods:{onRoute:function(){var t=this;return h(c().mark((function r(){var n;return c().wrap((function(r){for(;;)switch(r.prev=r.next){case 0:n=t.$route,r.t0=n.name,r.next=r.t0===t.routes.HOME?4:r.t0===t.routes.RECENT?5:r.t0===t.routes.UNTAGGED?6:r.t0===t.routes.FOLDER?7:r.t0===t.routes.TAGS?8:r.t0===t.routes.SEARCH?9:10;break;case 4:return r.abrupt("return",t.$store.dispatch(i.Nw.FILTER_BY_FOLDER,"-1"));case 5:return r.abrupt("return",t.$store.dispatch(i.Nw.FILTER_BY_RECENT));case 6:return r.abrupt("return",t.$store.dispatch(i.Nw.FILTER_BY_UNTAGGED));case 7:return r.abrupt("return",t.$store.dispatch(i.Nw.FILTER_BY_FOLDER,n.params.folder));case 8:return r.abrupt("return",t.$store.dispatch(i.Nw.FILTER_BY_TAGS,n.params.tags.split(",")));case 9:return r.abrupt("return",t.$store.dispatch(i.Nw.FILTER_BY_SEARCH,n.params.search));case 10:throw new Error("Nothing here. Move along.");case 11:case"end":return r.stop()}}),r)})))()},reloadTags:function(){var t=this;return h(c().mark((function r(){return c().wrap((function(r){for(;;)switch(r.prev=r.next){case 0:return r.abrupt("return",t.$store.dispatch(i.Nw.LOAD_TAGS));case 1:case"end":return r.stop()}}),r)})))()},reloadFolders:function(){var t=this;return h(c().mark((function r(){return c().wrap((function(r){for(;;)switch(r.prev=r.next){case 0:return r.abrupt("return",t.$store.dispatch(i.Nw.LOAD_FOLDERS));case 1:case"end":return r.stop()}}),r)})))()},onSearch:function(t){this.$router.push({name:this.routes.SEARCH,params:{search:t}})},onResetSearch:function(){this.$router.push({name:this.routes.HOME})}}};var p=n(93379),f=n.n(p),m=n(7795),d=n.n(m),v=n(90569),y=n.n(v),g=n(3565),k=n.n(g),w=n(19216),E=n.n(w),b=n(44589),L=n.n(b),_=n(6495),T={};T.styleTagTransform=L(),T.setAttributes=k(),T.insert=y().bind(null,"head"),T.domAPI=d(),T.insertStyleElement=E();f()(_.Z,T);_.Z&&_.Z.locals&&_.Z.locals;const A=(0,n(51900).Z)(l,(function(){var t=this,r=t._self._c;return r("NcContent",{attrs:{"app-name":"bookmarks"}},[r("NcAppContent",[r("Controls"),t._v(" "),r("BookmarksList",{attrs:{loading:!!t.loading.bookmarks,bookmarks:t.bookmarks}})],1),t._v(" "),r("BookmarkContent")],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=bookmarks-src_components_ViewPublic_vue.js.map?v=3de5262ef45fef3ca8ed