/*! For license information please see bookmarks-src_components_FolderPicker_vue.js.LICENSE.txt */
"use strict";(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_FolderPicker_vue"],{49899:(e,t,r)=>{r.d(t,{Z:()=>d});var n=r(87537),o=r.n(n),l=r(23645),i=r.n(l)()(o());i.push([e.id,"\n.folderpicker {\n\tmin-height: 300px;\n\tdisplay: flex;\n\tflex-direction: column;\n}\n.folderpicker .currentfolder {\n\tdisplay: flex;\n\talign-items: center;\n\theight: 45px;\n}\n.currentfolder h2 {\n\tmargin: 0;\n\tdisplay: flex;\n}\n.folderpicker .actions {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tjustify-content: end;\n\talign-items: end;\n}\n","",{version:3,sources:["webpack://./src/components/FolderPicker.vue"],names:[],mappings:";AAiGA;CACA,iBAAA;CACA,aAAA;CACA,sBAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,YAAA;AACA;AAEA;CACA,SAAA;CACA,aAAA;AACA;AAEA;CACA,YAAA;CACA,aAAA;CACA,oBAAA;CACA,gBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class="folderpicker">\n\t\t<h2>{{ title }}</h2>\n\t\t<div class="currentfolder">\n\t\t\t<NcActions v-if="currentFolder.id !== -1">\n\t\t\t\t<NcActionButton @click="onSelect(currentFolder.parent_folder)">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<ArrowLeftIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Go back\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<h2 v-if="currentFolder.id !== -1">\n\t\t\t\t<FolderIcon /><span>{{ currentFolder.title }}</span>\n\t\t\t</h2>\n\t\t\t<h2 v-else>\n\t\t\t\t<HomeIcon />\n\t\t\t</h2>\n\t\t</div>\n\t\t<TreeFolder v-for="folder of items"\n\t\t\t:key="folder.id"\n\t\t\t:folder="folder"\n\t\t\t:show-children="false"\n\t\t\t@select="folder.children && onSelect(folder.id)" />\n\t\t<div class="actions">\n\t\t\t<button class="button" @click="onSubmit">\n\t\t\t\t{{ t(\'bookmarks\', \'Choose folder\') }}\n\t\t\t</button>\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport { NcActions, NcActionButton } from \'@nextcloud/vue\'\nimport FolderIcon from \'vue-material-design-icons/Folder.vue\'\nimport ArrowLeftIcon from \'vue-material-design-icons/ArrowLeft.vue\'\nimport HomeIcon from \'vue-material-design-icons/Home.vue\'\nimport TreeFolder from \'./TreeFolder.vue\'\n\nexport default {\n\tname: \'FolderPicker\',\n\tcomponents: {\n\t\tTreeFolder,\n\t\tNcActions,\n\t\tNcActionButton,\n\t\tFolderIcon,\n\t\tArrowLeftIcon,\n\t\tHomeIcon,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\tfilter: {\n\t\t\ttype: Function,\n\t\t\trequired: false,\n\t\t\tdefault: () => true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tselectedFolderId: -1,\n\t\t}\n\t},\n\tcomputed: {\n\t\tcurrentFolderPath() {\n\t\t\treturn this.$store.getters.getFolder(this.selectedFolderId).reverse()\n\t\t},\n\t\tcurrentFolder() {\n\t\t\treturn this.$store.getters.getFolder(this.selectedFolderId)[0]\n\t\t},\n\t\titems() {\n\t\t\treturn this.currentFolder.children.filter(this.filter)\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onSelect(folderId) {\n\t\t\tif (!this.$store.getters.getFolder(folderId)[0]) {\n\t\t\t\tthis.selectedFolderId = -1\n\t\t\t} else {\n\t\t\t\tthis.selectedFolderId = folderId\n\t\t\t}\n\t\t},\n\t\tasync onSubmit() {\n\t\t\tthis.$emit(\'submit\', this.selectedFolderId)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.folderpicker {\n\tmin-height: 300px;\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.folderpicker .currentfolder {\n\tdisplay: flex;\n\talign-items: center;\n\theight: 45px;\n}\n\n.currentfolder h2 {\n\tmargin: 0;\n\tdisplay: flex;\n}\n\n.folderpicker .actions {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tjustify-content: end;\n\talign-items: end;\n}\n</style>\n'],sourceRoot:""}]);const d=i},54027:(e,t,r)=>{r.d(t,{Z:()=>d});var n=r(87537),o=r.n(n),l=r(23645),i=r.n(l)()(o());i.push([e.id,"\n.treefolder__title .material-design-icon {\n\tposition: relative;\n\ttop: 1px;\n\tmargin: 0 15px;\n}\n.treefolder__icon-hover:hover {\n\topacity: 0.8;\n}\n.treefolder__title {\n\tdisplay: flex;\n\talign-items: center;\n\tpadding: 0 10px;\n\tmargin: 0 -10px;\n\tcursor: pointer;\n}\n.treefolder__title * {\n\tcursor: pointer;\n}\n.treefolder.active > .treefolder__title,\n.treefolder__title:hover,\n.treefolder__title:focus {\n\tbackground: var(--color-background-dark);\n}\n.treefolder__title > h3 {\n\tflex: 1;\n\tdisplay: flex;\n}\n.treefolder__children .treefolder__title {\n\tpadding-left: 25px;\n}\n.treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 50px;\n}\n.treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 75px;\n}\n.treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 100px;\n}\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 125px;\n}\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 150px;\n}\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 175px;\n}\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 200px;\n}\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 225px;\n}\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 250px;\n}\n","",{version:3,sources:["webpack://./src/components/TreeFolder.vue"],names:[],mappings:";AAwEA;CACA,kBAAA;CACA,QAAA;CACA,cAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,eAAA;CACA,eAAA;CACA,eAAA;AACA;AAEA;CACA,eAAA;AACA;AAEA;;;CAGA,wCAAA;AACA;AAEA;CACA,OAAA;CACA,aAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,mBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2022. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div :class="{treefolder:true, active}">\n\t\t<div class="treefolder__title" @click="$emit(\'select\', folder.id)">\n\t\t\t<h3>\n\t\t\t\t<FolderIcon v-if="!childrenShown"\n\t\t\t\t\tclass="treefolder__icon-hover"\n\t\t\t\t\t:fill-color="colorPrimaryElement"\n\t\t\t\t\t@click.stop="folder.children.length && showChildren && (childrenShown = true)" />\n\t\t\t\t<FolderOpenIcon v-else\n\t\t\t\t\tclass="treefolder__icon-hover"\n\t\t\t\t\t:fill-color="colorPrimaryElement"\n\t\t\t\t\t@click.stop="folder.children.length && (childrenShown = false)" />\n\t\t\t\t{{ folder.title }}\n\t\t\t</h3>\n\t\t</div>\n\t\t<div v-if="showChildren && childrenShown" class="treefolder__children">\n\t\t\t<TreeFolder v-for="f in folder.children"\n\t\t\t\t:key="f.id"\n\t\t\t\t:folder="f"\n\t\t\t\t@select="$emit(\'select\', $event)" />\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport FolderIcon from \'vue-material-design-icons/Folder.vue\'\nimport FolderOpenIcon from \'vue-material-design-icons/FolderOpen.vue\'\nimport { privateRoutes } from \'../router.js\'\nexport default {\n\tname: \'TreeFolder\',\n\tcomponents: { FolderIcon, FolderOpenIcon },\n\tprops: {\n\t\tfolder: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t\tshowChildren: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tchildrenShown: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tactive() {\n\t\t\treturn this.$route.params.folder === this.folder.id\n\t\t},\n\t},\n\twatch: {\n\t\t\'$route\'() {\n\t\t\tif (this.$route.name === privateRoutes.FOLDER\n\t\t\t\t\t&& (this.$route.params.folder === this.folder.id\n\t\t\t\t\t\t\t|| this.folder.children.find(f => f.id === this.$route.params.folder))\n\t\t\t) {\n\t\t\t\tthis.childrenShown = true\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n\n.treefolder__title .material-design-icon {\n\tposition: relative;\n\ttop: 1px;\n\tmargin: 0 15px;\n}\n\n.treefolder__icon-hover:hover {\n\topacity: 0.8;\n}\n\n.treefolder__title {\n\tdisplay: flex;\n\talign-items: center;\n\tpadding: 0 10px;\n\tmargin: 0 -10px;\n\tcursor: pointer;\n}\n\n.treefolder__title * {\n\tcursor: pointer;\n}\n\n.treefolder.active > .treefolder__title,\n.treefolder__title:hover,\n.treefolder__title:focus {\n\tbackground: var(--color-background-dark);\n}\n\n.treefolder__title > h3 {\n\tflex: 1;\n\tdisplay: flex;\n}\n\n.treefolder__children .treefolder__title {\n\tpadding-left: 25px;\n}\n\n.treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 50px;\n}\n\n.treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 75px;\n}\n\n.treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 100px;\n}\n\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 125px;\n}\n\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 150px;\n}\n\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 175px;\n}\n\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 200px;\n}\n\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 225px;\n}\n\n.treefolder__children .treefolder__children .treefolder__children  .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__children .treefolder__title {\n\tpadding-left: 250px;\n}\n</style>\n'],sourceRoot:""}]);const d=i},75145:(e,t,r)=>{r.d(t,{Z:()=>b});var n=r(15961),o=r(34829),l=r(32219),i=r(15764);function d(e){return d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},d(e)}function c(){c=function(){return e};var e={},t=Object.prototype,r=t.hasOwnProperty,n=Object.defineProperty||function(e,t,r){e[t]=r.value},o="function"==typeof Symbol?Symbol:{},l=o.iterator||"@@iterator",i=o.asyncIterator||"@@asyncIterator",f=o.toStringTag||"@@toStringTag";function a(e,t,r){return Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}),e[t]}try{a({},"")}catch(e){a=function(e,t,r){return e[t]=r}}function s(e,t,r,o){var l=t&&t.prototype instanceof _?t:_,i=Object.create(l.prototype),d=new E(o||[]);return n(i,"_invoke",{value:w(e,r,d)}),i}function h(e,t,r){try{return{type:"normal",arg:e.call(t,r)}}catch(e){return{type:"throw",arg:e}}}e.wrap=s;var u={};function _(){}function A(){}function p(){}var m={};a(m,l,(function(){return this}));var v=Object.getPrototypeOf,y=v&&v(v(I([])));y&&y!==t&&r.call(y,l)&&(m=y);var g=p.prototype=_.prototype=Object.create(m);function C(e){["next","throw","return"].forEach((function(t){a(e,t,(function(e){return this._invoke(t,e)}))}))}function x(e,t){function o(n,l,i,c){var f=h(e[n],e,l);if("throw"!==f.type){var a=f.arg,s=a.value;return s&&"object"==d(s)&&r.call(s,"__await")?t.resolve(s.__await).then((function(e){o("next",e,i,c)}),(function(e){o("throw",e,i,c)})):t.resolve(s).then((function(e){a.value=e,i(a)}),(function(e){return o("throw",e,i,c)}))}c(f.arg)}var l;n(this,"_invoke",{value:function(e,r){function n(){return new t((function(t,n){o(e,r,t,n)}))}return l=l?l.then(n,n):n()}})}function w(e,t,r){var n="suspendedStart";return function(o,l){if("executing"===n)throw new Error("Generator is already running");if("completed"===n){if("throw"===o)throw l;return S()}for(r.method=o,r.arg=l;;){var i=r.delegate;if(i){var d=F(i,r);if(d){if(d===u)continue;return d}}if("next"===r.method)r.sent=r._sent=r.arg;else if("throw"===r.method){if("suspendedStart"===n)throw n="completed",r.arg;r.dispatchException(r.arg)}else"return"===r.method&&r.abrupt("return",r.arg);n="executing";var c=h(e,t,r);if("normal"===c.type){if(n=r.done?"completed":"suspendedYield",c.arg===u)continue;return{value:c.arg,done:r.done}}"throw"===c.type&&(n="completed",r.method="throw",r.arg=c.arg)}}}function F(e,t){var r=t.method,n=e.iterator[r];if(void 0===n)return t.delegate=null,"throw"===r&&e.iterator.return&&(t.method="return",t.arg=void 0,F(e,t),"throw"===t.method)||"return"!==r&&(t.method="throw",t.arg=new TypeError("The iterator does not provide a '"+r+"' method")),u;var o=h(n,e.iterator,t.arg);if("throw"===o.type)return t.method="throw",t.arg=o.arg,t.delegate=null,u;var l=o.arg;return l?l.done?(t[e.resultName]=l.value,t.next=e.nextLoc,"return"!==t.method&&(t.method="next",t.arg=void 0),t.delegate=null,u):l:(t.method="throw",t.arg=new TypeError("iterator result is not an object"),t.delegate=null,u)}function k(e){var t={tryLoc:e[0]};1 in e&&(t.catchLoc=e[1]),2 in e&&(t.finallyLoc=e[2],t.afterLoc=e[3]),this.tryEntries.push(t)}function b(e){var t=e.completion||{};t.type="normal",delete t.arg,e.completion=t}function E(e){this.tryEntries=[{tryLoc:"root"}],e.forEach(k,this),this.reset(!0)}function I(e){if(e){var t=e[l];if(t)return t.call(e);if("function"==typeof e.next)return e;if(!isNaN(e.length)){var n=-1,o=function t(){for(;++n<e.length;)if(r.call(e,n))return t.value=e[n],t.done=!1,t;return t.value=void 0,t.done=!0,t};return o.next=o}}return{next:S}}function S(){return{value:void 0,done:!0}}return A.prototype=p,n(g,"constructor",{value:p,configurable:!0}),n(p,"constructor",{value:A,configurable:!0}),A.displayName=a(p,f,"GeneratorFunction"),e.isGeneratorFunction=function(e){var t="function"==typeof e&&e.constructor;return!!t&&(t===A||"GeneratorFunction"===(t.displayName||t.name))},e.mark=function(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,p):(e.__proto__=p,a(e,f,"GeneratorFunction")),e.prototype=Object.create(g),e},e.awrap=function(e){return{__await:e}},C(x.prototype),a(x.prototype,i,(function(){return this})),e.AsyncIterator=x,e.async=function(t,r,n,o,l){void 0===l&&(l=Promise);var i=new x(s(t,r,n,o),l);return e.isGeneratorFunction(r)?i:i.next().then((function(e){return e.done?e.value:i.next()}))},C(g),a(g,f,"Generator"),a(g,l,(function(){return this})),a(g,"toString",(function(){return"[object Generator]"})),e.keys=function(e){var t=Object(e),r=[];for(var n in t)r.push(n);return r.reverse(),function e(){for(;r.length;){var n=r.pop();if(n in t)return e.value=n,e.done=!1,e}return e.done=!0,e}},e.values=I,E.prototype={constructor:E,reset:function(e){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(b),!e)for(var t in this)"t"===t.charAt(0)&&r.call(this,t)&&!isNaN(+t.slice(1))&&(this[t]=void 0)},stop:function(){this.done=!0;var e=this.tryEntries[0].completion;if("throw"===e.type)throw e.arg;return this.rval},dispatchException:function(e){if(this.done)throw e;var t=this;function n(r,n){return i.type="throw",i.arg=e,t.next=r,n&&(t.method="next",t.arg=void 0),!!n}for(var o=this.tryEntries.length-1;o>=0;--o){var l=this.tryEntries[o],i=l.completion;if("root"===l.tryLoc)return n("end");if(l.tryLoc<=this.prev){var d=r.call(l,"catchLoc"),c=r.call(l,"finallyLoc");if(d&&c){if(this.prev<l.catchLoc)return n(l.catchLoc,!0);if(this.prev<l.finallyLoc)return n(l.finallyLoc)}else if(d){if(this.prev<l.catchLoc)return n(l.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<l.finallyLoc)return n(l.finallyLoc)}}}},abrupt:function(e,t){for(var n=this.tryEntries.length-1;n>=0;--n){var o=this.tryEntries[n];if(o.tryLoc<=this.prev&&r.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var l=o;break}}l&&("break"===e||"continue"===e)&&l.tryLoc<=t&&t<=l.finallyLoc&&(l=null);var i=l?l.completion:{};return i.type=e,i.arg=t,l?(this.method="next",this.next=l.finallyLoc,u):this.complete(i)},complete:function(e,t){if("throw"===e.type)throw e.arg;return"break"===e.type||"continue"===e.type?this.next=e.arg:"return"===e.type?(this.rval=this.arg=e.arg,this.method="return",this.next="end"):"normal"===e.type&&t&&(this.next=t),u},finish:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var r=this.tryEntries[t];if(r.finallyLoc===e)return this.complete(r.completion,r.afterLoc),b(r),u}},catch:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var r=this.tryEntries[t];if(r.tryLoc===e){var n=r.completion;if("throw"===n.type){var o=n.arg;b(r)}return o}}throw new Error("illegal catch attempt")},delegateYield:function(e,t,r){return this.delegate={iterator:I(e),resultName:t,nextLoc:r},"next"===this.method&&(this.arg=void 0),u}},e}function f(e,t,r,n,o,l,i){try{var d=e[l](i),c=d.value}catch(e){return void r(e)}d.done?t(c):Promise.resolve(c).then(n,o)}function a(e){return function(){var t=this,r=arguments;return new Promise((function(n,o){var l=e.apply(t,r);function i(e){f(l,n,o,i,d,"next",e)}function d(e){f(l,n,o,i,d,"throw",e)}i(void 0)}))}}const s={name:"FolderPicker",components:{TreeFolder:r(19823).Z,NcActions:n.O3,NcActionButton:n.Js,FolderIcon:o.default,ArrowLeftIcon:l.default,HomeIcon:i.Z},props:{title:{type:String,required:!0},filter:{type:Function,required:!1,default:function(){return!0}}},data:function(){return{selectedFolderId:-1}},computed:{currentFolderPath:function(){return this.$store.getters.getFolder(this.selectedFolderId).reverse()},currentFolder:function(){return this.$store.getters.getFolder(this.selectedFolderId)[0]},items:function(){return this.currentFolder.children.filter(this.filter)}},methods:{onSelect:function(e){var t=this;return a(c().mark((function r(){return c().wrap((function(r){for(;;)switch(r.prev=r.next){case 0:t.$store.getters.getFolder(e)[0]?t.selectedFolderId=e:t.selectedFolderId=-1;case 1:case"end":return r.stop()}}),r)})))()},onSubmit:function(){var e=this;return a(c().mark((function t(){return c().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:e.$emit("submit",e.selectedFolderId);case 1:case"end":return t.stop()}}),t)})))()}}};var h=r(93379),u=r.n(h),_=r(7795),A=r.n(_),p=r(90569),m=r.n(p),v=r(3565),y=r.n(v),g=r(19216),C=r.n(g),x=r(44589),w=r.n(x),F=r(49899),k={};k.styleTagTransform=w(),k.setAttributes=y(),k.insert=m().bind(null,"head"),k.domAPI=A(),k.insertStyleElement=C();u()(F.Z,k);F.Z&&F.Z.locals&&F.Z.locals;const b=(0,r(51900).Z)(s,(function(){var e=this,t=e._self._c;return t("div",{staticClass:"folderpicker"},[t("h2",[e._v(e._s(e.title))]),e._v(" "),t("div",{staticClass:"currentfolder"},[-1!==e.currentFolder.id?t("NcActions",[t("NcActionButton",{on:{click:function(t){return e.onSelect(e.currentFolder.parent_folder)}},scopedSlots:e._u([{key:"icon",fn:function(){return[t("ArrowLeftIcon")]},proxy:!0}],null,!1,3001860362)},[e._v("\n\t\t\t\t"+e._s(e.t("bookmarks","Go back"))+"\n\t\t\t")])],1):e._e(),e._v(" "),-1!==e.currentFolder.id?t("h2",[t("FolderIcon"),t("span",[e._v(e._s(e.currentFolder.title))])],1):t("h2",[t("HomeIcon")],1)],1),e._v(" "),e._l(e.items,(function(r){return t("TreeFolder",{key:r.id,attrs:{folder:r,"show-children":!1},on:{select:function(t){r.children&&e.onSelect(r.id)}}})})),e._v(" "),t("div",{staticClass:"actions"},[t("button",{staticClass:"button",on:{click:e.onSubmit}},[e._v("\n\t\t\t"+e._s(e.t("bookmarks","Choose folder"))+"\n\t\t")])])],2)}),[],!1,null,null,null).exports},19823:(e,t,r)=>{r.d(t,{Z:()=>C});var n=r(34829),o=r(74275),l=r(41209);const i={name:"TreeFolder",components:{FolderIcon:n.default,FolderOpenIcon:o.Z},props:{folder:{type:Object,required:!0},showChildren:{type:Boolean,default:!0}},data:function(){return{childrenShown:!1}},computed:{active:function(){return this.$route.params.folder===this.folder.id}},watch:{$route:function(){var e=this;this.$route.name!==l.xu.FOLDER||this.$route.params.folder!==this.folder.id&&!this.folder.children.find((function(t){return t.id===e.$route.params.folder}))||(this.childrenShown=!0)}}};var d=r(93379),c=r.n(d),f=r(7795),a=r.n(f),s=r(90569),h=r.n(s),u=r(3565),_=r.n(u),A=r(19216),p=r.n(A),m=r(44589),v=r.n(m),y=r(54027),g={};g.styleTagTransform=v(),g.setAttributes=_(),g.insert=h().bind(null,"head"),g.domAPI=a(),g.insertStyleElement=p();c()(y.Z,g);y.Z&&y.Z.locals&&y.Z.locals;const C=(0,r(51900).Z)(i,(function(){var e=this,t=e._self._c;return t("div",{class:{treefolder:!0,active:e.active}},[t("div",{staticClass:"treefolder__title",on:{click:function(t){return e.$emit("select",e.folder.id)}}},[t("h3",[e.childrenShown?t("FolderOpenIcon",{staticClass:"treefolder__icon-hover",attrs:{"fill-color":e.colorPrimaryElement},on:{click:function(t){t.stopPropagation(),e.folder.children.length&&(e.childrenShown=!1)}}}):t("FolderIcon",{staticClass:"treefolder__icon-hover",attrs:{"fill-color":e.colorPrimaryElement},on:{click:function(t){t.stopPropagation(),e.folder.children.length&&e.showChildren&&(e.childrenShown=!0)}}}),e._v("\n\t\t\t"+e._s(e.folder.title)+"\n\t\t")],1)]),e._v(" "),e.showChildren&&e.childrenShown?t("div",{staticClass:"treefolder__children"},e._l(e.folder.children,(function(r){return t("TreeFolder",{key:r.id,attrs:{folder:r},on:{select:function(t){return e.$emit("select",t)}}})})),1):e._e()])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=bookmarks-src_components_FolderPicker_vue.js.map?v=a322e342a8b651b44e61