/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptOrFnNode;

public class Node {
    public static final int FUNCTION_PROP = 1;
    public static final int TEMP_PROP = 2;
    public static final int LOCAL_PROP = 3;
    public static final int LOCAL_BLOCK_PROP = 4;
    public static final int FIXUPS_PROP = 5;
    public static final int USES_PROP = 6;
    public static final int REGEXP_PROP = 7;
    public static final int CASES_PROP = 8;
    public static final int DEFAULT_PROP = 9;
    public static final int CASEARRAY_PROP = 10;
    public static final int SPECIAL_PROP_PROP = 11;
    public static final int TARGETBLOCK_PROP = 12;
    public static final int VARIABLE_PROP = 13;
    public static final int LASTUSE_PROP = 14;
    public static final int ISNUMBER_PROP = 15;
    public static final int DIRECTCALL_PROP = 16;
    public static final int SPECIALCALL_PROP = 17;
    public static final int SPECIAL_PROP_PROTO = 1;
    public static final int SPECIAL_PROP_PARENT = 2;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int NON_SPECIALCALL = 0;
    public static final int SPECIALCALL_EVAL = 1;
    public static final int SPECIALCALL_WITH = 2;
    int type;
    Node next;
    private Node first;
    private Node last;
    private int lineno = -1;
    private PropListItem propListHead;

    public Node(int nodeType) {
        this.type = nodeType;
    }

    public Node(int nodeType, Node child) {
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
    }

    public Node(int nodeType, Node left, Node right) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = right;
        right.next = null;
    }

    public Node(int nodeType, Node left, Node mid, Node right) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = right;
        right.next = null;
    }

    public Node(int nodeType, int line) {
        this.type = nodeType;
        this.lineno = line;
    }

    public Node(int nodeType, Node child, int line) {
        this(nodeType, child);
        this.lineno = line;
    }

    public Node(int nodeType, Node left, Node right, int line) {
        this(nodeType, left, right);
        this.lineno = line;
    }

    public Node(int nodeType, Node left, Node mid, Node right, int line) {
        this(nodeType, left, mid, right);
        this.lineno = line;
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newString(String str) {
        return new StringNode(41, str);
    }

    public static Node newString(int type, String str) {
        return new StringNode(type, str);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getChildBefore(Node child) {
        if (child == this.first) {
            return null;
        }
        Node n = this.first;
        while (n.next != child) {
            n = n.next;
            if (n != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return n;
    }

    public Node getLastSibling() {
        Node n = this;
        while (n.next != null) {
            n = n.next;
        }
        return n;
    }

    public void addChildToFront(Node child) {
        child.next = this.first;
        this.first = child;
        if (this.last == null) {
            this.last = child;
        }
    }

    public void addChildToBack(Node child) {
        child.next = null;
        if (this.last == null) {
            this.first = this.last = child;
            return;
        }
        this.last.next = child;
        this.last = child;
    }

    public void addChildrenToFront(Node children) {
        Node lastSib = children.getLastSibling();
        lastSib.next = this.first;
        this.first = children;
        if (this.last == null) {
            this.last = lastSib;
        }
    }

    public void addChildrenToBack(Node children) {
        if (this.last != null) {
            this.last.next = children;
        }
        this.last = children.getLastSibling();
        if (this.first == null) {
            this.first = children;
        }
    }

    public void addChildBefore(Node newChild, Node node) {
        if (newChild.next != null) {
            throw new RuntimeException("newChild had siblings in addChildBefore");
        }
        if (this.first == node) {
            newChild.next = this.first;
            this.first = newChild;
            return;
        }
        Node prev = this.getChildBefore(node);
        this.addChildAfter(newChild, prev);
    }

    public void addChildAfter(Node newChild, Node node) {
        if (newChild.next != null) {
            throw new RuntimeException("newChild had siblings in addChildAfter");
        }
        newChild.next = node.next;
        node.next = newChild;
        if (this.last == node) {
            this.last = newChild;
        }
    }

    public void removeChild(Node child) {
        Node prev = this.getChildBefore(child);
        if (prev == null) {
            this.first = this.first.next;
        } else {
            prev.next = child.next;
        }
        if (child == this.last) {
            this.last = prev;
        }
        child.next = null;
    }

    public void replaceChild(Node child, Node newChild) {
        newChild.next = child.next;
        if (child == this.first) {
            this.first = newChild;
        } else {
            Node prev = this.getChildBefore(child);
            prev.next = newChild;
        }
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
    }

    public void replaceChildAfter(Node prevChild, Node newChild) {
        Node child = prevChild.next;
        newChild.next = child.next;
        prevChild.next = newChild;
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
    }

    private static final String propToString(int propType) {
        return null;
    }

    private PropListItem lookupProperty(int propType) {
        PropListItem x = this.propListHead;
        while (x != null && propType != x.type) {
            x = x.next;
        }
        return x;
    }

    private PropListItem ensureProperty(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            item = new PropListItem();
            item.type = propType;
            item.next = this.propListHead;
            this.propListHead = item;
        }
        return item;
    }

    public void removeProp(int propType) {
        PropListItem x = this.propListHead;
        if (x != null) {
            PropListItem prev = null;
            while (x.type != propType) {
                prev = x;
                x = x.next;
                if (x != null) continue;
                return;
            }
            if (prev == null) {
                this.propListHead = x.next;
            } else {
                prev.next = x.next;
            }
        }
    }

    public Object getProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return null;
        }
        return item.objectValue;
    }

    public int getIntProp(int propType, int defaultValue) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return defaultValue;
        }
        return item.intValue;
    }

    public int getExistingIntProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            Kit.codeBug();
        }
        return item.intValue;
    }

    public void putProp(int propType, Object prop) {
        if (prop == null) {
            this.removeProp(propType);
        } else {
            PropListItem item = this.ensureProperty(propType);
            item.objectValue = prop;
        }
    }

    public void putIntProp(int propType, int prop) {
        PropListItem item = this.ensureProperty(propType);
        item.intValue = prop;
    }

    public int getLineno() {
        return this.lineno;
    }

    public final double getDouble() {
        return ((NumberNode)this).number;
    }

    public final void setDouble(double number) {
        ((NumberNode)this).number = number;
    }

    public final String getString() {
        return ((StringNode)this).str;
    }

    public final void setString(String s) {
        if (s == null) {
            Kit.codeBug();
        }
        ((StringNode)this).str = s;
    }

    public String toString() {
        return null;
    }

    public String toStringTree(ScriptOrFnNode treeTop) {
        return null;
    }

    private static void toStringTreeHelper(ScriptOrFnNode treeTop, Node n, int level, StringBuffer sb) {
    }

    private static class NumberNode
    extends Node {
        double number;

        NumberNode(double number) {
            super(40);
            this.number = number;
        }
    }

    private static class StringNode
    extends Node {
        String str;

        StringNode(int type, String str) {
            super(type);
            this.str = str;
        }
    }

    private static class PropListItem {
        PropListItem next;
        int type;
        int intValue;
        Object objectValue;

        private PropListItem() {
        }
    }

    public static class Target
    extends Node {
        public int labelId = -1;

        public Target() {
            super(111);
        }
    }

    public static class Jump
    extends Node {
        public Target target;
        private Target target2;
        private String label;

        public Jump(int type) {
            super(type);
        }

        Jump(int type, int lineno) {
            super(type, lineno);
        }

        Jump(int type, Node child) {
            super(type, child);
        }

        Jump(int type, Node child, int lineno) {
            super(type, child, lineno);
        }

        public final String getLabel() {
            if (this.type != 98 && this.type != 99 && this.type != 110) {
                Kit.codeBug();
            }
            return this.label;
        }

        public final void setLabel(String label) {
            if (this.type != 98 && this.type != 99 && this.type != 110) {
                Kit.codeBug();
            }
            if (label == null) {
                Kit.codeBug();
            }
            if (this.label != null) {
                Kit.codeBug();
            }
            this.label = label;
        }

        public final Target getFinally() {
            if (this.type != 69) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setFinally(Target finallyTarget) {
            if (this.type != 69) {
                Kit.codeBug();
            }
            if (finallyTarget == null) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = finallyTarget;
        }

        public final Target getContinue() {
            if (this.type != 110 && this.type != 112) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setContinue(Target continueTarget) {
            if (this.type != 110 && this.type != 112) {
                Kit.codeBug();
            }
            if (continueTarget == null) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = continueTarget;
        }
    }
}

