/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOverloadabilityHelper;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeSpecificityComparatorProvider;
import org.jetbrains.kotlin.fir.declarations.FirTypeSpecificityComparatorProviderKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.calls.ConeSimpleConstraintSystemImpl;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadabilitySpecificityCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002J$\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirDeclarationOverloadabilityHelperImpl;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOverloadabilityHelper;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "createEmptyConstraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/results/SimpleConstraintSystem;", "createSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "declaration", "isNotLessSpecific", "", "sigA", "sigB", "isOverloadable", "a", "b", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationOverloadabilityHelperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationOverloadabilityHelperImpl.kt\norg/jetbrains/kotlin/fir/resolve/calls/FirDeclarationOverloadabilityHelperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,62:1\n1549#2:63\n1620#2,3:64\n1620#2,3:67\n1620#2,3:71\n1747#2,3:74\n1#3:70\n37#4:77\n37#5:78\n*S KotlinDebug\n*F\n+ 1 FirDeclarationOverloadabilityHelperImpl.kt\norg/jetbrains/kotlin/fir/resolve/calls/FirDeclarationOverloadabilityHelperImpl\n*L\n43#1:63\n43#1:64,3\n45#1:67,3\n47#1:71,3\n51#1:74,3\n53#1:77\n54#1:78\n*E\n"})
public final class FirDeclarationOverloadabilityHelperImpl
implements FirDeclarationOverloadabilityHelper {
    @NotNull
    private final FirSession session;

    public FirDeclarationOverloadabilityHelperImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    public boolean isOverloadable(@NotNull FirCallableDeclaration a, @NotNull FirCallableDeclaration b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        FlatSignature<FirCallableDeclaration> sigA = this.createSignature(a);
        FlatSignature<FirCallableDeclaration> sigB = this.createSignature(b);
        return !this.isNotLessSpecific(sigA, sigB) || !this.isNotLessSpecific(sigB, sigA);
    }

    private final boolean isNotLessSpecific(FlatSignature<? extends FirCallableDeclaration> sigA, FlatSignature<? extends FirCallableDeclaration> sigB) {
        SimpleConstraintSystem simpleConstraintSystem = this.createEmptyConstraintSystem();
        SpecificityComparisonCallbacks specificityComparisonCallbacks = OverloadabilitySpecificityCallbacks.INSTANCE;
        Object object = FirTypeSpecificityComparatorProviderKt.getTypeSpecificityComparatorProvider(this.session);
        if (object == null || (object = ((FirTypeSpecificityComparatorProvider)object).getTypeSpecificityComparator()) == null) {
            object = TypeSpecificityComparator.NONE.INSTANCE;
        }
        return FlatSignatureKt.isSignatureNotLessSpecific$default(simpleConstraintSystem, sigA, sigB, specificityComparisonCallbacks, (TypeSpecificityComparator)object, false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FlatSignature<FirCallableDeclaration> createSignature(FirCallableDeclaration declaration) {
        boolean bl;
        boolean bl2;
        int n;
        Object object;
        Collection collection;
        FirCallableDeclaration firCallableDeclaration;
        block8: {
            void $this$any$iv;
            void $this$createSignature_u24lambda_u244;
            FirPureAbstractElement it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            FirFunction firFunction = declaration instanceof FirFunction ? (FirFunction)declaration : null;
            List<FirValueParameter> list2 = firFunction != null ? firFunction.getValueParameters() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List<FirValueParameter> valueParameters2 = list2;
            Iterable iterable = declaration.getTypeParameters();
            firCallableDeclaration = declaration;
            boolean $i$f$map22 = false;
            void var5_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getSymbol().toLookupTag());
            }
            List $i$f$map22 = $this$map$iv = CollectionsKt.createListBuilder();
            collection = (List)destination$iv$iv;
            boolean bl4 = false;
            Iterable $this$mapTo$iv = declaration.getContextReceivers();
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                it = (FirContextReceiver)item$iv;
                Collection collection2 = (Collection)$this$createSignature_u24lambda_u244;
                boolean bl5 = false;
                collection2.add(FirTypeUtilsKt.getConeType(((FirContextReceiver)it).getTypeRef()));
            }
            Collection cfr_ignored_0 = (Collection)$this$createSignature_u24lambda_u244;
            FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
            if (firReceiverParameter != null) {
                FirReceiverParameter it2 = firReceiverParameter;
                boolean bl6 = false;
                $this$createSignature_u24lambda_u244.add(FirTypeUtilsKt.getConeType(it2.getTypeRef()));
            }
            $this$mapTo$iv = valueParameters2;
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                it = (FirValueParameter)item$iv;
                Collection collection3 = (Collection)$this$createSignature_u24lambda_u244;
                boolean bl7 = false;
                collection3.add(FirTypeUtilsKt.getConeType(((FirValueParameter)it).getReturnTypeRef()));
            }
            Collection cfr_ignored_1 = (Collection)$this$createSignature_u24lambda_u244;
            object = Unit.INSTANCE;
            List list3 = CollectionsKt.build($this$map$iv);
            $this$map$iv = valueParameters2;
            n = declaration.getContextReceivers().size();
            bl2 = declaration.getReceiverParameter() != null;
            object = list3;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter it3 = (FirValueParameter)element$iv;
                    boolean bl8 = false;
                    if (!it3.isVararg()) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean bl9 = bl;
        FirMemberDeclaration $this$isExpect$iv = declaration;
        boolean $i$f$isExpect = false;
        FirDeclaration $this$isSynthetic$iv = declaration;
        boolean $i$f$isSynthetic = false;
        boolean bl10 = $this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic;
        boolean bl11 = $this$isExpect$iv.getStatus().isExpect();
        int n2 = 0;
        boolean bl12 = bl9;
        int n3 = n;
        boolean bl13 = bl2;
        Object object2 = object;
        Collection collection4 = collection;
        FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration;
        return new FlatSignature<FirCallableDeclaration>(firCallableDeclaration2, (Collection<? extends TypeParameterMarker>)collection4, (List<? extends KotlinTypeMarker>)object2, bl13, n3, bl12, n2, bl11, bl10);
    }

    private final SimpleConstraintSystem createEmptyConstraintSystem() {
        return new ConeSimpleConstraintSystemImpl(InferenceComponentsKt.getInferenceComponents(this.session).createConstraintSystem(), this.session);
    }
}

