Clazz.declarePackage("J.adapter.readers.pymol");
Clazz.load(["java.util.Hashtable"], "J.adapter.readers.pymol.PyMOL", ["JU.Logger"], function(){
var c$ = Clazz.declareType(J.adapter.readers.pymol, "PyMOL", null);
c$.getRGB = Clazz.defineMethod(c$, "getRGB", 
function(color){
if (J.adapter.readers.pymol.PyMOL.moreColors != null) {
var key = Integer.$valueOf(color);
var c = J.adapter.readers.pymol.PyMOL.moreColors.get(key);
if (c != null) return c.intValue();
}if (color < J.adapter.readers.pymol.PyMOL.colors.length) return (J.adapter.readers.pymol.PyMOL.colors[color]);
return 0;
}, "~N");
c$.addColor = Clazz.defineMethod(c$, "addColor", 
function(id, value){
J.adapter.readers.pymol.PyMOL.moreColors.put(id, Integer.$valueOf(value));
}, "Integer,~N");
c$.getDefaultSetting = Clazz.defineMethod(c$, "getDefaultSetting", 
function(i, pymolVersion){
switch (i) {
case 173:
case 236:
case 570:
case 235:
case 526:
case 210:
case 376:
case 144:
case 574:
case 146:
case 378:
case 530:
case 531:
case 532:
case 156:
return -1;
case 327:
case 569:
case 155:
case 90:
case 448:
case 214:
case 194:
case 193:
case 84:
case 88:
case 111:
case 529:
case 19:
return 1;
case 172:
case 571:
case 666:
case 524:
case 279:
case 198:
case 138:
case 6:
case 180:
case 143:
case 338:
case 49:
case 64:
case 441:
case 118:
case 581:
case 749:
case 23:
case 20:
case 237:
case 203:
case 344:
return 0;
case 92:
return 0.2;
case 96:
return 1.4;
case 65:
return 0.25;
case 192:
return 0.45;
case 453:
return 14;
case 66:
return -6;
case 328:
return 5;
case 213:
case 382:
case 431:
return 2;
case 361:
case 380:
return 4;
case 377:
return 0.4;
case 379:
return 0.6;
case 381:
return 1.5;
case 103:
return 0.5;
case 4:
return 1.4;
case 107:
return 2.5;
case 44:
return 1.49;
case 106:
return 3;
case 152:
return 20;
case 550:
return 30;
case 21:
return 0.25;
case 100:
return 1.2;
case 101:
return 0.25;
default:
JU.Logger.error("PyMOL " + pymolVersion + " default float setting not found: " + i);
return 0;
}
}, "~N,~N");
c$.getDefaultSettingPt = Clazz.defineMethod(c$, "getDefaultSettingPt", 
function(i, pymolVersion, pt){
switch (i) {
case 471:
pt.set(0, 0, 0.75);
break;
default:
JU.Logger.error("PyMOL " + pymolVersion + " default point setting not found: " + i);
break;
}
return pt;
}, "~N,~N,JU.P3");
c$.getDefaultSettingS = Clazz.defineMethod(c$, "getDefaultSettingS", 
function(i, pymolVersion){
switch (i) {
case 342:
break;
default:
JU.Logger.info("PyMOL " + pymolVersion + " does not have String setting " + i);
break;
}
return "";
}, "~N,~N");
c$.getVArray = Clazz.defineMethod(c$, "getVArray", 
function(version){
var va = null;
var varray = null;
switch (version) {
case 176:
va = J.adapter.readers.pymol.PyMOL.v176;
break;
case 177:
va = J.adapter.readers.pymol.PyMOL.v177;
break;
case 181:
va = J.adapter.readers.pymol.PyMOL.v181;
break;
}
if (va != null) {
varray =  Clazz.newIntArray (60, 0);
for (var i = 0; i < va.length; ) varray[va[i++]] = va[i++];

}return varray;
}, "~N");
c$.getVArrayB = Clazz.defineMethod(c$, "getVArrayB", 
function(version){
var va = null;
var varray = null;
switch (version) {
case 176:
va = J.adapter.readers.pymol.PyMOL.v176b;
break;
case 177:
va = J.adapter.readers.pymol.PyMOL.v177b;
break;
case 181:
va = J.adapter.readers.pymol.PyMOL.v181b;
break;
}
if (va != null) {
varray =  Clazz.newIntArray (10, 0);
for (var i = 0; i < va.length; ) varray[va[i++]] = va[i++];

}return varray;
}, "~N");
c$.REP_LIST =  Clazz.newArray(-1, ["sticks", "spheres", "surface", "labels", "nb_spheres", "cartoon", "ribbon", "lines", "mesh", "dots", "dashes", "nonbonded", "cell", "cgo", "callback", "extent", "slice", "angles", "dihedrals", "ellipsoid", "volume"]);
c$.FLAG_exfoliate = 0x01000000;
c$.FLAG_ignore = 0x02000000;
c$.FLAG_no_smooth = 0x04000000;
c$.FLAG_polymer = 0x08000000;
c$.FLAG_solvent = 0x10000000;
c$.FLAG_organic = 0x20000000;
c$.FLAG_inorganic = 0x40000000;
c$.FLAG_NOSURFACE = J.adapter.readers.pymol.PyMOL.FLAG_ignore | J.adapter.readers.pymol.PyMOL.FLAG_exfoliate;
c$.colors =  Clazz.newIntArray(-1, [0xFFFFFFFF, 0xFF000000, 0xFF0000FF, 0xFF00FF00, 0xFFFF0000, 0xFF00FFFF, 0xFFFFFF00, 0xFFFFFF00, 0xFFFF00FF, 0xFFFF9999, 0xFF7FFF7F, 0xFF7F7FFF, 0xFFFF007F, 0xFFFF7F00, 0xFF7FFF00, 0xFF00FF7F, 0xFF7F00FF, 0xFF007FFF, 0xFFC4B200, 0xFFBF00BF, 0xFF00BFBF, 0xFF993333, 0xFF339933, 0xFF3F3FA5, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF33FF33, 0xFF3333FF, 0xFFFF4C4C, 0xFFE5E5E5, 0xFFFFB233, 0xFFE5C53F, 0xFFFF3333, 0xFF33FF33, 0xFF4C4CFF, 0xFFFFFF33, 0xFFFFDD5E, 0xFFFF8C26, 0xFF1919FF, 0xFF3319E5, 0xFF4C19CC, 0xFF6619B2, 0xFF7F1999, 0xFF99197F, 0xFFB21966, 0xFFCC194C, 0xFFE51933, 0xFFFF1919, 0xFFFFA5D8, 0xFFB12121, 0xFF8D381C, 0xFFA5512B, 0xFFFCD1A5, 0xFFFF7FFF, 0xFF000000, 0xFF020202, 0xFF050505, 0xFF070707, 0xFF0A0A0A, 0xFF0C0C0C, 0xFF0F0F0F, 0xFF121212, 0xFF141414, 0xFF171717, 0xFF191919, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF212121, 0xFF242424, 0xFF262626, 0xFF292929, 0xFF2B2B2B, 0xFF2E2E2E, 0xFF303030, 0xFF333333, 0xFF363636, 0xFF383838, 0xFF3B3B3B, 0xFF3D3D3D, 0xFF404040, 0xFF424242, 0xFF454545, 0xFF484848, 0xFF4A4A4A, 0xFF4D4D4D, 0xFF4F4F4F, 0xFF525252, 0xFF555555, 0xFF575757, 0xFF5A5A5A, 0xFF5C5C5C, 0xFF5F5F5F, 0xFF616161, 0xFF646464, 0xFF676767, 0xFF696969, 0xFF6C6C6C, 0xFF6E6E6E, 0xFF717171, 0xFF737373, 0xFF767676, 0xFF797979, 0xFF7B7B7B, 0xFF7E7E7E, 0xFF808080, 0xFF838383, 0xFF858585, 0xFF888888, 0xFF8B8B8B, 0xFF8D8D8D, 0xFF909090, 0xFF929292, 0xFF959595, 0xFF979797, 0xFF9A9A9A, 0xFF9D9D9D, 0xFF9F9F9F, 0xFFA2A2A2, 0xFFA4A4A4, 0xFFA7A7A7, 0xFFAAAAAA, 0xFFACACAC, 0xFFAFAFAF, 0xFFB1B1B1, 0xFFB4B4B4, 0xFFB6B6B6, 0xFFB9B9B9, 0xFFBCBCBC, 0xFFBEBEBE, 0xFFC1C1C1, 0xFFC3C3C3, 0xFFC6C6C6, 0xFFC8C8C8, 0xFFCBCBCB, 0xFFCECECE, 0xFFD0D0D0, 0xFFD3D3D3, 0xFFD5D5D5, 0xFFD8D8D8, 0xFFDADADA, 0xFFDDDDDD, 0xFFE0E0E0, 0xFFE2E2E2, 0xFFE5E5E5, 0xFFE7E7E7, 0xFFEAEAEA, 0xFFECECEC, 0xFFEFEFEF, 0xFFF2F2F2, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFF33CC, 0xFFFF00FF, 0xFFFD00FF, 0xFFFB00FF, 0xFFFA00FF, 0xFFF800FF, 0xFFF700FF, 0xFFF500FF, 0xFFF400FF, 0xFFF200FF, 0xFFF100FF, 0xFFEF00FF, 0xFFEE00FF, 0xFFEC00FF, 0xFFEB00FF, 0xFFE900FF, 0xFFE800FF, 0xFFE600FF, 0xFFE400FF, 0xFFE300FF, 0xFFE100FF, 0xFFE000FF, 0xFFDE00FF, 0xFFDD00FF, 0xFFDB00FF, 0xFFDA00FF, 0xFFD800FF, 0xFFD700FF, 0xFFD500FF, 0xFFD400FF, 0xFFD200FF, 0xFFD100FF, 0xFFCF00FF, 0xFFCE00FF, 0xFFCC00FF, 0xFFCA00FF, 0xFFC900FF, 0xFFC700FF, 0xFFC600FF, 0xFFC400FF, 0xFFC300FF, 0xFFC100FF, 0xFFC000FF, 0xFFBE00FF, 0xFFBD00FF, 0xFFBB00FF, 0xFFBA00FF, 0xFFB800FF, 0xFFB700FF, 0xFFB500FF, 0xFFB400FF, 0xFFB200FF, 0xFFB000FF, 0xFFAF00FF, 0xFFAD00FF, 0xFFAC00FF, 0xFFAA00FF, 0xFFA900FF, 0xFFA700FF, 0xFFA600FF, 0xFFA400FF, 0xFFA300FF, 0xFFA100FF, 0xFFA000FF, 0xFF9E00FF, 0xFF9D00FF, 0xFF9B00FF, 0xFF9A00FF, 0xFF9800FF, 0xFF9600FF, 0xFF9500FF, 0xFF9300FF, 0xFF9200FF, 0xFF9000FF, 0xFF8F00FF, 0xFF8D00FF, 0xFF8C00FF, 0xFF8A00FF, 0xFF8900FF, 0xFF8700FF, 0xFF8600FF, 0xFF8400FF, 0xFF8300FF, 0xFF8100FF, 0xFF8000FF, 0xFF7E00FF, 0xFF7C00FF, 0xFF7B00FF, 0xFF7900FF, 0xFF7800FF, 0xFF7600FF, 0xFF7500FF, 0xFF7300FF, 0xFF7200FF, 0xFF7000FF, 0xFF6F00FF, 0xFF6D00FF, 0xFF6C00FF, 0xFF6A00FF, 0xFF6900FF, 0xFF6700FF, 0xFF6600FF, 0xFF6400FF, 0xFF6200FF, 0xFF6100FF, 0xFF5F00FF, 0xFF5E00FF, 0xFF5C00FF, 0xFF5B00FF, 0xFF5900FF, 0xFF5800FF, 0xFF5600FF, 0xFF5500FF, 0xFF5300FF, 0xFF5200FF, 0xFF5000FF, 0xFF4F00FF, 0xFF4D00FF, 0xFF4B00FF, 0xFF4A00FF, 0xFF4800FF, 0xFF4700FF, 0xFF4500FF, 0xFF4400FF, 0xFF4200FF, 0xFF4100FF, 0xFF3F00FF, 0xFF3E00FF, 0xFF3C00FF, 0xFF3B00FF, 0xFF3900FF, 0xFF3800FF, 0xFF3600FF, 0xFF3500FF, 0xFF3300FF, 0xFF3100FF, 0xFF3000FF, 0xFF2E00FF, 0xFF2D00FF, 0xFF2B00FF, 0xFF2A00FF, 0xFF2800FF, 0xFF2700FF, 0xFF2500FF, 0xFF2400FF, 0xFF2200FF, 0xFF2100FF, 0xFF1F00FF, 0xFF1E00FF, 0xFF1C00FF, 0xFF1B00FF, 0xFF1900FF, 0xFF1700FF, 0xFF1600FF, 0xFF1400FF, 0xFF1300FF, 0xFF1100FF, 0xFF1000FF, 0xFF0E00FF, 0xFF0D00FF, 0xFF0B00FF, 0xFF0A00FF, 0xFF0800FF, 0xFF0700FF, 0xFF0500FF, 0xFF0400FF, 0xFF0200FF, 0xFF0100FF, 0xFF0000FF, 0xFF0002FF, 0xFF0003FF, 0xFF0005FF, 0xFF0006FF, 0xFF0008FF, 0xFF0009FF, 0xFF000BFF, 0xFF000CFF, 0xFF000EFF, 0xFF000FFF, 0xFF0011FF, 0xFF0012FF, 0xFF0014FF, 0xFF0015FF, 0xFF0017FF, 0xFF0018FF, 0xFF001AFF, 0xFF001CFF, 0xFF001DFF, 0xFF001FFF, 0xFF0020FF, 0xFF0022FF, 0xFF0023FF, 0xFF0025FF, 0xFF0026FF, 0xFF0028FF, 0xFF0029FF, 0xFF002BFF, 0xFF002CFF, 0xFF002EFF, 0xFF002FFF, 0xFF0031FF, 0xFF0032FF, 0xFF0034FF, 0xFF0036FF, 0xFF0037FF, 0xFF0039FF, 0xFF003AFF, 0xFF003CFF, 0xFF003DFF, 0xFF003FFF, 0xFF0040FF, 0xFF0042FF, 0xFF0043FF, 0xFF0045FF, 0xFF0046FF, 0xFF0048FF, 0xFF0049FF, 0xFF004BFF, 0xFF004DFF, 0xFF004EFF, 0xFF0050FF, 0xFF0051FF, 0xFF0053FF, 0xFF0054FF, 0xFF0056FF, 0xFF0057FF, 0xFF0059FF, 0xFF005AFF, 0xFF005CFF, 0xFF005DFF, 0xFF005FFF, 0xFF0060FF, 0xFF0062FF, 0xFF0063FF, 0xFF0065FF, 0xFF0067FF, 0xFF0068FF, 0xFF006AFF, 0xFF006BFF, 0xFF006DFF, 0xFF006EFF, 0xFF0070FF, 0xFF0071FF, 0xFF0073FF, 0xFF0074FF, 0xFF0076FF, 0xFF0077FF, 0xFF0079FF, 0xFF007AFF, 0xFF007CFF, 0xFF007DFF, 0xFF007FFF, 0xFF0081FF, 0xFF0082FF, 0xFF0084FF, 0xFF0085FF, 0xFF0087FF, 0xFF0088FF, 0xFF008AFF, 0xFF008BFF, 0xFF008DFF, 0xFF008EFF, 0xFF0090FF, 0xFF0091FF, 0xFF0093FF, 0xFF0094FF, 0xFF0096FF, 0xFF0097FF, 0xFF0099FF, 0xFF009BFF, 0xFF009CFF, 0xFF009EFF, 0xFF009FFF, 0xFF00A1FF, 0xFF00A2FF, 0xFF00A4FF, 0xFF00A5FF, 0xFF00A7FF, 0xFF00A8FF, 0xFF00AAFF, 0xFF00ABFF, 0xFF00ADFF, 0xFF00AEFF, 0xFF00B0FF, 0xFF00B1FF, 0xFF00B3FF, 0xFF00B5FF, 0xFF00B6FF, 0xFF00B8FF, 0xFF00B9FF, 0xFF00BBFF, 0xFF00BCFF, 0xFF00BEFF, 0xFF00BFFF, 0xFF00C1FF, 0xFF00C2FF, 0xFF00C4FF, 0xFF00C5FF, 0xFF00C7FF, 0xFF00C8FF, 0xFF00CAFF, 0xFF00CBFF, 0xFF00CDFF, 0xFF00CFFF, 0xFF00D0FF, 0xFF00D2FF, 0xFF00D3FF, 0xFF00D5FF, 0xFF00D6FF, 0xFF00D8FF, 0xFF00D9FF, 0xFF00DBFF, 0xFF00DCFF, 0xFF00DEFF, 0xFF00DFFF, 0xFF00E1FF, 0xFF00E2FF, 0xFF00E4FF, 0xFF00E6FF, 0xFF00E7FF, 0xFF00E9FF, 0xFF00EAFF, 0xFF00ECFF, 0xFF00EDFF, 0xFF00EFFF, 0xFF00F0FF, 0xFF00F2FF, 0xFF00F3FF, 0xFF00F5FF, 0xFF00F6FF, 0xFF00F8FF, 0xFF00F9FF, 0xFF00FBFF, 0xFF00FCFF, 0xFF00FEFF, 0xFF00FFFD, 0xFF00FFFC, 0xFF00FFFA, 0xFF00FFF9, 0xFF00FFF7, 0xFF00FFF6, 0xFF00FFF4, 0xFF00FFF3, 0xFF00FFF1, 0xFF00FFF0, 0xFF00FFEE, 0xFF00FFED, 0xFF00FFEB, 0xFF00FFEA, 0xFF00FFE8, 0xFF00FFE7, 0xFF00FFE5, 0xFF00FFE3, 0xFF00FFE2, 0xFF00FFE0, 0xFF00FFDF, 0xFF00FFDD, 0xFF00FFDC, 0xFF00FFDA, 0xFF00FFD9, 0xFF00FFD7, 0xFF00FFD6, 0xFF00FFD4, 0xFF00FFD3, 0xFF00FFD1, 0xFF00FFD0, 0xFF00FFCE, 0xFF00FFCD, 0xFF00FFCB, 0xFF00FFC9, 0xFF00FFC8, 0xFF00FFC6, 0xFF00FFC5, 0xFF00FFC3, 0xFF00FFC2, 0xFF00FFC0, 0xFF00FFBF, 0xFF00FFBD, 0xFF00FFBC, 0xFF00FFBA, 0xFF00FFB9, 0xFF00FFB7, 0xFF00FFB6, 0xFF00FFB4, 0xFF00FFB3, 0xFF00FFB1, 0xFF00FFAF, 0xFF00FFAE, 0xFF00FFAC, 0xFF00FFAB, 0xFF00FFA9, 0xFF00FFA8, 0xFF00FFA6, 0xFF00FFA5, 0xFF00FFA3, 0xFF00FFA2, 0xFF00FFA0, 0xFF00FF9F, 0xFF00FF9D, 0xFF00FF9C, 0xFF00FF9A, 0xFF00FF99, 0xFF00FF97, 0xFF00FF95, 0xFF00FF94, 0xFF00FF92, 0xFF00FF91, 0xFF00FF8F, 0xFF00FF8E, 0xFF00FF8C, 0xFF00FF8B, 0xFF00FF89, 0xFF00FF88, 0xFF00FF86, 0xFF00FF85, 0xFF00FF83, 0xFF00FF82, 0xFF00FF80, 0xFF00FF7E, 0xFF00FF7D, 0xFF00FF7B, 0xFF00FF7A, 0xFF00FF78, 0xFF00FF77, 0xFF00FF75, 0xFF00FF74, 0xFF00FF72, 0xFF00FF71, 0xFF00FF6F, 0xFF00FF6E, 0xFF00FF6C, 0xFF00FF6B, 0xFF00FF69, 0xFF00FF68, 0xFF00FF66, 0xFF00FF64, 0xFF00FF63, 0xFF00FF61, 0xFF00FF60, 0xFF00FF5E, 0xFF00FF5D, 0xFF00FF5B, 0xFF00FF5A, 0xFF00FF58, 0xFF00FF57, 0xFF00FF55, 0xFF00FF54, 0xFF00FF52, 0xFF00FF51, 0xFF00FF4F, 0xFF00FF4E, 0xFF00FF4C, 0xFF00FF4A, 0xFF00FF49, 0xFF00FF47, 0xFF00FF46, 0xFF00FF44, 0xFF00FF43, 0xFF00FF41, 0xFF00FF40, 0xFF00FF3E, 0xFF00FF3D, 0xFF00FF3B, 0xFF00FF3A, 0xFF00FF38, 0xFF00FF37, 0xFF00FF35, 0xFF00FF34, 0xFF00FF32, 0xFF00FF30, 0xFF00FF2F, 0xFF00FF2D, 0xFF00FF2C, 0xFF00FF2A, 0xFF00FF29, 0xFF00FF27, 0xFF00FF26, 0xFF00FF24, 0xFF00FF23, 0xFF00FF21, 0xFF00FF20, 0xFF00FF1E, 0xFF00FF1D, 0xFF00FF1B, 0xFF00FF1A, 0xFF00FF18, 0xFF00FF16, 0xFF00FF15, 0xFF00FF13, 0xFF00FF12, 0xFF00FF10, 0xFF00FF0F, 0xFF00FF0D, 0xFF00FF0C, 0xFF00FF0A, 0xFF00FF09, 0xFF00FF07, 0xFF00FF06, 0xFF00FF04, 0xFF00FF03, 0xFF00FF01, 0xFF00FF00, 0xFF01FF00, 0xFF03FF00, 0xFF04FF00, 0xFF06FF00, 0xFF07FF00, 0xFF09FF00, 0xFF0AFF00, 0xFF0CFF00, 0xFF0DFF00, 0xFF0FFF00, 0xFF10FF00, 0xFF12FF00, 0xFF13FF00, 0xFF15FF00, 0xFF16FF00, 0xFF18FF00, 0xFF1AFF00, 0xFF1BFF00, 0xFF1DFF00, 0xFF1EFF00, 0xFF20FF00, 0xFF21FF00, 0xFF23FF00, 0xFF24FF00, 0xFF26FF00, 0xFF27FF00, 0xFF29FF00, 0xFF2AFF00, 0xFF2CFF00, 0xFF2DFF00, 0xFF2FFF00, 0xFF30FF00, 0xFF32FF00, 0xFF34FF00, 0xFF35FF00, 0xFF37FF00, 0xFF38FF00, 0xFF3AFF00, 0xFF3BFF00, 0xFF3DFF00, 0xFF3EFF00, 0xFF40FF00, 0xFF41FF00, 0xFF43FF00, 0xFF44FF00, 0xFF46FF00, 0xFF47FF00, 0xFF49FF00, 0xFF4AFF00, 0xFF4CFF00, 0xFF4EFF00, 0xFF4FFF00, 0xFF51FF00, 0xFF52FF00, 0xFF54FF00, 0xFF55FF00, 0xFF57FF00, 0xFF58FF00, 0xFF5AFF00, 0xFF5BFF00, 0xFF5DFF00, 0xFF5EFF00, 0xFF60FF00, 0xFF61FF00, 0xFF63FF00, 0xFF64FF00, 0xFF66FF00, 0xFF68FF00, 0xFF69FF00, 0xFF6BFF00, 0xFF6CFF00, 0xFF6EFF00, 0xFF6FFF00, 0xFF71FF00, 0xFF72FF00, 0xFF74FF00, 0xFF75FF00, 0xFF77FF00, 0xFF78FF00, 0xFF7AFF00, 0xFF7BFF00, 0xFF7DFF00, 0xFF7EFF00, 0xFF80FF00, 0xFF82FF00, 0xFF83FF00, 0xFF85FF00, 0xFF86FF00, 0xFF88FF00, 0xFF89FF00, 0xFF8BFF00, 0xFF8CFF00, 0xFF8EFF00, 0xFF8FFF00, 0xFF91FF00, 0xFF92FF00, 0xFF94FF00, 0xFF95FF00, 0xFF97FF00, 0xFF98FF00, 0xFF9AFF00, 0xFF9CFF00, 0xFF9DFF00, 0xFF9FFF00, 0xFFA0FF00, 0xFFA2FF00, 0xFFA3FF00, 0xFFA5FF00, 0xFFA6FF00, 0xFFA8FF00, 0xFFA9FF00, 0xFFABFF00, 0xFFACFF00, 0xFFAEFF00, 0xFFAFFF00, 0xFFB1FF00, 0xFFB3FF00, 0xFFB4FF00, 0xFFB6FF00, 0xFFB7FF00, 0xFFB9FF00, 0xFFBAFF00, 0xFFBCFF00, 0xFFBDFF00, 0xFFBFFF00, 0xFFC0FF00, 0xFFC2FF00, 0xFFC3FF00, 0xFFC5FF00, 0xFFC6FF00, 0xFFC8FF00, 0xFFC9FF00, 0xFFCBFF00, 0xFFCDFF00, 0xFFCEFF00, 0xFFD0FF00, 0xFFD1FF00, 0xFFD3FF00, 0xFFD4FF00, 0xFFD6FF00, 0xFFD7FF00, 0xFFD9FF00, 0xFFDAFF00, 0xFFDCFF00, 0xFFDDFF00, 0xFFDFFF00, 0xFFE0FF00, 0xFFE2FF00, 0xFFE3FF00, 0xFFE5FF00, 0xFFE7FF00, 0xFFE8FF00, 0xFFEAFF00, 0xFFEBFF00, 0xFFEDFF00, 0xFFEEFF00, 0xFFF0FF00, 0xFFF1FF00, 0xFFF3FF00, 0xFFF4FF00, 0xFFF6FF00, 0xFFF7FF00, 0xFFF9FF00, 0xFFFAFF00, 0xFFFCFF00, 0xFFFDFF00, 0xFFFFFE00, 0xFFFFFC00, 0xFFFFFB00, 0xFFFFF900, 0xFFFFF800, 0xFFFFF600, 0xFFFFF500, 0xFFFFF300, 0xFFFFF200, 0xFFFFF000, 0xFFFFEF00, 0xFFFFED00, 0xFFFFEC00, 0xFFFFEA00, 0xFFFFE900, 0xFFFFE700, 0xFFFFE600, 0xFFFFE400, 0xFFFFE200, 0xFFFFE100, 0xFFFFDF00, 0xFFFFDE00, 0xFFFFDC00, 0xFFFFDB00, 0xFFFFD900, 0xFFFFD800, 0xFFFFD600, 0xFFFFD500, 0xFFFFD300, 0xFFFFD200, 0xFFFFD000, 0xFFFFCF00, 0xFFFFCD00, 0xFFFFCC00, 0xFFFFCA00, 0xFFFFC800, 0xFFFFC700, 0xFFFFC500, 0xFFFFC400, 0xFFFFC200, 0xFFFFC100, 0xFFFFBF00, 0xFFFFBE00, 0xFFFFBC00, 0xFFFFBB00, 0xFFFFB900, 0xFFFFB800, 0xFFFFB600, 0xFFFFB500, 0xFFFFB300, 0xFFFFB100, 0xFFFFB000, 0xFFFFAE00, 0xFFFFAD00, 0xFFFFAB00, 0xFFFFAA00, 0xFFFFA800, 0xFFFFA700, 0xFFFFA500, 0xFFFFA400, 0xFFFFA200, 0xFFFFA100, 0xFFFF9F00, 0xFFFF9E00, 0xFFFF9C00, 0xFFFF9B00, 0xFFFF9900, 0xFFFF9700, 0xFFFF9600, 0xFFFF9400, 0xFFFF9300, 0xFFFF9100, 0xFFFF9000, 0xFFFF8E00, 0xFFFF8D00, 0xFFFF8B00, 0xFFFF8A00, 0xFFFF8800, 0xFFFF8700, 0xFFFF8500, 0xFFFF8400, 0xFFFF8200, 0xFFFF8100, 0xFFFF7F00, 0xFFFF7D00, 0xFFFF7C00, 0xFFFF7A00, 0xFFFF7900, 0xFFFF7700, 0xFFFF7600, 0xFFFF7400, 0xFFFF7300, 0xFFFF7100, 0xFFFF7000, 0xFFFF6E00, 0xFFFF6D00, 0xFFFF6B00, 0xFFFF6A00, 0xFFFF6800, 0xFFFF6700, 0xFFFF6500, 0xFFFF6300, 0xFFFF6200, 0xFFFF6000, 0xFFFF5F00, 0xFFFF5D00, 0xFFFF5C00, 0xFFFF5A00, 0xFFFF5900, 0xFFFF5700, 0xFFFF5600, 0xFFFF5400, 0xFFFF5300, 0xFFFF5100, 0xFFFF5000, 0xFFFF4E00, 0xFFFF4D00, 0xFFFF4B00, 0xFFFF4900, 0xFFFF4800, 0xFFFF4600, 0xFFFF4500, 0xFFFF4300, 0xFFFF4200, 0xFFFF4000, 0xFFFF3F00, 0xFFFF3D00, 0xFFFF3C00, 0xFFFF3A00, 0xFFFF3900, 0xFFFF3700, 0xFFFF3600, 0xFFFF3400, 0xFFFF3300, 0xFFFF3100, 0xFFFF2F00, 0xFFFF2E00, 0xFFFF2C00, 0xFFFF2B00, 0xFFFF2900, 0xFFFF2800, 0xFFFF2600, 0xFFFF2500, 0xFFFF2300, 0xFFFF2200, 0xFFFF2000, 0xFFFF1F00, 0xFFFF1D00, 0xFFFF1C00, 0xFFFF1A00, 0xFFFF1800, 0xFFFF1700, 0xFFFF1500, 0xFFFF1400, 0xFFFF1200, 0xFFFF1100, 0xFFFF0F00, 0xFFFF0E00, 0xFFFF0C00, 0xFFFF0B00, 0xFFFF0900, 0xFFFF0800, 0xFFFF0600, 0xFFFF0500, 0xFFFF0300, 0xFFFF0200, 0xFFFF0000, 0xFFFF0001, 0xFFFF0002, 0xFFFF0004, 0xFFFF0005, 0xFFFF0007, 0xFFFF0008, 0xFFFF000A, 0xFFFF000B, 0xFFFF000D, 0xFFFF000E, 0xFFFF0010, 0xFFFF0011, 0xFFFF0013, 0xFFFF0014, 0xFFFF0016, 0xFFFF0017, 0xFFFF0019, 0xFFFF001B, 0xFFFF001C, 0xFFFF001E, 0xFFFF001F, 0xFFFF0021, 0xFFFF0022, 0xFFFF0024, 0xFFFF0025, 0xFFFF0027, 0xFFFF0028, 0xFFFF002A, 0xFFFF002B, 0xFFFF002D, 0xFFFF002E, 0xFFFF0030, 0xFFFF0031, 0xFFFF0033, 0xFFFF0035, 0xFFFF0036, 0xFFFF0038, 0xFFFF0039, 0xFFFF003B, 0xFFFF003C, 0xFFFF003E, 0xFFFF003F, 0xFFFF0041, 0xFFFF0042, 0xFFFF0044, 0xFFFF0045, 0xFFFF0047, 0xFFFF0048, 0xFFFF004A, 0xFFFF004B, 0xFFFF004D, 0xFFFF004F, 0xFFFF0050, 0xFFFF0052, 0xFFFF0053, 0xFFFF0055, 0xFFFF0056, 0xFFFF0058, 0xFFFF0059, 0xFFFF005B, 0xFFFF005C, 0xFFFF005E, 0xFFFF005F, 0xFFFF0061, 0xFFFF0062, 0xFFFF0064, 0xFFFF0065, 0xFFFF0067, 0xFFFF0069, 0xFFFF006A, 0xFFFF006C, 0xFFFF006D, 0xFFFF006F, 0xFFFF0070, 0xFFFF0072, 0xFFFF0073, 0xFFFF0075, 0xFFFF0076, 0xFFFF0078, 0xFFFF0079, 0xFFFF007B, 0xFFFF007C, 0xFFFF007E, 0xFFFF0080, 0xFFFF0081, 0xFFFF0083, 0xFFFF0084, 0xFFFF0086, 0xFFFF0087, 0xFFFF0089, 0xFFFF008A, 0xFFFF008C, 0xFFFF008D, 0xFFFF008F, 0xFFFF0090, 0xFFFF0092, 0xFFFF0093, 0xFFFF0095, 0xFFFF0096, 0xFFFF0098, 0xFFFF009A, 0xFFFF009B, 0xFFFF009D, 0xFFFF009E, 0xFFFF00A0, 0xFFFF00A1, 0xFFFF00A3, 0xFFFF00A4, 0xFFFF00A6, 0xFFFF00A7, 0xFFFF00A9, 0xFFFF00AA, 0xFFFF00AC, 0xFFFF00AD, 0xFFFF00AF, 0xFFFF00B0, 0xFFFF00B2, 0xFFFF00B4, 0xFFFF00B5, 0xFFFF00B7, 0xFFFF00B8, 0xFFFF00BA, 0xFFFF00BB, 0xFFFF00BD, 0xFFFF00BE, 0xFFFF00C0, 0xFFFF00C1, 0xFFFF00C3, 0xFFFF00C4, 0xFFFF00C6, 0xFFFF00C7, 0xFFFF00C9, 0xFFFF00CA, 0xFFFF00CC, 0xFFFF00CE, 0xFFFF00CF, 0xFFFF00D1, 0xFFFF00D2, 0xFFFF00D4, 0xFFFF00D5, 0xFFFF00D7, 0xFFFF00D8, 0xFFFF00DA, 0xFFFF00DB, 0xFFFF00DD, 0xFFFF00DE, 0xFFFF00E0, 0xFFFF00E1, 0xFFFF00E3, 0xFFFF00E4, 0xFFFF00E6, 0xFFFF00E8, 0xFFFF00E9, 0xFFFF00EB, 0xFFFF00EC, 0xFFFF00EE, 0xFFFF00EF, 0xFFFF00F1, 0xFFFF00F2, 0xFFFF00F4, 0xFFFF00F5, 0xFFFF00F7, 0xFFFF00F8, 0xFFFF00FA, 0xFFFF00FB, 0xFFFF00FD, 0xFFFFFF00, 0xFFFDFF00, 0xFFFBFF00, 0xFFFAFF00, 0xFFF8FF00, 0xFFF7FF00, 0xFFF5FF00, 0xFFF4FF00, 0xFFF2FF00, 0xFFF1FF00, 0xFFEFFF00, 0xFFEEFF00, 0xFFECFF00, 0xFFEBFF00, 0xFFE9FF00, 0xFFE8FF00, 0xFFE6FF00, 0xFFE4FF00, 0xFFE3FF00, 0xFFE1FF00, 0xFFE0FF00, 0xFFDEFF00, 0xFFDDFF00, 0xFFDBFF00, 0xFFDAFF00, 0xFFD8FF00, 0xFFD7FF00, 0xFFD5FF00, 0xFFD4FF00, 0xFFD2FF00, 0xFFD1FF00, 0xFFCFFF00, 0xFFCEFF00, 0xFFCCFF00, 0xFFCAFF00, 0xFFC9FF00, 0xFFC7FF00, 0xFFC6FF00, 0xFFC4FF00, 0xFFC3FF00, 0xFFC1FF00, 0xFFC0FF00, 0xFFBEFF00, 0xFFBDFF00, 0xFFBBFF00, 0xFFBAFF00, 0xFFB8FF00, 0xFFB7FF00, 0xFFB5FF00, 0xFFB4FF00, 0xFFB2FF00, 0xFFB0FF00, 0xFFAFFF00, 0xFFADFF00, 0xFFACFF00, 0xFFAAFF00, 0xFFA9FF00, 0xFFA7FF00, 0xFFA6FF00, 0xFFA4FF00, 0xFFA3FF00, 0xFFA1FF00, 0xFFA0FF00, 0xFF9EFF00, 0xFF9DFF00, 0xFF9BFF00, 0xFF9AFF00, 0xFF98FF00, 0xFF96FF00, 0xFF95FF00, 0xFF93FF00, 0xFF92FF00, 0xFF90FF00, 0xFF8FFF00, 0xFF8DFF00, 0xFF8CFF00, 0xFF8AFF00, 0xFF89FF00, 0xFF87FF00, 0xFF86FF00, 0xFF84FF00, 0xFF83FF00, 0xFF81FF00, 0xFF80FF00, 0xFF7EFF00, 0xFF7CFF00, 0xFF7BFF00, 0xFF79FF00, 0xFF78FF00, 0xFF76FF00, 0xFF75FF00, 0xFF73FF00, 0xFF72FF00, 0xFF70FF00, 0xFF6FFF00, 0xFF6DFF00, 0xFF6CFF00, 0xFF6AFF00, 0xFF69FF00, 0xFF67FF00, 0xFF66FF00, 0xFF64FF00, 0xFF62FF00, 0xFF61FF00, 0xFF5FFF00, 0xFF5EFF00, 0xFF5CFF00, 0xFF5BFF00, 0xFF59FF00, 0xFF58FF00, 0xFF56FF00, 0xFF55FF00, 0xFF53FF00, 0xFF52FF00, 0xFF50FF00, 0xFF4FFF00, 0xFF4DFF00, 0xFF4BFF00, 0xFF4AFF00, 0xFF48FF00, 0xFF47FF00, 0xFF45FF00, 0xFF44FF00, 0xFF42FF00, 0xFF41FF00, 0xFF3FFF00, 0xFF3EFF00, 0xFF3CFF00, 0xFF3BFF00, 0xFF39FF00, 0xFF38FF00, 0xFF36FF00, 0xFF35FF00, 0xFF33FF00, 0xFF31FF00, 0xFF30FF00, 0xFF2EFF00, 0xFF2DFF00, 0xFF2BFF00, 0xFF2AFF00, 0xFF28FF00, 0xFF27FF00, 0xFF25FF00, 0xFF24FF00, 0xFF22FF00, 0xFF21FF00, 0xFF1FFF00, 0xFF1EFF00, 0xFF1CFF00, 0xFF1BFF00, 0xFF19FF00, 0xFF17FF00, 0xFF16FF00, 0xFF14FF00, 0xFF13FF00, 0xFF11FF00, 0xFF10FF00, 0xFF0EFF00, 0xFF0DFF00, 0xFF0BFF00, 0xFF0AFF00, 0xFF08FF00, 0xFF07FF00, 0xFF05FF00, 0xFF04FF00, 0xFF02FF00, 0xFF01FF00, 0xFF00FF00, 0xFF00FF02, 0xFF00FF03, 0xFF00FF05, 0xFF00FF06, 0xFF00FF08, 0xFF00FF09, 0xFF00FF0B, 0xFF00FF0C, 0xFF00FF0E, 0xFF00FF0F, 0xFF00FF11, 0xFF00FF12, 0xFF00FF14, 0xFF00FF15, 0xFF00FF17, 0xFF00FF18, 0xFF00FF1A, 0xFF00FF1C, 0xFF00FF1D, 0xFF00FF1F, 0xFF00FF20, 0xFF00FF22, 0xFF00FF23, 0xFF00FF25, 0xFF00FF26, 0xFF00FF28, 0xFF00FF29, 0xFF00FF2B, 0xFF00FF2C, 0xFF00FF2E, 0xFF00FF2F, 0xFF00FF31, 0xFF00FF32, 0xFF00FF34, 0xFF00FF36, 0xFF00FF37, 0xFF00FF39, 0xFF00FF3A, 0xFF00FF3C, 0xFF00FF3D, 0xFF00FF3F, 0xFF00FF40, 0xFF00FF42, 0xFF00FF43, 0xFF00FF45, 0xFF00FF46, 0xFF00FF48, 0xFF00FF49, 0xFF00FF4B, 0xFF00FF4D, 0xFF00FF4E, 0xFF00FF50, 0xFF00FF51, 0xFF00FF53, 0xFF00FF54, 0xFF00FF56, 0xFF00FF57, 0xFF00FF59, 0xFF00FF5A, 0xFF00FF5C, 0xFF00FF5D, 0xFF00FF5F, 0xFF00FF60, 0xFF00FF62, 0xFF00FF63, 0xFF00FF65, 0xFF00FF67, 0xFF00FF68, 0xFF00FF6A, 0xFF00FF6B, 0xFF00FF6D, 0xFF00FF6E, 0xFF00FF70, 0xFF00FF71, 0xFF00FF73, 0xFF00FF74, 0xFF00FF76, 0xFF00FF77, 0xFF00FF79, 0xFF00FF7A, 0xFF00FF7C, 0xFF00FF7D, 0xFF00FF7F, 0xFF00FF81, 0xFF00FF82, 0xFF00FF84, 0xFF00FF85, 0xFF00FF87, 0xFF00FF88, 0xFF00FF8A, 0xFF00FF8B, 0xFF00FF8D, 0xFF00FF8E, 0xFF00FF90, 0xFF00FF91, 0xFF00FF93, 0xFF00FF94, 0xFF00FF96, 0xFF00FF97, 0xFF00FF99, 0xFF00FF9B, 0xFF00FF9C, 0xFF00FF9E, 0xFF00FF9F, 0xFF00FFA1, 0xFF00FFA2, 0xFF00FFA4, 0xFF00FFA5, 0xFF00FFA7, 0xFF00FFA8, 0xFF00FFAA, 0xFF00FFAB, 0xFF00FFAD, 0xFF00FFAE, 0xFF00FFB0, 0xFF00FFB1, 0xFF00FFB3, 0xFF00FFB5, 0xFF00FFB6, 0xFF00FFB8, 0xFF00FFB9, 0xFF00FFBB, 0xFF00FFBC, 0xFF00FFBE, 0xFF00FFBF, 0xFF00FFC1, 0xFF00FFC2, 0xFF00FFC4, 0xFF00FFC5, 0xFF00FFC7, 0xFF00FFC8, 0xFF00FFCA, 0xFF00FFCB, 0xFF00FFCD, 0xFF00FFCF, 0xFF00FFD0, 0xFF00FFD2, 0xFF00FFD3, 0xFF00FFD5, 0xFF00FFD6, 0xFF00FFD8, 0xFF00FFD9, 0xFF00FFDB, 0xFF00FFDC, 0xFF00FFDE, 0xFF00FFDF, 0xFF00FFE1, 0xFF00FFE2, 0xFF00FFE4, 0xFF00FFE6, 0xFF00FFE7, 0xFF00FFE9, 0xFF00FFEA, 0xFF00FFEC, 0xFF00FFED, 0xFF00FFEF, 0xFF00FFF0, 0xFF00FFF2, 0xFF00FFF3, 0xFF00FFF5, 0xFF00FFF6, 0xFF00FFF8, 0xFF00FFF9, 0xFF00FFFB, 0xFF00FFFC, 0xFF00FFFE, 0xFF00FDFF, 0xFF00FCFF, 0xFF00FAFF, 0xFF00F9FF, 0xFF00F7FF, 0xFF00F6FF, 0xFF00F4FF, 0xFF00F3FF, 0xFF00F1FF, 0xFF00F0FF, 0xFF00EEFF, 0xFF00EDFF, 0xFF00EBFF, 0xFF00EAFF, 0xFF00E8FF, 0xFF00E7FF, 0xFF00E5FF, 0xFF00E3FF, 0xFF00E2FF, 0xFF00E0FF, 0xFF00DFFF, 0xFF00DDFF, 0xFF00DCFF, 0xFF00DAFF, 0xFF00D9FF, 0xFF00D7FF, 0xFF00D6FF, 0xFF00D4FF, 0xFF00D3FF, 0xFF00D1FF, 0xFF00D0FF, 0xFF00CEFF, 0xFF00CDFF, 0xFF00CBFF, 0xFF00C9FF, 0xFF00C8FF, 0xFF00C6FF, 0xFF00C5FF, 0xFF00C3FF, 0xFF00C2FF, 0xFF00C0FF, 0xFF00BFFF, 0xFF00BDFF, 0xFF00BCFF, 0xFF00BAFF, 0xFF00B9FF, 0xFF00B7FF, 0xFF00B6FF, 0xFF00B4FF, 0xFF00B3FF, 0xFF00B1FF, 0xFF00AFFF, 0xFF00AEFF, 0xFF00ACFF, 0xFF00ABFF, 0xFF00A9FF, 0xFF00A8FF, 0xFF00A6FF, 0xFF00A5FF, 0xFF00A3FF, 0xFF00A2FF, 0xFF00A0FF, 0xFF009FFF, 0xFF009DFF, 0xFF009CFF, 0xFF009AFF, 0xFF0099FF, 0xFF0097FF, 0xFF0095FF, 0xFF0094FF, 0xFF0092FF, 0xFF0091FF, 0xFF008FFF, 0xFF008EFF, 0xFF008CFF, 0xFF008BFF, 0xFF0089FF, 0xFF0088FF, 0xFF0086FF, 0xFF0085FF, 0xFF0083FF, 0xFF0082FF, 0xFF0080FF, 0xFF007EFF, 0xFF007DFF, 0xFF007BFF, 0xFF007AFF, 0xFF0078FF, 0xFF0077FF, 0xFF0075FF, 0xFF0074FF, 0xFF0072FF, 0xFF0071FF, 0xFF006FFF, 0xFF006EFF, 0xFF006CFF, 0xFF006BFF, 0xFF0069FF, 0xFF0068FF, 0xFF0066FF, 0xFF0064FF, 0xFF0063FF, 0xFF0061FF, 0xFF0060FF, 0xFF005EFF, 0xFF005DFF, 0xFF005BFF, 0xFF005AFF, 0xFF0058FF, 0xFF0057FF, 0xFF0055FF, 0xFF0054FF, 0xFF0052FF, 0xFF0051FF, 0xFF004FFF, 0xFF004EFF, 0xFF004CFF, 0xFF004AFF, 0xFF0049FF, 0xFF0047FF, 0xFF0046FF, 0xFF0044FF, 0xFF0043FF, 0xFF0041FF, 0xFF0040FF, 0xFF003EFF, 0xFF003DFF, 0xFF003BFF, 0xFF003AFF, 0xFF0038FF, 0xFF0037FF, 0xFF0035FF, 0xFF0034FF, 0xFF0032FF, 0xFF0030FF, 0xFF002FFF, 0xFF002DFF, 0xFF002CFF, 0xFF002AFF, 0xFF0029FF, 0xFF0027FF, 0xFF0026FF, 0xFF0024FF, 0xFF0023FF, 0xFF0021FF, 0xFF0020FF, 0xFF001EFF, 0xFF001DFF, 0xFF001BFF, 0xFF001AFF, 0xFF0018FF, 0xFF0016FF, 0xFF0015FF, 0xFF0013FF, 0xFF0012FF, 0xFF0010FF, 0xFF000FFF, 0xFF000DFF, 0xFF000CFF, 0xFF000AFF, 0xFF0009FF, 0xFF0007FF, 0xFF0006FF, 0xFF0004FF, 0xFF0003FF, 0xFF0001FF, 0xFF0000FF, 0xFF0100FF, 0xFF0300FF, 0xFF0400FF, 0xFF0600FF, 0xFF0700FF, 0xFF0900FF, 0xFF0A00FF, 0xFF0C00FF, 0xFF0D00FF, 0xFF0F00FF, 0xFF1000FF, 0xFF1200FF, 0xFF1300FF, 0xFF1500FF, 0xFF1600FF, 0xFF1800FF, 0xFF1A00FF, 0xFF1B00FF, 0xFF1D00FF, 0xFF1E00FF, 0xFF2000FF, 0xFF2100FF, 0xFF2300FF, 0xFF2400FF, 0xFF2600FF, 0xFF2700FF, 0xFF2900FF, 0xFF2A00FF, 0xFF2C00FF, 0xFF2D00FF, 0xFF2F00FF, 0xFF3000FF, 0xFF3200FF, 0xFF3400FF, 0xFF3500FF, 0xFF3700FF, 0xFF3800FF, 0xFF3A00FF, 0xFF3B00FF, 0xFF3D00FF, 0xFF3E00FF, 0xFF4000FF, 0xFF4100FF, 0xFF4300FF, 0xFF4400FF, 0xFF4600FF, 0xFF4700FF, 0xFF4900FF, 0xFF4A00FF, 0xFF4C00FF, 0xFF4E00FF, 0xFF4F00FF, 0xFF5100FF, 0xFF5200FF, 0xFF5400FF, 0xFF5500FF, 0xFF5700FF, 0xFF5800FF, 0xFF5A00FF, 0xFF5B00FF, 0xFF5D00FF, 0xFF5E00FF, 0xFF6000FF, 0xFF6100FF, 0xFF6300FF, 0xFF6400FF, 0xFF6600FF, 0xFF6800FF, 0xFF6900FF, 0xFF6B00FF, 0xFF6C00FF, 0xFF6E00FF, 0xFF6F00FF, 0xFF7100FF, 0xFF7200FF, 0xFF7400FF, 0xFF7500FF, 0xFF7700FF, 0xFF7800FF, 0xFF7A00FF, 0xFF7B00FF, 0xFF7D00FF, 0xFF7E00FF, 0xFF8000FF, 0xFF8200FF, 0xFF8300FF, 0xFF8500FF, 0xFF8600FF, 0xFF8800FF, 0xFF8900FF, 0xFF8B00FF, 0xFF8C00FF, 0xFF8E00FF, 0xFF8F00FF, 0xFF9100FF, 0xFF9200FF, 0xFF9400FF, 0xFF9500FF, 0xFF9700FF, 0xFF9800FF, 0xFF9A00FF, 0xFF9C00FF, 0xFF9D00FF, 0xFF9F00FF, 0xFFA000FF, 0xFFA200FF, 0xFFA300FF, 0xFFA500FF, 0xFFA600FF, 0xFFA800FF, 0xFFA900FF, 0xFFAB00FF, 0xFFAC00FF, 0xFFAE00FF, 0xFFAF00FF, 0xFFB100FF, 0xFFB300FF, 0xFFB400FF, 0xFFB600FF, 0xFFB700FF, 0xFFB900FF, 0xFFBA00FF, 0xFFBC00FF, 0xFFBD00FF, 0xFFBF00FF, 0xFFC000FF, 0xFFC200FF, 0xFFC300FF, 0xFFC500FF, 0xFFC600FF, 0xFFC800FF, 0xFFC900FF, 0xFFCB00FF, 0xFFCD00FF, 0xFFCE00FF, 0xFFD000FF, 0xFFD100FF, 0xFFD300FF, 0xFFD400FF, 0xFFD600FF, 0xFFD700FF, 0xFFD900FF, 0xFFDA00FF, 0xFFDC00FF, 0xFFDD00FF, 0xFFDF00FF, 0xFFE000FF, 0xFFE200FF, 0xFFE300FF, 0xFFE500FF, 0xFFE700FF, 0xFFE800FF, 0xFFEA00FF, 0xFFEB00FF, 0xFFED00FF, 0xFFEE00FF, 0xFFF000FF, 0xFFF100FF, 0xFFF300FF, 0xFFF400FF, 0xFFF600FF, 0xFFF700FF, 0xFFF900FF, 0xFFFA00FF, 0xFFFC00FF, 0xFFFD00FF, 0xFFFF00FE, 0xFFFF00FC, 0xFFFF00FB, 0xFFFF00F9, 0xFFFF00F8, 0xFFFF00F6, 0xFFFF00F5, 0xFFFF00F3, 0xFFFF00F2, 0xFFFF00F0, 0xFFFF00EF, 0xFFFF00ED, 0xFFFF00EC, 0xFFFF00EA, 0xFFFF00E9, 0xFFFF00E7, 0xFFFF00E6, 0xFFFF00E4, 0xFFFF00E2, 0xFFFF00E1, 0xFFFF00DF, 0xFFFF00DE, 0xFFFF00DC, 0xFFFF00DB, 0xFFFF00D9, 0xFFFF00D8, 0xFFFF00D6, 0xFFFF00D5, 0xFFFF00D3, 0xFFFF00D2, 0xFFFF00D0, 0xFFFF00CF, 0xFFFF00CD, 0xFFFF00CC, 0xFFFF00CA, 0xFFFF00C8, 0xFFFF00C7, 0xFFFF00C5, 0xFFFF00C4, 0xFFFF00C2, 0xFFFF00C1, 0xFFFF00BF, 0xFFFF00BE, 0xFFFF00BC, 0xFFFF00BB, 0xFFFF00B9, 0xFFFF00B8, 0xFFFF00B6, 0xFFFF00B5, 0xFFFF00B3, 0xFFFF00B1, 0xFFFF00B0, 0xFFFF00AE, 0xFFFF00AD, 0xFFFF00AB, 0xFFFF00AA, 0xFFFF00A8, 0xFFFF00A7, 0xFFFF00A5, 0xFFFF00A4, 0xFFFF00A2, 0xFFFF00A1, 0xFFFF009F, 0xFFFF009E, 0xFFFF009C, 0xFFFF009B, 0xFFFF0099, 0xFFFF0097, 0xFFFF0096, 0xFFFF0094, 0xFFFF0093, 0xFFFF0091, 0xFFFF0090, 0xFFFF008E, 0xFFFF008D, 0xFFFF008B, 0xFFFF008A, 0xFFFF0088, 0xFFFF0087, 0xFFFF0085, 0xFFFF0084, 0xFFFF0082, 0xFFFF0081, 0xFFFF007F, 0xFFFF007D, 0xFFFF007C, 0xFFFF007A, 0xFFFF0079, 0xFFFF0077, 0xFFFF0076, 0xFFFF0074, 0xFFFF0073, 0xFFFF0071, 0xFFFF0070, 0xFFFF006E, 0xFFFF006D, 0xFFFF006B, 0xFFFF006A, 0xFFFF0068, 0xFFFF0067, 0xFFFF0065, 0xFFFF0063, 0xFFFF0062, 0xFFFF0060, 0xFFFF005F, 0xFFFF005D, 0xFFFF005C, 0xFFFF005A, 0xFFFF0059, 0xFFFF0057, 0xFFFF0056, 0xFFFF0054, 0xFFFF0053, 0xFFFF0051, 0xFFFF0050, 0xFFFF004E, 0xFFFF004D, 0xFFFF004B, 0xFFFF0049, 0xFFFF0048, 0xFFFF0046, 0xFFFF0045, 0xFFFF0043, 0xFFFF0042, 0xFFFF0040, 0xFFFF003F, 0xFFFF003D, 0xFFFF003C, 0xFFFF003A, 0xFFFF0039, 0xFFFF0037, 0xFFFF0036, 0xFFFF0034, 0xFFFF0033, 0xFFFF0031, 0xFFFF002F, 0xFFFF002E, 0xFFFF002C, 0xFFFF002B, 0xFFFF0029, 0xFFFF0028, 0xFFFF0026, 0xFFFF0025, 0xFFFF0023, 0xFFFF0022, 0xFFFF0020, 0xFFFF001F, 0xFFFF001D, 0xFFFF001C, 0xFFFF001A, 0xFFFF0018, 0xFFFF0017, 0xFFFF0015, 0xFFFF0014, 0xFFFF0012, 0xFFFF0011, 0xFFFF000F, 0xFFFF000E, 0xFFFF000C, 0xFFFF000B, 0xFFFF0009, 0xFFFF0008, 0xFFFF0006, 0xFFFF0005, 0xFFFF0003, 0xFFFF0002, 0xFFFF0000, 0xFFFF0100, 0xFFFF0200, 0xFFFF0400, 0xFFFF0500, 0xFFFF0700, 0xFFFF0800, 0xFFFF0A00, 0xFFFF0B00, 0xFFFF0D00, 0xFFFF0E00, 0xFFFF1000, 0xFFFF1100, 0xFFFF1300, 0xFFFF1400, 0xFFFF1600, 0xFFFF1700, 0xFFFF1900, 0xFFFF1B00, 0xFFFF1C00, 0xFFFF1E00, 0xFFFF1F00, 0xFFFF2100, 0xFFFF2200, 0xFFFF2400, 0xFFFF2500, 0xFFFF2700, 0xFFFF2800, 0xFFFF2A00, 0xFFFF2B00, 0xFFFF2D00, 0xFFFF2E00, 0xFFFF3000, 0xFFFF3100, 0xFFFF3300, 0xFFFF3500, 0xFFFF3600, 0xFFFF3800, 0xFFFF3900, 0xFFFF3B00, 0xFFFF3C00, 0xFFFF3E00, 0xFFFF3F00, 0xFFFF4100, 0xFFFF4200, 0xFFFF4400, 0xFFFF4500, 0xFFFF4700, 0xFFFF4800, 0xFFFF4A00, 0xFFFF4B00, 0xFFFF4D00, 0xFFFF4F00, 0xFFFF5000, 0xFFFF5200, 0xFFFF5300, 0xFFFF5500, 0xFFFF5600, 0xFFFF5800, 0xFFFF5900, 0xFFFF5B00, 0xFFFF5C00, 0xFFFF5E00, 0xFFFF5F00, 0xFFFF6100, 0xFFFF6200, 0xFFFF6400, 0xFFFF6500, 0xFFFF6700, 0xFFFF6900, 0xFFFF6A00, 0xFFFF6C00, 0xFFFF6D00, 0xFFFF6F00, 0xFFFF7000, 0xFFFF7200, 0xFFFF7300, 0xFFFF7500, 0xFFFF7600, 0xFFFF7800, 0xFFFF7900, 0xFFFF7B00, 0xFFFF7C00, 0xFFFF7E00, 0xFFFF8000, 0xFFFF8100, 0xFFFF8300, 0xFFFF8400, 0xFFFF8600, 0xFFFF8700, 0xFFFF8900, 0xFFFF8A00, 0xFFFF8C00, 0xFFFF8D00, 0xFFFF8F00, 0xFFFF9000, 0xFFFF9200, 0xFFFF9300, 0xFFFF9500, 0xFFFF9600, 0xFFFF9800, 0xFFFF9A00, 0xFFFF9B00, 0xFFFF9D00, 0xFFFF9E00, 0xFFFFA000, 0xFFFFA100, 0xFFFFA300, 0xFFFFA400, 0xFFFFA600, 0xFFFFA700, 0xFFFFA900, 0xFFFFAA00, 0xFFFFAC00, 0xFFFFAD00, 0xFFFFAF00, 0xFFFFB000, 0xFFFFB200, 0xFFFFB400, 0xFFFFB500, 0xFFFFB700, 0xFFFFB800, 0xFFFFBA00, 0xFFFFBB00, 0xFFFFBD00, 0xFFFFBE00, 0xFFFFC000, 0xFFFFC100, 0xFFFFC300, 0xFFFFC400, 0xFFFFC600, 0xFFFFC700, 0xFFFFC900, 0xFFFFCA00, 0xFFFFCC00, 0xFFFFCE00, 0xFFFFCF00, 0xFFFFD100, 0xFFFFD200, 0xFFFFD400, 0xFFFFD500, 0xFFFFD700, 0xFFFFD800, 0xFFFFDA00, 0xFFFFDB00, 0xFFFFDD00, 0xFFFFDE00, 0xFFFFE000, 0xFFFFE100, 0xFFFFE300, 0xFFFFE400, 0xFFFFE600, 0xFFFFE800, 0xFFFFE900, 0xFFFFEB00, 0xFFFFEC00, 0xFFFFEE00, 0xFFFFEF00, 0xFFFFF100, 0xFFFFF200, 0xFFFFF400, 0xFFFFF500, 0xFFFFF700, 0xFFFFF800, 0xFFFFFA00, 0xFFFFFB00, 0xFFFFFD00, 0xFFFFFF00, 0xFFFBFB03, 0xFFF8F806, 0xFFF5F509, 0xFFF2F20C, 0xFFEFEF0F, 0xFFECEC12, 0xFFE9E915, 0xFFE6E618, 0xFFE3E31B, 0xFFE0E01E, 0xFFDDDD21, 0xFFDADA24, 0xFFD7D727, 0xFFD4D42A, 0xFFD1D12D, 0xFFCECE30, 0xFFCACA34, 0xFFC7C737, 0xFFC4C43A, 0xFFC1C13D, 0xFFBEBE40, 0xFFBBBB43, 0xFFB8B846, 0xFFB5B549, 0xFFB2B24C, 0xFFAFAF4F, 0xFFACAC52, 0xFFA9A955, 0xFFA6A658, 0xFFA3A35B, 0xFFA0A05E, 0xFF9D9D61, 0xFF9A9A64, 0xFF969668, 0xFF93936B, 0xFF90906E, 0xFF8D8D71, 0xFF8A8A74, 0xFF878777, 0xFF84847A, 0xFF81817D, 0xFF7E7E80, 0xFF7B7B83, 0xFF787886, 0xFF757589, 0xFF72728C, 0xFF6F6F8F, 0xFF6C6C92, 0xFF696995, 0xFF666698, 0xFF62629C, 0xFF5F5F9F, 0xFF5C5CA2, 0xFF5959A5, 0xFF5656A8, 0xFF5353AB, 0xFF5050AE, 0xFF4D4DB1, 0xFF4A4AB4, 0xFF4747B7, 0xFF4444BA, 0xFF4141BD, 0xFF3E3EC0, 0xFF3B3BC3, 0xFF3838C6, 0xFF3535C9, 0xFF3131CD, 0xFF2E2ED0, 0xFF2B2BD3, 0xFF2828D6, 0xFF2525D9, 0xFF2222DC, 0xFF1F1FDF, 0xFF1C1CE2, 0xFF1919E5, 0xFF1616E8, 0xFF1313EB, 0xFF1010EE, 0xFF0D0DF1, 0xFF0A0AF4, 0xFF0707F7, 0xFF0404FA, 0xFF0101FD, 0xFF0200FC, 0xFF0500F9, 0xFF0800F6, 0xFF0B00F3, 0xFF0E00F0, 0xFF1100ED, 0xFF1400EA, 0xFF1700E7, 0xFF1A00E4, 0xFF1D00E1, 0xFF2000DE, 0xFF2300DB, 0xFF2600D8, 0xFF2900D5, 0xFF2C00D2, 0xFF2F00CF, 0xFF3200CC, 0xFF3600C8, 0xFF3900C5, 0xFF3C00C2, 0xFF3F00BF, 0xFF4200BC, 0xFF4500B9, 0xFF4800B6, 0xFF4B00B3, 0xFF4E00B0, 0xFF5100AD, 0xFF5400AA, 0xFF5700A7, 0xFF5A00A4, 0xFF5D00A1, 0xFF60009E, 0xFF63009B, 0xFF670097, 0xFF6A0094, 0xFF6D0091, 0xFF70008E, 0xFF73008B, 0xFF760088, 0xFF790085, 0xFF7C0082, 0xFF7F007F, 0xFF82007C, 0xFF850079, 0xFF880076, 0xFF8B0073, 0xFF8E0070, 0xFF91006D, 0xFF94006A, 0xFF970067, 0xFF9B0063, 0xFF9E0060, 0xFFA1005D, 0xFFA4005A, 0xFFA70057, 0xFFAA0054, 0xFFAD0051, 0xFFB0004E, 0xFFB3004B, 0xFFB60048, 0xFFB90045, 0xFFBC0042, 0xFFBF003F, 0xFFC2003C, 0xFFC50039, 0xFFC80036, 0xFFCB0033, 0xFFCF002F, 0xFFD2002C, 0xFFD50029, 0xFFD80026, 0xFFDB0023, 0xFFDE0020, 0xFFE1001D, 0xFFE4001A, 0xFFE70017, 0xFFEA0014, 0xFFED0011, 0xFFF0000E, 0xFFF3000B, 0xFFF60008, 0xFFF90005, 0xFFFC0002, 0xFFFD0100, 0xFFFA0400, 0xFFF70700, 0xFFF40A00, 0xFFF10D00, 0xFFEE1000, 0xFFEB1300, 0xFFE81600, 0xFFE51900, 0xFFE21C00, 0xFFDF1F00, 0xFFDC2200, 0xFFD92500, 0xFFD62800, 0xFFD32B00, 0xFFD02E00, 0xFFCD3100, 0xFFC93500, 0xFFC63800, 0xFFC33B00, 0xFFC03E00, 0xFFBD4100, 0xFFBA4400, 0xFFB74700, 0xFFB44A00, 0xFFB14D00, 0xFFAE5000, 0xFFAB5300, 0xFFA85600, 0xFFA55900, 0xFFA25C00, 0xFF9F5F00, 0xFF9C6200, 0xFF996500, 0xFF956900, 0xFF926C00, 0xFF8F6F00, 0xFF8C7200, 0xFF897500, 0xFF867800, 0xFF837B00, 0xFF807E00, 0xFF7D8100, 0xFF7A8400, 0xFF778700, 0xFF748A00, 0xFF718D00, 0xFF6E9000, 0xFF6B9300, 0xFF689600, 0xFF649A00, 0xFF619D00, 0xFF5EA000, 0xFF5BA300, 0xFF58A600, 0xFF55A900, 0xFF52AC00, 0xFF4FAF00, 0xFF4CB200, 0xFF49B500, 0xFF46B800, 0xFF43BB00, 0xFF40BE00, 0xFF3DC100, 0xFF3AC400, 0xFF37C700, 0xFF34CA00, 0xFF30CE00, 0xFF2DD100, 0xFF2AD400, 0xFF27D700, 0xFF24DA00, 0xFF21DD00, 0xFF1EE000, 0xFF1BE300, 0xFF18E600, 0xFF15E900, 0xFF12EC00, 0xFF0FEF00, 0xFF0CF200, 0xFF09F500, 0xFF06F800, 0xFF03FB00, 0xFF00FE00, 0xFF03FB03, 0xFF06F806, 0xFF09F509, 0xFF0CF20C, 0xFF0FEF0F, 0xFF12EC12, 0xFF15E915, 0xFF18E618, 0xFF1BE31B, 0xFF1EE01E, 0xFF21DD21, 0xFF24DA24, 0xFF27D727, 0xFF2AD42A, 0xFF2DD12D, 0xFF30CE30, 0xFF34CA34, 0xFF37C737, 0xFF3AC43A, 0xFF3DC13D, 0xFF40BE40, 0xFF43BB43, 0xFF46B846, 0xFF49B549, 0xFF4CB24C, 0xFF4FAF4F, 0xFF52AC52, 0xFF55A955, 0xFF58A658, 0xFF5BA35B, 0xFF5EA05E, 0xFF619D61, 0xFF649A64, 0xFF689668, 0xFF6B936B, 0xFF6E906E, 0xFF718D71, 0xFF748A74, 0xFF778777, 0xFF7A847A, 0xFF7D817D, 0xFF807E80, 0xFF837B83, 0xFF867886, 0xFF897589, 0xFF8C728C, 0xFF8F6F8F, 0xFF926C92, 0xFF956995, 0xFF986698, 0xFF9C629C, 0xFF9F5F9F, 0xFFA25CA2, 0xFFA559A5, 0xFFA856A8, 0xFFAB53AB, 0xFFAE50AE, 0xFFB14DB1, 0xFFB44AB4, 0xFFB747B7, 0xFFBA44BA, 0xFFBD41BD, 0xFFC03EC0, 0xFFC33BC3, 0xFFC638C6, 0xFFC935C9, 0xFFCD31CD, 0xFFD02ED0, 0xFFD32BD3, 0xFFD628D6, 0xFFD925D9, 0xFFDC22DC, 0xFFDF1FDF, 0xFFE21CE2, 0xFFE519E5, 0xFFE816E8, 0xFFEB13EB, 0xFFEE10EE, 0xFFF10DF1, 0xFFF40AF4, 0xFFF707F7, 0xFFFA04FA, 0xFFFD01FD, 0xFFFC02FF, 0xFFF905FF, 0xFFF608FF, 0xFFF30BFF, 0xFFF00EFF, 0xFFED11FF, 0xFFEA14FF, 0xFFE717FF, 0xFFE41AFF, 0xFFE11DFF, 0xFFDE20FF, 0xFFDB23FF, 0xFFD826FF, 0xFFD529FF, 0xFFD22CFF, 0xFFCF2FFF, 0xFFCC32FF, 0xFFC836FF, 0xFFC539FF, 0xFFC23CFF, 0xFFBF3FFF, 0xFFBC42FF, 0xFFB945FF, 0xFFB648FF, 0xFFB34BFF, 0xFFB04EFF, 0xFFAD51FF, 0xFFAA54FF, 0xFFA757FF, 0xFFA45AFF, 0xFFA15DFF, 0xFF9E60FF, 0xFF9B63FF, 0xFF9767FF, 0xFF946AFF, 0xFF916DFF, 0xFF8E70FF, 0xFF8B73FF, 0xFF8876FF, 0xFF8579FF, 0xFF827CFF, 0xFF7F7FFF, 0xFF7C82FF, 0xFF7985FF, 0xFF7688FF, 0xFF738BFF, 0xFF708EFF, 0xFF6D91FF, 0xFF6A94FF, 0xFF6797FF, 0xFF639BFF, 0xFF609EFF, 0xFF5DA1FF, 0xFF5AA4FF, 0xFF57A7FF, 0xFF54AAFF, 0xFF51ADFF, 0xFF4EB0FF, 0xFF4BB3FF, 0xFF48B6FF, 0xFF45B9FF, 0xFF42BCFF, 0xFF3FBFFF, 0xFF3CC2FF, 0xFF39C5FF, 0xFF36C8FF, 0xFF33CBFF, 0xFF2FCFFF, 0xFF2CD2FF, 0xFF29D5FF, 0xFF26D8FF, 0xFF23DBFF, 0xFF20DEFF, 0xFF1DE1FF, 0xFF1AE4FF, 0xFF17E7FF, 0xFF14EAFF, 0xFF11EDFF, 0xFF0EF0FF, 0xFF0BF3FF, 0xFF08F6FF, 0xFF05F9FF, 0xFF02FCFF, 0xFF01FFFD, 0xFF04FFFA, 0xFF07FFF7, 0xFF0AFFF4, 0xFF0DFFF1, 0xFF10FFEE, 0xFF13FFEB, 0xFF16FFE8, 0xFF19FFE5, 0xFF1CFFE2, 0xFF1FFFDF, 0xFF22FFDC, 0xFF25FFD9, 0xFF28FFD6, 0xFF2BFFD3, 0xFF2EFFD0, 0xFF31FFCD, 0xFF35FFC9, 0xFF38FFC6, 0xFF3BFFC3, 0xFF3EFFC0, 0xFF41FFBD, 0xFF44FFBA, 0xFF47FFB7, 0xFF4AFFB4, 0xFF4DFFB1, 0xFF50FFAE, 0xFF53FFAB, 0xFF56FFA8, 0xFF59FFA5, 0xFF5CFFA2, 0xFF5FFF9F, 0xFF62FF9C, 0xFF65FF99, 0xFF69FF95, 0xFF6CFF92, 0xFF6FFF8F, 0xFF72FF8C, 0xFF75FF89, 0xFF78FF86, 0xFF7BFF83, 0xFF7EFF80, 0xFF81FF7D, 0xFF84FF7A, 0xFF87FF77, 0xFF8AFF74, 0xFF8DFF71, 0xFF90FF6E, 0xFF93FF6B, 0xFF96FF68, 0xFF9AFF64, 0xFF9DFF61, 0xFFA0FF5E, 0xFFA3FF5B, 0xFFA6FF58, 0xFFA9FF55, 0xFFACFF52, 0xFFAFFF4F, 0xFFB2FF4C, 0xFFB5FF49, 0xFFB8FF46, 0xFFBBFF43, 0xFFBEFF40, 0xFFC1FF3D, 0xFFC4FF3A, 0xFFC7FF37, 0xFFCAFF34, 0xFFCEFF30, 0xFFD1FF2D, 0xFFD4FF2A, 0xFFD7FF27, 0xFFDAFF24, 0xFFDDFF21, 0xFFE0FF1E, 0xFFE3FF1B, 0xFFE6FF18, 0xFFE9FF15, 0xFFECFF12, 0xFFEFFF0F, 0xFFF2FF0C, 0xFFF5FF09, 0xFFF8FF06, 0xFFFBFF03, 0xFFFEFF00, 0xFFFBFF00, 0xFFF8FF00, 0xFFF5FF00, 0xFFF2FF00, 0xFFEFFF00, 0xFFECFF00, 0xFFE9FF00, 0xFFE6FF00, 0xFFE3FF00, 0xFFE0FF00, 0xFFDDFF00, 0xFFDAFF00, 0xFFD7FF00, 0xFFD4FF00, 0xFFD1FF00, 0xFFCEFF00, 0xFFCAFF00, 0xFFC7FF00, 0xFFC4FF00, 0xFFC1FF00, 0xFFBEFF00, 0xFFBBFF00, 0xFFB8FF00, 0xFFB5FF00, 0xFFB2FF00, 0xFFAFFF00, 0xFFACFF00, 0xFFA9FF00, 0xFFA6FF00, 0xFFA3FF00, 0xFFA0FF00, 0xFF9DFF00, 0xFF9AFF00, 0xFF96FF00, 0xFF93FF00, 0xFF90FF00, 0xFF8DFF00, 0xFF8AFF00, 0xFF87FF00, 0xFF84FF00, 0xFF81FF00, 0xFF7EFF00, 0xFF7BFF00, 0xFF78FF00, 0xFF75FF00, 0xFF72FF00, 0xFF6FFF00, 0xFF6CFF00, 0xFF69FF00, 0xFF66FF00, 0xFF62FF00, 0xFF5FFF00, 0xFF5CFF00, 0xFF59FF00, 0xFF56FF00, 0xFF53FF00, 0xFF50FF00, 0xFF4DFF00, 0xFF4AFF00, 0xFF47FF00, 0xFF44FF00, 0xFF41FF00, 0xFF3EFF00, 0xFF3BFF00, 0xFF38FF00, 0xFF35FF00, 0xFF31FF00, 0xFF2EFF00, 0xFF2BFF00, 0xFF28FF00, 0xFF25FF00, 0xFF22FF00, 0xFF1FFF00, 0xFF1CFF00, 0xFF19FF00, 0xFF16FF00, 0xFF13FF00, 0xFF10FF00, 0xFF0DFF00, 0xFF0AFF00, 0xFF07FF00, 0xFF04FF00, 0xFF01FF00, 0xFF00FC02, 0xFF00F905, 0xFF00F608, 0xFF00F30B, 0xFF00F00E, 0xFF00ED11, 0xFF00EA14, 0xFF00E717, 0xFF00E41A, 0xFF00E11D, 0xFF00DE20, 0xFF00DB23, 0xFF00D826, 0xFF00D529, 0xFF00D22C, 0xFF00CF2F, 0xFF00CC32, 0xFF00C836, 0xFF00C539, 0xFF00C23C, 0xFF00BF3F, 0xFF00BC42, 0xFF00B945, 0xFF00B648, 0xFF00B34B, 0xFF00B04E, 0xFF00AD51, 0xFF00AA54, 0xFF00A757, 0xFF00A45A, 0xFF00A15D, 0xFF009E60, 0xFF009B63, 0xFF009767, 0xFF00946A, 0xFF00916D, 0xFF008E70, 0xFF008B73, 0xFF008876, 0xFF008579, 0xFF00827C, 0xFF007F7F, 0xFF007C82, 0xFF007985, 0xFF007688, 0xFF00738B, 0xFF00708E, 0xFF006D91, 0xFF006A94, 0xFF006797, 0xFF00639B, 0xFF00609E, 0xFF005DA1, 0xFF005AA4, 0xFF0057A7, 0xFF0054AA, 0xFF0051AD, 0xFF004EB0, 0xFF004BB3, 0xFF0048B6, 0xFF0045B9, 0xFF0042BC, 0xFF003FBF, 0xFF003CC2, 0xFF0039C5, 0xFF0036C8, 0xFF0033CB, 0xFF002FCF, 0xFF002CD2, 0xFF0029D5, 0xFF0026D8, 0xFF0023DB, 0xFF0020DE, 0xFF001DE1, 0xFF001AE4, 0xFF0017E7, 0xFF0014EA, 0xFF0011ED, 0xFF000EF0, 0xFF000BF3, 0xFF0008F6, 0xFF0005F9, 0xFF0002FC, 0xFF0100FF, 0xFF0400FF, 0xFF0700FF, 0xFF0A00FF, 0xFF0D00FF, 0xFF1000FF, 0xFF1300FF, 0xFF1600FF, 0xFF1900FF, 0xFF1C00FF, 0xFF1F00FF, 0xFF2200FF, 0xFF2500FF, 0xFF2800FF, 0xFF2B00FF, 0xFF2E00FF, 0xFF3100FF, 0xFF3500FF, 0xFF3800FF, 0xFF3B00FF, 0xFF3E00FF, 0xFF4100FF, 0xFF4400FF, 0xFF4700FF, 0xFF4A00FF, 0xFF4D00FF, 0xFF5000FF, 0xFF5300FF, 0xFF5600FF, 0xFF5900FF, 0xFF5C00FF, 0xFF5F00FF, 0xFF6200FF, 0xFF6500FF, 0xFF6900FF, 0xFF6C00FF, 0xFF6F00FF, 0xFF7200FF, 0xFF7500FF, 0xFF7800FF, 0xFF7B00FF, 0xFF7E00FF, 0xFF8100FF, 0xFF8400FF, 0xFF8700FF, 0xFF8A00FF, 0xFF8D00FF, 0xFF9000FF, 0xFF9300FF, 0xFF9600FF, 0xFF9A00FF, 0xFF9D00FF, 0xFFA000FF, 0xFFA300FF, 0xFFA600FF, 0xFFA900FF, 0xFFAC00FF, 0xFFAF00FF, 0xFFB200FF, 0xFFB500FF, 0xFFB800FF, 0xFFBB00FF, 0xFFBE00FF, 0xFFC100FF, 0xFFC400FF, 0xFFC700FF, 0xFFCA00FF, 0xFFCE00FF, 0xFFD100FF, 0xFFD400FF, 0xFFD700FF, 0xFFDA00FF, 0xFFDD00FF, 0xFFE000FF, 0xFFE300FF, 0xFFE600FF, 0xFFE900FF, 0xFFEC00FF, 0xFFEF00FF, 0xFFF200FF, 0xFFF500FF, 0xFFF800FF, 0xFFFB00FF, 0xFFFE00FF, 0xFFFF03FB, 0xFFFF06F8, 0xFFFF09F5, 0xFFFF0CF2, 0xFFFF0FEF, 0xFFFF12EC, 0xFFFF15E9, 0xFFFF18E6, 0xFFFF1BE3, 0xFFFF1EE0, 0xFFFF21DD, 0xFFFF24DA, 0xFFFF27D7, 0xFFFF2AD4, 0xFFFF2DD1, 0xFFFF30CE, 0xFFFF34CA, 0xFFFF37C7, 0xFFFF3AC4, 0xFFFF3DC1, 0xFFFF40BE, 0xFFFF43BB, 0xFFFF46B8, 0xFFFF49B5, 0xFFFF4CB2, 0xFFFF4FAF, 0xFFFF52AC, 0xFFFF55A9, 0xFFFF58A6, 0xFFFF5BA3, 0xFFFF5EA0, 0xFFFF619D, 0xFFFF649A, 0xFFFF6896, 0xFFFF6B93, 0xFFFF6E90, 0xFFFF718D, 0xFFFF748A, 0xFFFF7787, 0xFFFF7A84, 0xFFFF7D81, 0xFFFF807E, 0xFFFF837B, 0xFFFF8678, 0xFFFF8975, 0xFFFF8C72, 0xFFFF8F6F, 0xFFFF926C, 0xFFFF9569, 0xFFFF9866, 0xFFFF9C62, 0xFFFF9F5F, 0xFFFFA25C, 0xFFFFA559, 0xFFFFA856, 0xFFFFAB53, 0xFFFFAE50, 0xFFFFB14D, 0xFFFFB44A, 0xFFFFB747, 0xFFFFBA44, 0xFFFFBD41, 0xFFFFC03E, 0xFFFFC33B, 0xFFFFC638, 0xFFFFC935, 0xFFFFCD31, 0xFFFFD02E, 0xFFFFD32B, 0xFFFFD628, 0xFFFFD925, 0xFFFFDC22, 0xFFFFDF1F, 0xFFFFE21C, 0xFFFFE519, 0xFFFFE816, 0xFFFFEB13, 0xFFFFEE10, 0xFFFFF10D, 0xFFFFF40A, 0xFFFFF707, 0xFFFFFA04, 0xFFFFFD01, 0xFFFFFC00, 0xFFFFF900, 0xFFFFF600, 0xFFFFF300, 0xFFFFF000, 0xFFFFED00, 0xFFFFEA00, 0xFFFFE700, 0xFFFFE400, 0xFFFFE100, 0xFFFFDE00, 0xFFFFDB00, 0xFFFFD800, 0xFFFFD500, 0xFFFFD200, 0xFFFFCF00, 0xFFFFCC00, 0xFFFFC800, 0xFFFFC500, 0xFFFFC200, 0xFFFFBF00, 0xFFFFBC00, 0xFFFFB900, 0xFFFFB600, 0xFFFFB300, 0xFFFFB000, 0xFFFFAD00, 0xFFFFAA00, 0xFFFFA700, 0xFFFFA400, 0xFFFFA100, 0xFFFF9E00, 0xFFFF9B00, 0xFFFF9700, 0xFFFF9400, 0xFFFF9100, 0xFFFF8E00, 0xFFFF8B00, 0xFFFF8800, 0xFFFF8500, 0xFFFF8200, 0xFFFF7F00, 0xFFFF7C00, 0xFFFF7900, 0xFFFF7600, 0xFFFF7300, 0xFFFF7000, 0xFFFF6D00, 0xFFFF6A00, 0xFFFF6700, 0xFFFF6300, 0xFFFF6000, 0xFFFF5D00, 0xFFFF5A00, 0xFFFF5700, 0xFFFF5400, 0xFFFF5100, 0xFFFF4E00, 0xFFFF4B00, 0xFFFF4800, 0xFFFF4500, 0xFFFF4200, 0xFFFF3F00, 0xFFFF3C00, 0xFFFF3900, 0xFFFF3600, 0xFFFF3300, 0xFFFF2F00, 0xFFFF2C00, 0xFFFF2900, 0xFFFF2600, 0xFFFF2300, 0xFFFF2000, 0xFFFF1D00, 0xFFFF1A00, 0xFFFF1700, 0xFFFF1400, 0xFFFF1100, 0xFFFF0E00, 0xFFFF0B00, 0xFFFF0800, 0xFFFF0500, 0xFFFF0200, 0xFFFD0101, 0xFFFA0404, 0xFFF70707, 0xFFF40A0A, 0xFFF10D0D, 0xFFEE1010, 0xFFEB1313, 0xFFE81616, 0xFFE51919, 0xFFE21C1C, 0xFFDF1F1F, 0xFFDC2222, 0xFFD92525, 0xFFD62828, 0xFFD32B2B, 0xFFD02E2E, 0xFFCD3131, 0xFFC93535, 0xFFC63838, 0xFFC33B3B, 0xFFC03E3E, 0xFFBD4141, 0xFFBA4444, 0xFFB74747, 0xFFB44A4A, 0xFFB14D4D, 0xFFAE5050, 0xFFAB5353, 0xFFA85656, 0xFFA55959, 0xFFA25C5C, 0xFF9F5F5F, 0xFF9C6262, 0xFF996565, 0xFF956969, 0xFF926C6C, 0xFF8F6F6F, 0xFF8C7272, 0xFF897575, 0xFF867878, 0xFF837B7B, 0xFF807E7E, 0xFF7D8181, 0xFF7A8484, 0xFF778787, 0xFF748A8A, 0xFF718D8D, 0xFF6E9090, 0xFF6B9393, 0xFF689696, 0xFF649A9A, 0xFF619D9D, 0xFF5EA0A0, 0xFF5BA3A3, 0xFF58A6A6, 0xFF55A9A9, 0xFF52ACAC, 0xFF4FAFAF, 0xFF4CB2B2, 0xFF49B5B5, 0xFF46B8B8, 0xFF43BBBB, 0xFF40BEBE, 0xFF3DC1C1, 0xFF3AC4C4, 0xFF37C7C7, 0xFF34CACA, 0xFF30CECE, 0xFF2DD1D1, 0xFF2AD4D4, 0xFF27D7D7, 0xFF24DADA, 0xFF21DDDD, 0xFF1EE0E0, 0xFF1BE3E3, 0xFF18E6E6, 0xFF15E9E9, 0xFF12ECEC, 0xFF0FEFEF, 0xFF0CF2F2, 0xFF09F5F5, 0xFF06F8F8, 0xFF03FBFB, 0xFFFFFF00, 0xFFFFFF06, 0xFFFFFF0C, 0xFFFFFF12, 0xFFFFFF18, 0xFFFFFF1E, 0xFFFFFF24, 0xFFFFFF2A, 0xFFFFFF30, 0xFFFFFF37, 0xFFFFFF3D, 0xFFFFFF43, 0xFFFFFF49, 0xFFFFFF4F, 0xFFFFFF55, 0xFFFFFF5B, 0xFFFFFF61, 0xFFFFFF68, 0xFFFFFF6E, 0xFFFFFF74, 0xFFFFFF7A, 0xFFFFFF80, 0xFFFFFF86, 0xFFFFFF8C, 0xFFFFFF92, 0xFFFFFF98, 0xFFFFFF9F, 0xFFFFFFA5, 0xFFFFFFAB, 0xFFFFFFB1, 0xFFFFFFB7, 0xFFFFFFBD, 0xFFFFFFC3, 0xFFFFFFC9, 0xFFFFFFD0, 0xFFFFFFD6, 0xFFFFFFDC, 0xFFFFFFE2, 0xFFFFFFE8, 0xFFFFFFEE, 0xFFFFFFF4, 0xFFFFFFFA, 0xFFFCFCFF, 0xFFF6F6FF, 0xFFF0F0FF, 0xFFEAEAFF, 0xFFE4E4FF, 0xFFDEDEFF, 0xFFD8D8FF, 0xFFD2D2FF, 0xFFCCCCFF, 0xFFC5C5FF, 0xFFBFBFFF, 0xFFB9B9FF, 0xFFB3B3FF, 0xFFADADFF, 0xFFA7A7FF, 0xFFA1A1FF, 0xFF9B9BFF, 0xFF9494FF, 0xFF8E8EFF, 0xFF8888FF, 0xFF8282FF, 0xFF7C7CFF, 0xFF7676FF, 0xFF7070FF, 0xFF6A6AFF, 0xFF6363FF, 0xFF5D5DFF, 0xFF5757FF, 0xFF5151FF, 0xFF4B4BFF, 0xFF4545FF, 0xFF3F3FFF, 0xFF3939FF, 0xFF3333FF, 0xFF2C2CFF, 0xFF2626FF, 0xFF2020FF, 0xFF1A1AFF, 0xFF1414FF, 0xFF0E0EFF, 0xFF0808FF, 0xFF0202FF, 0xFF0404FF, 0xFF0A0AFF, 0xFF1010FF, 0xFF1616FF, 0xFF1C1CFF, 0xFF2222FF, 0xFF2828FF, 0xFF2E2EFF, 0xFF3535FF, 0xFF3B3BFF, 0xFF4141FF, 0xFF4747FF, 0xFF4D4DFF, 0xFF5353FF, 0xFF5959FF, 0xFF5F5FFF, 0xFF6565FF, 0xFF6C6CFF, 0xFF7272FF, 0xFF7878FF, 0xFF7E7EFF, 0xFF8484FF, 0xFF8A8AFF, 0xFF9090FF, 0xFF9696FF, 0xFF9D9DFF, 0xFFA3A3FF, 0xFFA9A9FF, 0xFFAFAFFF, 0xFFB5B5FF, 0xFFBBBBFF, 0xFFC1C1FF, 0xFFC7C7FF, 0xFFCECEFF, 0xFFD4D4FF, 0xFFDADAFF, 0xFFE0E0FF, 0xFFE6E6FF, 0xFFECECFF, 0xFFF2F2FF, 0xFFF8F8FF, 0xFFFEFEFF, 0xFFFFF8F8, 0xFFFFF2F2, 0xFFFFECEC, 0xFFFFE6E6, 0xFFFFE0E0, 0xFFFFDADA, 0xFFFFD4D4, 0xFFFFCECE, 0xFFFFC7C7, 0xFFFFC1C1, 0xFFFFBBBB, 0xFFFFB5B5, 0xFFFFAFAF, 0xFFFFA9A9, 0xFFFFA3A3, 0xFFFF9D9D, 0xFFFF9696, 0xFFFF9090, 0xFFFF8A8A, 0xFFFF8484, 0xFFFF7E7E, 0xFFFF7878, 0xFFFF7272, 0xFFFF6C6C, 0xFFFF6666, 0xFFFF5F5F, 0xFFFF5959, 0xFFFF5353, 0xFFFF4D4D, 0xFFFF4747, 0xFFFF4141, 0xFFFF3B3B, 0xFFFF3535, 0xFFFF2E2E, 0xFFFF2828, 0xFFFF2222, 0xFFFF1C1C, 0xFFFF1616, 0xFFFF1010, 0xFFFF0A0A, 0xFFFF0404, 0xFFFF0202, 0xFFFF0808, 0xFFFF0E0E, 0xFFFF1414, 0xFFFF1A1A, 0xFFFF2020, 0xFFFF2626, 0xFFFF2C2C, 0xFFFF3232, 0xFFFF3939, 0xFFFF3F3F, 0xFFFF4545, 0xFFFF4B4B, 0xFFFF5151, 0xFFFF5757, 0xFFFF5D5D, 0xFFFF6363, 0xFFFF6A6A, 0xFFFF7070, 0xFFFF7676, 0xFFFF7C7C, 0xFFFF8282, 0xFFFF8888, 0xFFFF8E8E, 0xFFFF9494, 0xFFFF9B9B, 0xFFFFA1A1, 0xFFFFA7A7, 0xFFFFADAD, 0xFFFFB3B3, 0xFFFFB9B9, 0xFFFFBFBF, 0xFFFFC5C5, 0xFFFFCBCB, 0xFFFFD2D2, 0xFFFFD8D8, 0xFFFFDEDE, 0xFFFFE4E4, 0xFFFFEAEA, 0xFFFFF0F0, 0xFFFFF6F6, 0xFFFFFCFC, 0xFFFAFFFA, 0xFFF4FFF4, 0xFFEEFFEE, 0xFFE8FFE8, 0xFFE2FFE2, 0xFFDCFFDC, 0xFFD6FFD6, 0xFFD0FFD0, 0xFFC9FFC9, 0xFFC3FFC3, 0xFFBDFFBD, 0xFFB7FFB7, 0xFFB1FFB1, 0xFFABFFAB, 0xFFA5FFA5, 0xFF9FFF9F, 0xFF99FF99, 0xFF92FF92, 0xFF8CFF8C, 0xFF86FF86, 0xFF80FF80, 0xFF7AFF7A, 0xFF74FF74, 0xFF6EFF6E, 0xFF68FF68, 0xFF61FF61, 0xFF5BFF5B, 0xFF55FF55, 0xFF4FFF4F, 0xFF49FF49, 0xFF43FF43, 0xFF3DFF3D, 0xFF37FF37, 0xFF30FF30, 0xFF2AFF2A, 0xFF24FF24, 0xFF1EFF1E, 0xFF18FF18, 0xFF12FF12, 0xFF0CFF0C, 0xFF06FF06, 0xFF00FF00, 0xFF06FF06, 0xFF0CFF0C, 0xFF12FF12, 0xFF18FF18, 0xFF1EFF1E, 0xFF24FF24, 0xFF2AFF2A, 0xFF30FF30, 0xFF37FF37, 0xFF3DFF3D, 0xFF43FF43, 0xFF49FF49, 0xFF4FFF4F, 0xFF55FF55, 0xFF5BFF5B, 0xFF61FF61, 0xFF68FF68, 0xFF6EFF6E, 0xFF74FF74, 0xFF7AFF7A, 0xFF80FF80, 0xFF86FF86, 0xFF8CFF8C, 0xFF92FF92, 0xFF98FF98, 0xFF9FFF9F, 0xFFA5FFA5, 0xFFABFFAB, 0xFFB1FFB1, 0xFFB7FFB7, 0xFFBDFFBD, 0xFFC3FFC3, 0xFFC9FFC9, 0xFFD0FFD0, 0xFFD6FFD6, 0xFFDCFFDC, 0xFFE2FFE2, 0xFFE8FFE8, 0xFFEEFFEE, 0xFFF4FFF4, 0xFFFAFFFA, 0xFFFFFCFF, 0xFFFFF6FF, 0xFFFFF0FF, 0xFFFFEAFF, 0xFFFFE4FF, 0xFFFFDEFF, 0xFFFFD8FF, 0xFFFFD2FF, 0xFFFFCCFF, 0xFFFFC5FF, 0xFFFFBFFF, 0xFFFFB9FF, 0xFFFFB3FF, 0xFFFFADFF, 0xFFFFA7FF, 0xFFFFA1FF, 0xFFFF9BFF, 0xFFFF94FF, 0xFFFF8EFF, 0xFFFF88FF, 0xFFFF82FF, 0xFFFF7CFF, 0xFFFF76FF, 0xFFFF70FF, 0xFFFF6AFF, 0xFFFF63FF, 0xFFFF5DFF, 0xFFFF57FF, 0xFFFF51FF, 0xFFFF4BFF, 0xFFFF45FF, 0xFFFF3FFF, 0xFFFF39FF, 0xFFFF33FF, 0xFFFF2CFF, 0xFFFF26FF, 0xFFFF20FF, 0xFFFF1AFF, 0xFFFF14FF, 0xFFFF0EFF, 0xFFFF08FF, 0xFFFF02FF, 0xFFFF04FF, 0xFFFF0AFF, 0xFFFF10FF, 0xFFFF16FF, 0xFFFF1CFF, 0xFFFF22FF, 0xFFFF28FF, 0xFFFF2EFF, 0xFFFF35FF, 0xFFFF3BFF, 0xFFFF41FF, 0xFFFF47FF, 0xFFFF4DFF, 0xFFFF53FF, 0xFFFF59FF, 0xFFFF5FFF, 0xFFFF65FF, 0xFFFF6CFF, 0xFFFF72FF, 0xFFFF78FF, 0xFFFF7EFF, 0xFFFF84FF, 0xFFFF8AFF, 0xFFFF90FF, 0xFFFF96FF, 0xFFFF9DFF, 0xFFFFA3FF, 0xFFFFA9FF, 0xFFFFAFFF, 0xFFFFB5FF, 0xFFFFBBFF, 0xFFFFC1FF, 0xFFFFC7FF, 0xFFFFCEFF, 0xFFFFD4FF, 0xFFFFDAFF, 0xFFFFE0FF, 0xFFFFE6FF, 0xFFFFECFF, 0xFFFFF2FF, 0xFFFFF8FF, 0xFFFFFEFF, 0xFFF8FFFF, 0xFFF2FFFF, 0xFFECFFFF, 0xFFE6FFFF, 0xFFE0FFFF, 0xFFDAFFFF, 0xFFD4FFFF, 0xFFCEFFFF, 0xFFC7FFFF, 0xFFC1FFFF, 0xFFBBFFFF, 0xFFB5FFFF, 0xFFAFFFFF, 0xFFA9FFFF, 0xFFA3FFFF, 0xFF9DFFFF, 0xFF96FFFF, 0xFF90FFFF, 0xFF8AFFFF, 0xFF84FFFF, 0xFF7EFFFF, 0xFF78FFFF, 0xFF72FFFF, 0xFF6CFFFF, 0xFF66FFFF, 0xFF5FFFFF, 0xFF59FFFF, 0xFF53FFFF, 0xFF4DFFFF, 0xFF47FFFF, 0xFF41FFFF, 0xFF3BFFFF, 0xFF35FFFF, 0xFF2EFFFF, 0xFF28FFFF, 0xFF22FFFF, 0xFF1CFFFF, 0xFF16FFFF, 0xFF10FFFF, 0xFF0AFFFF, 0xFF04FFFF, 0xFF02FFFF, 0xFF08FFFF, 0xFF0EFFFF, 0xFF14FFFF, 0xFF1AFFFF, 0xFF20FFFF, 0xFF26FFFF, 0xFF2CFFFF, 0xFF32FFFF, 0xFF39FFFF, 0xFF3FFFFF, 0xFF45FFFF, 0xFF4BFFFF, 0xFF51FFFF, 0xFF57FFFF, 0xFF5DFFFF, 0xFF63FFFF, 0xFF6AFFFF, 0xFF70FFFF, 0xFF76FFFF, 0xFF7CFFFF, 0xFF82FFFF, 0xFF88FFFF, 0xFF8EFFFF, 0xFF94FFFF, 0xFF9BFFFF, 0xFFA1FFFF, 0xFFA7FFFF, 0xFFADFFFF, 0xFFB3FFFF, 0xFFB9FFFF, 0xFFBFFFFF, 0xFFC5FFFF, 0xFFCBFFFF, 0xFFD2FFFF, 0xFFD8FFFF, 0xFFDEFFFF, 0xFFE4FFFF, 0xFFEAFFFF, 0xFFF0FFFF, 0xFFF6FFFF, 0xFFFCFFFF, 0xFFFFFFFA, 0xFFFFFFF4, 0xFFFFFFEE, 0xFFFFFFE8, 0xFFFFFFE2, 0xFFFFFFDC, 0xFFFFFFD6, 0xFFFFFFD0, 0xFFFFFFC9, 0xFFFFFFC3, 0xFFFFFFBD, 0xFFFFFFB7, 0xFFFFFFB1, 0xFFFFFFAB, 0xFFFFFFA5, 0xFFFFFF9F, 0xFFFFFF99, 0xFFFFFF92, 0xFFFFFF8C, 0xFFFFFF86, 0xFFFFFF80, 0xFFFFFF7A, 0xFFFFFF74, 0xFFFFFF6E, 0xFFFFFF68, 0xFFFFFF61, 0xFFFFFF5B, 0xFFFFFF55, 0xFFFFFF4F, 0xFFFFFF49, 0xFFFFFF43, 0xFFFFFF3D, 0xFFFFFF37, 0xFFFFFF30, 0xFFFFFF2A, 0xFFFFFF24, 0xFFFFFF1E, 0xFFFFFF18, 0xFFFFFF12, 0xFFFFFF0C, 0xFFFFFF06, 0xFFFFFF00, 0xFFFFFF06, 0xFFFFFF0C, 0xFFFFFF12, 0xFFFFFF18, 0xFFFFFF1E, 0xFFFFFF24, 0xFFFFFF2A, 0xFFFFFF30, 0xFFFFFF37, 0xFFFFFF3D, 0xFFFFFF43, 0xFFFFFF49, 0xFFFFFF4F, 0xFFFFFF55, 0xFFFFFF5B, 0xFFFFFF61, 0xFFFFFF68, 0xFFFFFF6E, 0xFFFFFF74, 0xFFFFFF7A, 0xFFFFFF80, 0xFFFFFF86, 0xFFFFFF8C, 0xFFFFFF92, 0xFFFFFF98, 0xFFFFFF9F, 0xFFFFFFA5, 0xFFFFFFAB, 0xFFFFFFB1, 0xFFFFFFB7, 0xFFFFFFBD, 0xFFFFFFC3, 0xFFFFFFC9, 0xFFFFFFD0, 0xFFFFFFD6, 0xFFFFFFDC, 0xFFFFFFE2, 0xFFFFFFE8, 0xFFFFFFEE, 0xFFFFFFF4, 0xFFFFFFFA, 0xFFFCFFFC, 0xFFF6FFF6, 0xFFF0FFF0, 0xFFEAFFEA, 0xFFE4FFE4, 0xFFDEFFDE, 0xFFD8FFD8, 0xFFD2FFD2, 0xFFCCFFCC, 0xFFC5FFC5, 0xFFBFFFBF, 0xFFB9FFB9, 0xFFB3FFB3, 0xFFADFFAD, 0xFFA7FFA7, 0xFFA1FFA1, 0xFF9BFF9B, 0xFF94FF94, 0xFF8EFF8E, 0xFF88FF88, 0xFF82FF82, 0xFF7CFF7C, 0xFF76FF76, 0xFF70FF70, 0xFF6AFF6A, 0xFF63FF63, 0xFF5DFF5D, 0xFF57FF57, 0xFF51FF51, 0xFF4BFF4B, 0xFF45FF45, 0xFF3FFF3F, 0xFF39FF39, 0xFF33FF33, 0xFF2CFF2C, 0xFF26FF26, 0xFF20FF20, 0xFF1AFF1A, 0xFF14FF14, 0xFF0EFF0E, 0xFF08FF08, 0xFF02FF02, 0xFF04FF04, 0xFF0AFF0A, 0xFF10FF10, 0xFF16FF16, 0xFF1CFF1C, 0xFF22FF22, 0xFF28FF28, 0xFF2EFF2E, 0xFF35FF35, 0xFF3BFF3B, 0xFF41FF41, 0xFF47FF47, 0xFF4DFF4D, 0xFF53FF53, 0xFF59FF59, 0xFF5FFF5F, 0xFF65FF65, 0xFF6CFF6C, 0xFF72FF72, 0xFF78FF78, 0xFF7EFF7E, 0xFF84FF84, 0xFF8AFF8A, 0xFF90FF90, 0xFF96FF96, 0xFF9DFF9D, 0xFFA3FFA3, 0xFFA9FFA9, 0xFFAFFFAF, 0xFFB5FFB5, 0xFFBBFFBB, 0xFFC1FFC1, 0xFFC7FFC7, 0xFFCEFFCE, 0xFFD4FFD4, 0xFFDAFFDA, 0xFFE0FFE0, 0xFFE6FFE6, 0xFFECFFEC, 0xFFF2FFF2, 0xFFF8FFF8, 0xFFFEFFFE, 0xFFF8F8FF, 0xFFF2F2FF, 0xFFECECFF, 0xFFE6E6FF, 0xFFE0E0FF, 0xFFDADAFF, 0xFFD4D4FF, 0xFFCECEFF, 0xFFC7C7FF, 0xFFC1C1FF, 0xFFBBBBFF, 0xFFB5B5FF, 0xFFAFAFFF, 0xFFA9A9FF, 0xFFA3A3FF, 0xFF9D9DFF, 0xFF9696FF, 0xFF9090FF, 0xFF8A8AFF, 0xFF8484FF, 0xFF7E7EFF, 0xFF7878FF, 0xFF7272FF, 0xFF6C6CFF, 0xFF6666FF, 0xFF5F5FFF, 0xFF5959FF, 0xFF5353FF, 0xFF4D4DFF, 0xFF4747FF, 0xFF4141FF, 0xFF3B3BFF, 0xFF3535FF, 0xFF2E2EFF, 0xFF2828FF, 0xFF2222FF, 0xFF1C1CFF, 0xFF1616FF, 0xFF1010FF, 0xFF0A0AFF, 0xFF0404FF, 0xFF0202FF, 0xFF0808FF, 0xFF0E0EFF, 0xFF1414FF, 0xFF1A1AFF, 0xFF2020FF, 0xFF2626FF, 0xFF2C2CFF, 0xFF3232FF, 0xFF3939FF, 0xFF3F3FFF, 0xFF4545FF, 0xFF4B4BFF, 0xFF5151FF, 0xFF5757FF, 0xFF5D5DFF, 0xFF6363FF, 0xFF6A6AFF, 0xFF7070FF, 0xFF7676FF, 0xFF7C7CFF, 0xFF8282FF, 0xFF8888FF, 0xFF8E8EFF, 0xFF9494FF, 0xFF9B9BFF, 0xFFA1A1FF, 0xFFA7A7FF, 0xFFADADFF, 0xFFB3B3FF, 0xFFB9B9FF, 0xFFBFBFFF, 0xFFC5C5FF, 0xFFCBCBFF, 0xFFD2D2FF, 0xFFD8D8FF, 0xFFDEDEFF, 0xFFE4E4FF, 0xFFEAEAFF, 0xFFF0F0FF, 0xFFF6F6FF, 0xFFFCFCFF, 0xFFFFFAFF, 0xFFFFF4FF, 0xFFFFEEFF, 0xFFFFE8FF, 0xFFFFE2FF, 0xFFFFDCFF, 0xFFFFD6FF, 0xFFFFD0FF, 0xFFFFC9FF, 0xFFFFC3FF, 0xFFFFBDFF, 0xFFFFB7FF, 0xFFFFB1FF, 0xFFFFABFF, 0xFFFFA5FF, 0xFFFF9FFF, 0xFFFF99FF, 0xFFFF92FF, 0xFFFF8CFF, 0xFFFF86FF, 0xFFFF80FF, 0xFFFF7AFF, 0xFFFF74FF, 0xFFFF6EFF, 0xFFFF68FF, 0xFFFF61FF, 0xFFFF5BFF, 0xFFFF55FF, 0xFFFF4FFF, 0xFFFF49FF, 0xFFFF43FF, 0xFFFF3DFF, 0xFFFF37FF, 0xFFFF30FF, 0xFFFF2AFF, 0xFFFF24FF, 0xFFFF1EFF, 0xFFFF18FF, 0xFFFF12FF, 0xFFFF0CFF, 0xFFFF06FF, 0xFFFF00FF, 0xFFFF06FF, 0xFFFF0CFF, 0xFFFF12FF, 0xFFFF18FF, 0xFFFF1EFF, 0xFFFF24FF, 0xFFFF2AFF, 0xFFFF30FF, 0xFFFF37FF, 0xFFFF3DFF, 0xFFFF43FF, 0xFFFF49FF, 0xFFFF4FFF, 0xFFFF55FF, 0xFFFF5BFF, 0xFFFF61FF, 0xFFFF68FF, 0xFFFF6EFF, 0xFFFF74FF, 0xFFFF7AFF, 0xFFFF80FF, 0xFFFF86FF, 0xFFFF8CFF, 0xFFFF92FF, 0xFFFF98FF, 0xFFFF9FFF, 0xFFFFA5FF, 0xFFFFABFF, 0xFFFFB1FF, 0xFFFFB7FF, 0xFFFFBDFF, 0xFFFFC3FF, 0xFFFFC9FF, 0xFFFFD0FF, 0xFFFFD6FF, 0xFFFFDCFF, 0xFFFFE2FF, 0xFFFFE8FF, 0xFFFFEEFF, 0xFFFFF4FF, 0xFFFFFAFF, 0xFFFFFFFC, 0xFFFFFFF6, 0xFFFFFFF0, 0xFFFFFFEA, 0xFFFFFFE4, 0xFFFFFFDE, 0xFFFFFFD8, 0xFFFFFFD2, 0xFFFFFFCC, 0xFFFFFFC5, 0xFFFFFFBF, 0xFFFFFFB9, 0xFFFFFFB3, 0xFFFFFFAD, 0xFFFFFFA7, 0xFFFFFFA1, 0xFFFFFF9B, 0xFFFFFF94, 0xFFFFFF8E, 0xFFFFFF88, 0xFFFFFF82, 0xFFFFFF7C, 0xFFFFFF76, 0xFFFFFF70, 0xFFFFFF6A, 0xFFFFFF63, 0xFFFFFF5D, 0xFFFFFF57, 0xFFFFFF51, 0xFFFFFF4B, 0xFFFFFF45, 0xFFFFFF3F, 0xFFFFFF39, 0xFFFFFF33, 0xFFFFFF2C, 0xFFFFFF26, 0xFFFFFF20, 0xFFFFFF1A, 0xFFFFFF14, 0xFFFFFF0E, 0xFFFFFF08, 0xFFFFFF02, 0xFFFFFF04, 0xFFFFFF0A, 0xFFFFFF10, 0xFFFFFF16, 0xFFFFFF1C, 0xFFFFFF22, 0xFFFFFF28, 0xFFFFFF2E, 0xFFFFFF35, 0xFFFFFF3B, 0xFFFFFF41, 0xFFFFFF47, 0xFFFFFF4D, 0xFFFFFF53, 0xFFFFFF59, 0xFFFFFF5F, 0xFFFFFF65, 0xFFFFFF6C, 0xFFFFFF72, 0xFFFFFF78, 0xFFFFFF7E, 0xFFFFFF84, 0xFFFFFF8A, 0xFFFFFF90, 0xFFFFFF96, 0xFFFFFF9D, 0xFFFFFFA3, 0xFFFFFFA9, 0xFFFFFFAF, 0xFFFFFFB5, 0xFFFFFFBB, 0xFFFFFFC1, 0xFFFFFFC7, 0xFFFFFFCE, 0xFFFFFFD4, 0xFFFFFFDA, 0xFFFFFFE0, 0xFFFFFFE6, 0xFFFFFFEC, 0xFFFFFFF2, 0xFFFFFFF8, 0xFFFFFFFE, 0xFFFFF8F8, 0xFFFFF2F2, 0xFFFFECEC, 0xFFFFE6E6, 0xFFFFE0E0, 0xFFFFDADA, 0xFFFFD4D4, 0xFFFFCECE, 0xFFFFC7C7, 0xFFFFC1C1, 0xFFFFBBBB, 0xFFFFB5B5, 0xFFFFAFAF, 0xFFFFA9A9, 0xFFFFA3A3, 0xFFFF9D9D, 0xFFFF9696, 0xFFFF9090, 0xFFFF8A8A, 0xFFFF8484, 0xFFFF7E7E, 0xFFFF7878, 0xFFFF7272, 0xFFFF6C6C, 0xFFFF6666, 0xFFFF5F5F, 0xFFFF5959, 0xFFFF5353, 0xFFFF4D4D, 0xFFFF4747, 0xFFFF4141, 0xFFFF3B3B, 0xFFFF3535, 0xFFFF2E2E, 0xFFFF2828, 0xFFFF2222, 0xFFFF1C1C, 0xFFFF1616, 0xFFFF1010, 0xFFFF0A0A, 0xFFFF0404, 0xFFFF0202, 0xFFFF0808, 0xFFFF0E0E, 0xFFFF1414, 0xFFFF1A1A, 0xFFFF2020, 0xFFFF2626, 0xFFFF2C2C, 0xFFFF3232, 0xFFFF3939, 0xFFFF3F3F, 0xFFFF4545, 0xFFFF4B4B, 0xFFFF5151, 0xFFFF5757, 0xFFFF5D5D, 0xFFFF6363, 0xFFFF6A6A, 0xFFFF7070, 0xFFFF7676, 0xFFFF7C7C, 0xFFFF8282, 0xFFFF8888, 0xFFFF8E8E, 0xFFFF9494, 0xFFFF9B9B, 0xFFFFA1A1, 0xFFFFA7A7, 0xFFFFADAD, 0xFFFFB3B3, 0xFFFFB9B9, 0xFFFFBFBF, 0xFFFFC5C5, 0xFFFFCBCB, 0xFFFFD2D2, 0xFFFFD8D8, 0xFFFFDEDE, 0xFFFFE4E4, 0xFFFFEAEA, 0xFFFFF0F0, 0xFFFFF6F6, 0xFFFFFCFC, 0xFFFAFFFF, 0xFFF4FFFF, 0xFFEEFFFF, 0xFFE8FFFF, 0xFFE2FFFF, 0xFFDCFFFF, 0xFFD6FFFF, 0xFFD0FFFF, 0xFFC9FFFF, 0xFFC3FFFF, 0xFFBDFFFF, 0xFFB7FFFF, 0xFFB1FFFF, 0xFFABFFFF, 0xFFA5FFFF, 0xFF9FFFFF, 0xFF99FFFF, 0xFF92FFFF, 0xFF8CFFFF, 0xFF86FFFF, 0xFF80FFFF, 0xFF7AFFFF, 0xFF74FFFF, 0xFF6EFFFF, 0xFF68FFFF, 0xFF61FFFF, 0xFF5BFFFF, 0xFF55FFFF, 0xFF4FFFFF, 0xFF49FFFF, 0xFF43FFFF, 0xFF3DFFFF, 0xFF37FFFF, 0xFF30FFFF, 0xFF2AFFFF, 0xFF24FFFF, 0xFF1EFFFF, 0xFF18FFFF, 0xFF12FFFF, 0xFF0CFFFF, 0xFF06FFFF, 0xFF191999, 0xFF000000, 0xFF020202, 0xFF050505, 0xFF070707, 0xFF0A0A0A, 0xFF0C0C0C, 0xFF0F0F0F, 0xFF121212, 0xFF141414, 0xFF171717, 0xFF191919, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF212121, 0xFF242424, 0xFF262626, 0xFF292929, 0xFF2B2B2B, 0xFF2E2E2E, 0xFF303030, 0xFF333333, 0xFF363636, 0xFF383838, 0xFF3B3B3B, 0xFF3D3D3D, 0xFF404040, 0xFF424242, 0xFF454545, 0xFF484848, 0xFF4A4A4A, 0xFF4D4D4D, 0xFF4F4F4F, 0xFF525252, 0xFF555555, 0xFF575757, 0xFF5A5A5A, 0xFF5C5C5C, 0xFF5F5F5F, 0xFF616161, 0xFF646464, 0xFF676767, 0xFF696969, 0xFF6C6C6C, 0xFF6E6E6E, 0xFF717171, 0xFF737373, 0xFF767676, 0xFF797979, 0xFF7B7B7B, 0xFF7E7E7E, 0xFF808080, 0xFF838383, 0xFF858585, 0xFF888888, 0xFF8B8B8B, 0xFF8D8D8D, 0xFF909090, 0xFF929292, 0xFF959595, 0xFF979797, 0xFF9A9A9A, 0xFF9D9D9D, 0xFF9F9F9F, 0xFFA2A2A2, 0xFFA4A4A4, 0xFFA7A7A7, 0xFFAAAAAA, 0xFFACACAC, 0xFFAFAFAF, 0xFFB1B1B1, 0xFFB4B4B4, 0xFFB6B6B6, 0xFFB9B9B9, 0xFFBCBCBC, 0xFFBEBEBE, 0xFFC1C1C1, 0xFFC3C3C3, 0xFFC6C6C6, 0xFFC8C8C8, 0xFFCBCBCB, 0xFFCECECE, 0xFFD0D0D0, 0xFFD3D3D3, 0xFFD5D5D5, 0xFFD8D8D8, 0xFFDADADA, 0xFFDDDDDD, 0xFFE0E0E0, 0xFFE2E2E2, 0xFFE5E5E5, 0xFFE7E7E7, 0xFFEAEAEA, 0xFFECECEC, 0xFFEFEFEF, 0xFFF2F2F2, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFF00FF, 0xFFFD00FF, 0xFFFC00FF, 0xFFFA00FF, 0xFFF900FF, 0xFFF700FF, 0xFFF600FF, 0xFFF500FF, 0xFFF300FF, 0xFFF200FF, 0xFFF000FF, 0xFFEF00FF, 0xFFED00FF, 0xFFEC00FF, 0xFFEB00FF, 0xFFE900FF, 0xFFE800FF, 0xFFE600FF, 0xFFE500FF, 0xFFE300FF, 0xFFE200FF, 0xFFE100FF, 0xFFDF00FF, 0xFFDE00FF, 0xFFDC00FF, 0xFFDB00FF, 0xFFD900FF, 0xFFD800FF, 0xFFD700FF, 0xFFD500FF, 0xFFD400FF, 0xFFD200FF, 0xFFD100FF, 0xFFCF00FF, 0xFFCE00FF, 0xFFCD00FF, 0xFFCB00FF, 0xFFC900FF, 0xFFC700FF, 0xFFC400FF, 0xFFC200FF, 0xFFC000FF, 0xFFBE00FF, 0xFFBC00FF, 0xFFBA00FF, 0xFFB800FF, 0xFFB500FF, 0xFFB300FF, 0xFFB100FF, 0xFFAF00FF, 0xFFAD00FF, 0xFFAB00FF, 0xFFA900FF, 0xFFA600FF, 0xFFA400FF, 0xFFA200FF, 0xFFA000FF, 0xFF9E00FF, 0xFF9C00FF, 0xFF9A00FF, 0xFF9700FF, 0xFF9500FF, 0xFF9300FF, 0xFF9100FF, 0xFF8F00FF, 0xFF8D00FF, 0xFF8B00FF, 0xFF8800FF, 0xFF8600FF, 0xFF8400FF, 0xFF8200FF, 0xFF8000FF, 0xFF7D00FF, 0xFF7900FF, 0xFF7600FF, 0xFF7200FF, 0xFF6F00FF, 0xFF6B00FF, 0xFF6800FF, 0xFF6400FF, 0xFF6000FF, 0xFF5D00FF, 0xFF5900FF, 0xFF5600FF, 0xFF5200FF, 0xFF4F00FF, 0xFF4B00FF, 0xFF4700FF, 0xFF4400FF, 0xFF4000FF, 0xFF3D00FF, 0xFF3900FF, 0xFF3600FF, 0xFF3200FF, 0xFF2E00FF, 0xFF2B00FF, 0xFF2700FF, 0xFF2400FF, 0xFF2000FF, 0xFF1D00FF, 0xFF1900FF, 0xFF1500FF, 0xFF1200FF, 0xFF0E00FF, 0xFF0B00FF, 0xFF0700FF, 0xFF0400FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0001FF, 0xFF0003FF, 0xFF0004FF, 0xFF0005FF, 0xFF0007FF, 0xFF0008FF, 0xFF000AFF, 0xFF000BFF, 0xFF000DFF, 0xFF000EFF, 0xFF000FFF, 0xFF0011FF, 0xFF0012FF, 0xFF0014FF, 0xFF0015FF, 0xFF0017FF, 0xFF0018FF, 0xFF0019FF, 0xFF001BFF, 0xFF001CFF, 0xFF001EFF, 0xFF001FFF, 0xFF0021FF, 0xFF0022FF, 0xFF0023FF, 0xFF0025FF, 0xFF0026FF, 0xFF0028FF, 0xFF0029FF, 0xFF002BFF, 0xFF002CFF, 0xFF002DFF, 0xFF002FFF, 0xFF0030FF, 0xFF0032FF, 0xFF0033FF, 0xFF0036FF, 0xFF0038FF, 0xFF003AFF, 0xFF003CFF, 0xFF003EFF, 0xFF0040FF, 0xFF0042FF, 0xFF0045FF, 0xFF0047FF, 0xFF0049FF, 0xFF004BFF, 0xFF004DFF, 0xFF004FFF, 0xFF0051FF, 0xFF0054FF, 0xFF0056FF, 0xFF0058FF, 0xFF005AFF, 0xFF005CFF, 0xFF005EFF, 0xFF0060FF, 0xFF0063FF, 0xFF0065FF, 0xFF0067FF, 0xFF0069FF, 0xFF006BFF, 0xFF006DFF, 0xFF006FFF, 0xFF0072FF, 0xFF0074FF, 0xFF0076FF, 0xFF0078FF, 0xFF007AFF, 0xFF007CFF, 0xFF007EFF, 0xFF0081FF, 0xFF0083FF, 0xFF0085FF, 0xFF0087FF, 0xFF0089FF, 0xFF008BFF, 0xFF008DFF, 0xFF0090FF, 0xFF0092FF, 0xFF0094FF, 0xFF0096FF, 0xFF0098FF, 0xFF009AFF, 0xFF009CFF, 0xFF009FFF, 0xFF00A1FF, 0xFF00A3FF, 0xFF00A5FF, 0xFF00A7FF, 0xFF00A9FF, 0xFF00ABFF, 0xFF00AEFF, 0xFF00B0FF, 0xFF00B2FF, 0xFF00B4FF, 0xFF00B6FF, 0xFF00B8FF, 0xFF00BAFF, 0xFF00BDFF, 0xFF00BFFF, 0xFF00C1FF, 0xFF00C3FF, 0xFF00C5FF, 0xFF00C7FF, 0xFF00C9FF, 0xFF00CBFF, 0xFF00CDFF, 0xFF00CEFF, 0xFF00D0FF, 0xFF00D1FF, 0xFF00D3FF, 0xFF00D4FF, 0xFF00D5FF, 0xFF00D7FF, 0xFF00D8FF, 0xFF00DAFF, 0xFF00DBFF, 0xFF00DDFF, 0xFF00DEFF, 0xFF00DFFF, 0xFF00E1FF, 0xFF00E2FF, 0xFF00E4FF, 0xFF00E5FF, 0xFF00E7FF, 0xFF00E8FF, 0xFF00E9FF, 0xFF00EBFF, 0xFF00ECFF, 0xFF00EEFF, 0xFF00EFFF, 0xFF00F1FF, 0xFF00F2FF, 0xFF00F3FF, 0xFF00F5FF, 0xFF00F6FF, 0xFF00F8FF, 0xFF00F9FF, 0xFF00FBFF, 0xFF00FCFF, 0xFF00FDFF, 0xFF00FFFE, 0xFF00FFFD, 0xFF00FFFB, 0xFF00FFFA, 0xFF00FFF8, 0xFF00FFF7, 0xFF00FFF6, 0xFF00FFF4, 0xFF00FFF3, 0xFF00FFF1, 0xFF00FFF0, 0xFF00FFEE, 0xFF00FFED, 0xFF00FFEC, 0xFF00FFEA, 0xFF00FFE9, 0xFF00FFE7, 0xFF00FFE6, 0xFF00FFE4, 0xFF00FFE3, 0xFF00FFE2, 0xFF00FFE0, 0xFF00FFDF, 0xFF00FFDD, 0xFF00FFDC, 0xFF00FFDA, 0xFF00FFD9, 0xFF00FFD8, 0xFF00FFD6, 0xFF00FFD5, 0xFF00FFD3, 0xFF00FFD2, 0xFF00FFD0, 0xFF00FFCF, 0xFF00FFCE, 0xFF00FFCC, 0xFF00FFCA, 0xFF00FFC8, 0xFF00FFC6, 0xFF00FFC4, 0xFF00FFC2, 0xFF00FFC0, 0xFF00FFBD, 0xFF00FFBB, 0xFF00FFB9, 0xFF00FFB7, 0xFF00FFB5, 0xFF00FFB3, 0xFF00FFB1, 0xFF00FFAE, 0xFF00FFAC, 0xFF00FFAA, 0xFF00FFA8, 0xFF00FFA6, 0xFF00FFA4, 0xFF00FFA2, 0xFF00FF9F, 0xFF00FF9D, 0xFF00FF9B, 0xFF00FF99, 0xFF00FF97, 0xFF00FF95, 0xFF00FF93, 0xFF00FF90, 0xFF00FF8E, 0xFF00FF8C, 0xFF00FF8A, 0xFF00FF88, 0xFF00FF86, 0xFF00FF84, 0xFF00FF81, 0xFF00FF7F, 0xFF00FF7D, 0xFF00FF7B, 0xFF00FF79, 0xFF00FF77, 0xFF00FF75, 0xFF00FF72, 0xFF00FF70, 0xFF00FF6E, 0xFF00FF6C, 0xFF00FF6A, 0xFF00FF68, 0xFF00FF66, 0xFF00FF63, 0xFF00FF61, 0xFF00FF5F, 0xFF00FF5D, 0xFF00FF5B, 0xFF00FF59, 0xFF00FF57, 0xFF00FF54, 0xFF00FF52, 0xFF00FF50, 0xFF00FF4E, 0xFF00FF4C, 0xFF00FF4A, 0xFF00FF48, 0xFF00FF45, 0xFF00FF43, 0xFF00FF41, 0xFF00FF3F, 0xFF00FF3D, 0xFF00FF3B, 0xFF00FF39, 0xFF00FF36, 0xFF00FF34, 0xFF00FF32, 0xFF00FF31, 0xFF00FF2F, 0xFF00FF2E, 0xFF00FF2D, 0xFF00FF2B, 0xFF00FF2A, 0xFF00FF28, 0xFF00FF27, 0xFF00FF25, 0xFF00FF24, 0xFF00FF23, 0xFF00FF21, 0xFF00FF20, 0xFF00FF1E, 0xFF00FF1D, 0xFF00FF1B, 0xFF00FF1A, 0xFF00FF19, 0xFF00FF17, 0xFF00FF16, 0xFF00FF14, 0xFF00FF13, 0xFF00FF11, 0xFF00FF10, 0xFF00FF0F, 0xFF00FF0D, 0xFF00FF0C, 0xFF00FF0A, 0xFF00FF09, 0xFF00FF07, 0xFF00FF06, 0xFF00FF05, 0xFF00FF03, 0xFF00FF02, 0xFF00FF00, 0xFF00FF00, 0xFF02FF00, 0xFF03FF00, 0xFF04FF00, 0xFF06FF00, 0xFF07FF00, 0xFF09FF00, 0xFF0AFF00, 0xFF0CFF00, 0xFF0DFF00, 0xFF0EFF00, 0xFF10FF00, 0xFF11FF00, 0xFF13FF00, 0xFF14FF00, 0xFF16FF00, 0xFF17FF00, 0xFF18FF00, 0xFF1AFF00, 0xFF1BFF00, 0xFF1DFF00, 0xFF1EFF00, 0xFF20FF00, 0xFF21FF00, 0xFF22FF00, 0xFF24FF00, 0xFF25FF00, 0xFF27FF00, 0xFF28FF00, 0xFF2AFF00, 0xFF2BFF00, 0xFF2CFF00, 0xFF2EFF00, 0xFF2FFF00, 0xFF31FF00, 0xFF32FF00, 0xFF34FF00, 0xFF36FF00, 0xFF38FF00, 0xFF3AFF00, 0xFF3DFF00, 0xFF3FFF00, 0xFF41FF00, 0xFF43FF00, 0xFF45FF00, 0xFF47FF00, 0xFF49FF00, 0xFF4CFF00, 0xFF4EFF00, 0xFF50FF00, 0xFF52FF00, 0xFF54FF00, 0xFF56FF00, 0xFF58FF00, 0xFF5BFF00, 0xFF5DFF00, 0xFF5FFF00, 0xFF61FF00, 0xFF63FF00, 0xFF65FF00, 0xFF67FF00, 0xFF6AFF00, 0xFF6CFF00, 0xFF6EFF00, 0xFF70FF00, 0xFF72FF00, 0xFF74FF00, 0xFF76FF00, 0xFF79FF00, 0xFF7BFF00, 0xFF7DFF00, 0xFF7FFF00, 0xFF81FF00, 0xFF83FF00, 0xFF85FF00, 0xFF88FF00, 0xFF8AFF00, 0xFF8CFF00, 0xFF8EFF00, 0xFF90FF00, 0xFF92FF00, 0xFF94FF00, 0xFF97FF00, 0xFF99FF00, 0xFF9BFF00, 0xFF9DFF00, 0xFF9FFF00, 0xFFA1FF00, 0xFFA3FF00, 0xFFA6FF00, 0xFFA8FF00, 0xFFAAFF00, 0xFFACFF00, 0xFFAEFF00, 0xFFB0FF00, 0xFFB2FF00, 0xFFB5FF00, 0xFFB7FF00, 0xFFB9FF00, 0xFFBBFF00, 0xFFBDFF00, 0xFFBFFF00, 0xFFC1FF00, 0xFFC4FF00, 0xFFC6FF00, 0xFFC8FF00, 0xFFCAFF00, 0xFFCCFF00, 0xFFCDFF00, 0xFFCFFF00, 0xFFD0FF00, 0xFFD2FF00, 0xFFD3FF00, 0xFFD4FF00, 0xFFD6FF00, 0xFFD7FF00, 0xFFD9FF00, 0xFFDAFF00, 0xFFDCFF00, 0xFFDDFF00, 0xFFDEFF00, 0xFFE0FF00, 0xFFE1FF00, 0xFFE3FF00, 0xFFE4FF00, 0xFFE6FF00, 0xFFE7FF00, 0xFFE8FF00, 0xFFEAFF00, 0xFFEBFF00, 0xFFEDFF00, 0xFFEEFF00, 0xFFF0FF00, 0xFFF1FF00, 0xFFF2FF00, 0xFFF4FF00, 0xFFF5FF00, 0xFFF7FF00, 0xFFF8FF00, 0xFFFAFF00, 0xFFFBFF00, 0xFFFCFF00, 0xFFFEFF00, 0xFFFFFE00, 0xFFFFFD00, 0xFFFFFD00, 0xFFFFFC00, 0xFFFFFB00, 0xFFFFFB00, 0xFFFFFA00, 0xFFFFF900, 0xFFFFF800, 0xFFFFF800, 0xFFFFF700, 0xFFFFF600, 0xFFFFF600, 0xFFFFF500, 0xFFFFF400, 0xFFFFF300, 0xFFFFF300, 0xFFFFF200, 0xFFFFF100, 0xFFFFF100, 0xFFFFF000, 0xFFFFEF00, 0xFFFFEE00, 0xFFFFEE00, 0xFFFFED00, 0xFFFFEC00, 0xFFFFEC00, 0xFFFFEB00, 0xFFFFEA00, 0xFFFFE900, 0xFFFFE900, 0xFFFFE800, 0xFFFFE700, 0xFFFFE700, 0xFFFFE600, 0xFFFFE500, 0xFFFFE400, 0xFFFFE300, 0xFFFFE200, 0xFFFFE100, 0xFFFFE000, 0xFFFFDF00, 0xFFFFDE00, 0xFFFFDD00, 0xFFFFDC00, 0xFFFFDA00, 0xFFFFD900, 0xFFFFD800, 0xFFFFD700, 0xFFFFD600, 0xFFFFD500, 0xFFFFD400, 0xFFFFD300, 0xFFFFD200, 0xFFFFD100, 0xFFFFD000, 0xFFFFCF00, 0xFFFFCE00, 0xFFFFCD00, 0xFFFFCB00, 0xFFFFCA00, 0xFFFFC900, 0xFFFFC800, 0xFFFFC700, 0xFFFFC600, 0xFFFFC500, 0xFFFFC400, 0xFFFFC300, 0xFFFFC200, 0xFFFFC100, 0xFFFFC000, 0xFFFFBF00, 0xFFFFBE00, 0xFFFFBC00, 0xFFFFBB00, 0xFFFFBA00, 0xFFFFB900, 0xFFFFB800, 0xFFFFB700, 0xFFFFB600, 0xFFFFB500, 0xFFFFB400, 0xFFFFB300, 0xFFFFB200, 0xFFFFB100, 0xFFFFB000, 0xFFFFAF00, 0xFFFFAD00, 0xFFFFAC00, 0xFFFFAB00, 0xFFFFAA00, 0xFFFFA900, 0xFFFFA800, 0xFFFFA700, 0xFFFFA600, 0xFFFFA500, 0xFFFFA400, 0xFFFFA300, 0xFFFFA200, 0xFFFFA100, 0xFFFFA000, 0xFFFF9E00, 0xFFFF9D00, 0xFFFF9C00, 0xFFFF9B00, 0xFFFF9A00, 0xFFFF9900, 0xFFFF9800, 0xFFFF9700, 0xFFFF9700, 0xFFFF9600, 0xFFFF9500, 0xFFFF9500, 0xFFFF9400, 0xFFFF9300, 0xFFFF9200, 0xFFFF9200, 0xFFFF9100, 0xFFFF9000, 0xFFFF9000, 0xFFFF8F00, 0xFFFF8E00, 0xFFFF8D00, 0xFFFF8D00, 0xFFFF8C00, 0xFFFF8B00, 0xFFFF8B00, 0xFFFF8A00, 0xFFFF8900, 0xFFFF8800, 0xFFFF8800, 0xFFFF8700, 0xFFFF8600, 0xFFFF8600, 0xFFFF8500, 0xFFFF8400, 0xFFFF8300, 0xFFFF8300, 0xFFFF8200, 0xFFFF8100, 0xFFFF8100, 0xFFFF8000, 0xFFFF7F00, 0xFFFF7E00, 0xFFFF7E00, 0xFFFF7D00, 0xFFFF7C00, 0xFFFF7C00, 0xFFFF7B00, 0xFFFF7A00, 0xFFFF7900, 0xFFFF7900, 0xFFFF7800, 0xFFFF7700, 0xFFFF7700, 0xFFFF7600, 0xFFFF7500, 0xFFFF7400, 0xFFFF7400, 0xFFFF7300, 0xFFFF7200, 0xFFFF7200, 0xFFFF7100, 0xFFFF7000, 0xFFFF6F00, 0xFFFF6F00, 0xFFFF6E00, 0xFFFF6D00, 0xFFFF6D00, 0xFFFF6C00, 0xFFFF6B00, 0xFFFF6A00, 0xFFFF6A00, 0xFFFF6900, 0xFFFF6800, 0xFFFF6800, 0xFFFF6700, 0xFFFF6600, 0xFFFF6600, 0xFFFF6500, 0xFFFF6400, 0xFFFF6300, 0xFFFF6300, 0xFFFF6200, 0xFFFF6100, 0xFFFF6100, 0xFFFF6000, 0xFFFF5F00, 0xFFFF5E00, 0xFFFF5E00, 0xFFFF5D00, 0xFFFF5C00, 0xFFFF5C00, 0xFFFF5B00, 0xFFFF5A00, 0xFFFF5900, 0xFFFF5900, 0xFFFF5800, 0xFFFF5700, 0xFFFF5700, 0xFFFF5600, 0xFFFF5500, 0xFFFF5400, 0xFFFF5400, 0xFFFF5300, 0xFFFF5200, 0xFFFF5200, 0xFFFF5100, 0xFFFF5000, 0xFFFF4F00, 0xFFFF4F00, 0xFFFF4E00, 0xFFFF4D00, 0xFFFF4D00, 0xFFFF4C00, 0xFFFF4B00, 0xFFFF4A00, 0xFFFF4A00, 0xFFFF4900, 0xFFFF4800, 0xFFFF4800, 0xFFFF4700, 0xFFFF4600, 0xFFFF4500, 0xFFFF4500, 0xFFFF4400, 0xFFFF4300, 0xFFFF4300, 0xFFFF4200, 0xFFFF4100, 0xFFFF4000, 0xFFFF4000, 0xFFFF3F00, 0xFFFF3E00, 0xFFFF3E00, 0xFFFF3D00, 0xFFFF3C00, 0xFFFF3B00, 0xFFFF3B00, 0xFFFF3A00, 0xFFFF3900, 0xFFFF3900, 0xFFFF3800, 0xFFFF3700, 0xFFFF3600, 0xFFFF3600, 0xFFFF3500, 0xFFFF3400, 0xFFFF3400, 0xFFFF3300, 0xFFFF3200, 0xFFFF3000, 0xFFFF2F00, 0xFFFF2D00, 0xFFFF2C00, 0xFFFF2B00, 0xFFFF2900, 0xFFFF2800, 0xFFFF2600, 0xFFFF2500, 0xFFFF2300, 0xFFFF2200, 0xFFFF2100, 0xFFFF1F00, 0xFFFF1E00, 0xFFFF1C00, 0xFFFF1B00, 0xFFFF1900, 0xFFFF1800, 0xFFFF1700, 0xFFFF1500, 0xFFFF1400, 0xFFFF1200, 0xFFFF1100, 0xFFFF0F00, 0xFFFF0E00, 0xFFFF0D00, 0xFFFF0B00, 0xFFFF0A00, 0xFFFF0800, 0xFFFF0700, 0xFFFF0500, 0xFFFF0400, 0xFFFF0300, 0xFFFF0100, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0004, 0xFFFF0007, 0xFFFF000B, 0xFFFF000E, 0xFFFF0012, 0xFFFF0015, 0xFFFF0019, 0xFFFF001D, 0xFFFF0020, 0xFFFF0024, 0xFFFF0027, 0xFFFF002B, 0xFFFF002E, 0xFFFF0032, 0xFFFF0036, 0xFFFF0039, 0xFFFF003D, 0xFFFF0040, 0xFFFF0044, 0xFFFF0047, 0xFFFF004B, 0xFFFF004F, 0xFFFF0052, 0xFFFF0056, 0xFFFF0059, 0xFFFF005D, 0xFFFF0060, 0xFFFF0064, 0xFFFF0068, 0xFFFF006B, 0xFFFF006F, 0xFFFF0072, 0xFFFF0076, 0xFFFF0079, 0xFFFF007D, 0xFFFF0080, 0xFFFF0082, 0xFFFF0084, 0xFFFF0086, 0xFFFF0088, 0xFFFF008B, 0xFFFF008D, 0xFFFF008F, 0xFFFF0091, 0xFFFF0093, 0xFFFF0095, 0xFFFF0097, 0xFFFF009A, 0xFFFF009C, 0xFFFF009E, 0xFFFF00A0, 0xFFFF00A2, 0xFFFF00A4, 0xFFFF00A6, 0xFFFF00A9, 0xFFFF00AB, 0xFFFF00AD, 0xFFFF00AF, 0xFFFF00B1, 0xFFFF00B3, 0xFFFF00B5, 0xFFFF00B8, 0xFFFF00BA, 0xFFFF00BC, 0xFFFF00BE, 0xFFFF00C0, 0xFFFF00C2, 0xFFFF00C4, 0xFFFF00C7, 0xFFFF00C9, 0xFFFF00CB, 0xFFFF00CD, 0xFFFF00CE, 0xFFFF00CF, 0xFFFF00D1, 0xFFFF00D2, 0xFFFF00D4, 0xFFFF00D5, 0xFFFF00D7, 0xFFFF00D8, 0xFFFF00D9, 0xFFFF00DB, 0xFFFF00DC, 0xFFFF00DE, 0xFFFF00DF, 0xFFFF00E1, 0xFFFF00E2, 0xFFFF00E3, 0xFFFF00E5, 0xFFFF00E6, 0xFFFF00E8, 0xFFFF00E9, 0xFFFF00EB, 0xFFFF00EC, 0xFFFF00ED, 0xFFFF00EF, 0xFFFF00F0, 0xFFFF00F2, 0xFFFF00F3, 0xFFFF00F5, 0xFFFF00F6, 0xFFFF00F7, 0xFFFF00F9, 0xFFFF00FA, 0xFFFF00FC, 0xFFFF00FD, 0xFFFFFF7F, 0xFF7FFFFF, 0xFFFF7F7F, 0xFFA5E5A5, 0xFF999919, 0xFF991999, 0xFF199999, 0xFFBFBFFF, 0xFFFFCC7F, 0xFFCCFFFF, 0xFF66B2B2, 0xFF84BF00, 0xFFB24C66, 0xFFB78C4C, 0xFF8CB266, 0xFF8C3F99, 0xFFB27F7F, 0xFFFF7F7F, 0xFFFFBFDD, 0xFF3FFFBF, 0xFFBFFF3F, 0xFF337FCC, 0xFFD8D8FF, 0xFFD8337F, 0xFFBA8C84, 0xFFD9FFFF, 0xFFCC7FFF, 0xFFC2FF00, 0xFFFFB5B5, 0xFFB3FFFF, 0xFFB3E3F5, 0xFFAB5CF2, 0xFF8AFF00, 0xFFBFA6A6, 0xFFF0C8A0, 0xFFFF7F00, 0xFF1FF01F, 0xFF7FD1E3, 0xFF8F3FD4, 0xFF3DFF00, 0xFFE6E6E6, 0xFFBFC2C7, 0xFFA6A6AB, 0xFF8A99C7, 0xFF9C7AC7, 0xFFE06633, 0xFFF090A0, 0xFF50D050, 0xFFC87F33, 0xFF7D7FB0, 0xFFC28F8F, 0xFF668F8F, 0xFFBD7FE3, 0xFFFFA100, 0xFFA62929, 0xFF5CB8D1, 0xFF702EB0, 0xFF00FF00, 0xFF94FFFF, 0xFF94E0E0, 0xFF73C2C9, 0xFF54B5B5, 0xFF3B9E9E, 0xFF248F8F, 0xFF0A7D8C, 0xFF006985, 0xFFC0C0C0, 0xFFFFD98F, 0xFFA67573, 0xFF667F7F, 0xFF9E63B5, 0xFFD47A00, 0xFF940094, 0xFF429EB0, 0xFF57178F, 0xFF00C900, 0xFF70D4FF, 0xFFFFFFC7, 0xFFD9FFC7, 0xFFC7FFC7, 0xFFA3FFC7, 0xFF8FFFC7, 0xFF61FFC7, 0xFF45FFC7, 0xFF30FFC7, 0xFF1FFFC7, 0xFF00FF9C, 0xFF00E675, 0xFF00D452, 0xFF00BF38, 0xFF00AB24, 0xFF4DC2FF, 0xFF4DA6FF, 0xFF2194D6, 0xFF267DAB, 0xFF266696, 0xFF175487, 0xFFD0D0E0, 0xFFFFD123, 0xFFB8B8D0, 0xFFA6544D, 0xFF575961, 0xFF9E4FB5, 0xFFAB5C00, 0xFF754F45, 0xFF428296, 0xFF420066, 0xFF007D00, 0xFF70ABFA, 0xFF00BAFF, 0xFF00A1FF, 0xFF008FFF, 0xFF007FFF, 0xFF006BFF, 0xFF545CF2, 0xFF785CE3, 0xFF8A4FE3, 0xFFA136D4, 0xFFB31FD4, 0xFFB31FBA, 0xFFB30DA6, 0xFFBD0D87, 0xFFC70066, 0xFFCC0059, 0xFFD1004F, 0xFFD90045, 0xFFE00038, 0xFFE6002E, 0xFFEB0026, 0xFFE5E5E5]);
c$.moreColors =  new java.util.Hashtable();
c$.v176 =  Clazz.newIntArray(-1, [0, 164, 1, 0, 2, 4, 3, 8, 4, 12, 5, 16, 6, 20, 7, 24, 9, 32, 10, 36, 11, 40, 13, 48, 14, 52, 15, 56, 16, 60, 17, -64, 18, -68, 19, -72, 20, 76, 28, 80, 29, 82, 30, 83, 21, 84, 22, 85, 43, 86, 31, 87, 32, 88, 24, 90, 44, 91, 33, 92, 25, 93, 26, 94, 27, 95, 46, 0x01, 47, 0x01, 48, 0x01, 49, 0x01, 50, 0x01, 51, 0x01, 34, 96, 35, 100, 36, 105, 37, 110, 38, 115, 39, 122, 40, 124, 41, 126, 45, 132]);
c$.v177 =  Clazz.newIntArray(-1, [0, 144, 1, 8, 2, 12, 3, 16, 4, 20, 5, 24, 6, 28, 7, 32, 9, 40, 10, 44, 11, 48, 13, 56, 14, 60, 15, 64, 16, 68, 17, -72, 18, -76, 19, -80, 20, 84, 21, 96, 22, 96, 24, 96, 25, 97, 26, 97, 27, 97, 46, 0x01, 47, 0x02, 48, 0x08, 49, 0x01, 50, 0x02, 51, 0x04, 28, 98, 29, 99, 30, 100, 31, 101, 32, 102, 33, 103, 34, 104, 35, 108, 36, 113, 37, 118, 38, 123, 39, 129, 40, 131, 41, 133, 43, 140, 44, 141]);
c$.v181 =  Clazz.newIntArray(-1, [0, 120, 45, 0, 35, -12, 34, -16, 41, -20, 36, -24, 17, -28, 18, -32, 19, -36, 1, 40, 2, 44, 3, 48, 4, 52, 5, 56, 6, 60, 7, 64, 9, 68, 10, 72, 11, 76, 13, 80, 14, 84, 15, 88, 16, 92, 20, 96, 21, 100, 22, 100, 24, 100, 25, 100, 26, 100, 27, 100, 46, 0x01, 47, 0x02, 48, 0x04, 49, 0x08, 50, 0x10, 51, 0x20, 28, 101, 30, 102, 31, 103, 32, 104, 33, 105, 42, 106, 37, 107, 39, 112, 40, 114, 29, 116, 43, 117, 44, 118]);
c$.v176b =  Clazz.newIntArray(-1, [0, 32, 1, 0, 2, 4, 3, 8, 4, 12, 5, 16, 6, 26]);
c$.v177b =  Clazz.newIntArray(-1, [0, 24, 1, 0, 2, 4, 4, 8, 5, 12, 3, 20, 6, 23]);
c$.v181b =  Clazz.newIntArray(-1, [0, 20, 1, 0, 2, 4, 4, 8, 5, 12, 3, 16, 6, 18]);
});
;//5.0.1-v2 Tue Feb 20 10:58:47 CST 2024
