/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.rmi.server.UID;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;

class ConnectionOutputStream
extends MarshalOutputStream {
    private final Connection conn;
    private final boolean resultStream;
    private final UID ackID;
    private DGCAckHandler dgcAckHandler = null;

    ConnectionOutputStream(Connection conn, boolean resultStream) throws IOException {
        super(conn.getOutputStream());
        this.conn = conn;
        this.resultStream = resultStream;
        this.ackID = resultStream ? new UID() : null;
    }

    void writeID() throws IOException {
        assert (this.resultStream);
        this.ackID.write(this);
    }

    boolean isResultStream() {
        return this.resultStream;
    }

    void saveObject(Object obj) {
        if (this.dgcAckHandler == null) {
            this.dgcAckHandler = new DGCAckHandler(this.ackID);
        }
        this.dgcAckHandler.add(obj);
    }

    DGCAckHandler getDGCAckHandler() {
        return this.dgcAckHandler;
    }

    void done() {
        if (this.dgcAckHandler != null) {
            this.dgcAckHandler.startTimer();
        }
    }
}

