/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.util.Arrays;

public class GrowableByteArray {
    byte[] array;
    int size;
    int cellSize;

    public GrowableByteArray(int cellSize, int initialSize) {
        this.array = new byte[initialSize];
        this.size = 0;
        this.cellSize = cellSize;
    }

    private int getNextCellIndex() {
        int oldSize = this.size;
        this.size += this.cellSize;
        if (this.size >= this.array.length) {
            this.growArray();
        }
        return oldSize;
    }

    public byte[] getArray() {
        return this.array;
    }

    public byte[] getSizedArray() {
        return Arrays.copyOf(this.array, this.getSize());
    }

    public final int getByte(int index) {
        return this.array[this.getCellIndex(index)];
    }

    public final int getNextIndex() {
        return this.getNextCellIndex() / this.cellSize;
    }

    protected final int getCellIndex(int cellIndex) {
        return this.cellSize * cellIndex;
    }

    public final void addByte(byte i) {
        int nextIndex = this.getNextIndex();
        this.array[nextIndex] = i;
    }

    public final int getSize() {
        return this.size / this.cellSize;
    }

    public void clear() {
        this.size = 0;
    }

    protected void growArray() {
        int newSize = Math.max(this.array.length * 2, 10);
        byte[] oldArray = this.array;
        this.array = new byte[newSize];
        System.arraycopy(oldArray, 0, this.array, 0, oldArray.length);
    }
}

