/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Set;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;

public class OpenMBeanParameterInfoSupport
extends MBeanParameterInfo
implements OpenMBeanParameterInfo {
    static final long serialVersionUID = -7235016873758443122L;
    private OpenType<?> openType;
    private Object defaultValue = null;
    private Set<?> legalValues = null;
    private Comparable<?> minValue = null;
    private Comparable<?> maxValue = null;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanParameterInfoSupport(String name, String description, OpenType<?> openType) {
        this(name, description, (OpenType)openType, (Object)null);
    }

    public OpenMBeanParameterInfoSupport(String name, String description, OpenType<?> openType, Descriptor descriptor) {
        super(name, openType == null ? null : openType.getClassName(), description, ImmutableDescriptor.union(descriptor, openType == null ? null : openType.getDescriptor()));
        this.openType = openType;
        descriptor = this.getDescriptor();
        this.defaultValue = OpenMBeanAttributeInfoSupport.valueFrom(descriptor, "defaultValue", openType);
        this.legalValues = OpenMBeanAttributeInfoSupport.valuesFrom(descriptor, "legalValues", openType);
        this.minValue = OpenMBeanAttributeInfoSupport.comparableValueFrom(descriptor, "minValue", openType);
        this.maxValue = OpenMBeanAttributeInfoSupport.comparableValueFrom(descriptor, "maxValue", openType);
        try {
            OpenMBeanAttributeInfoSupport.check(this);
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public <T> OpenMBeanParameterInfoSupport(String name, String description, OpenType<T> openType, T defaultValue) throws OpenDataException {
        this(name, description, openType, defaultValue, null);
    }

    public <T> OpenMBeanParameterInfoSupport(String name, String description, OpenType<T> openType, T defaultValue, T[] legalValues) throws OpenDataException {
        this(name, description, openType, defaultValue, legalValues, null, null);
    }

    public <T> OpenMBeanParameterInfoSupport(String name, String description, OpenType<T> openType, T defaultValue, Comparable<T> minValue, Comparable<T> maxValue) throws OpenDataException {
        this(name, description, openType, defaultValue, null, minValue, maxValue);
    }

    private <T> OpenMBeanParameterInfoSupport(String name, String description, OpenType<T> openType, T defaultValue, T[] legalValues, Comparable<T> minValue, Comparable<T> maxValue) throws OpenDataException {
        super(name, openType == null ? null : openType.getClassName(), description, OpenMBeanAttributeInfoSupport.makeDescriptor(openType, defaultValue, legalValues, minValue, maxValue));
        this.openType = openType;
        Descriptor d = this.getDescriptor();
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.legalValues = (Set)d.getFieldValue("legalValues");
        OpenMBeanAttributeInfoSupport.check(this);
    }

    private Object readResolve() {
        if (this.getDescriptor().getFieldNames().length == 0) {
            OpenType xopenType = (OpenType)OpenMBeanAttributeInfoSupport.cast(this.openType);
            Set xlegalValues = (Set)OpenMBeanAttributeInfoSupport.cast(this.legalValues);
            Comparable xminValue = (Comparable)OpenMBeanAttributeInfoSupport.cast(this.minValue);
            Comparable xmaxValue = (Comparable)OpenMBeanAttributeInfoSupport.cast(this.maxValue);
            return new OpenMBeanParameterInfoSupport(this.name, this.description, this.openType, OpenMBeanAttributeInfoSupport.makeDescriptor(xopenType, this.defaultValue, xlegalValues, xminValue, xmaxValue));
        }
        return this;
    }

    @Override
    public OpenType<?> getOpenType() {
        return this.openType;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Set<?> getLegalValues() {
        return this.legalValues;
    }

    @Override
    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    @Override
    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    @Override
    public boolean hasMinValue() {
        return this.minValue != null;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    @Override
    public boolean isValue(Object obj) {
        return OpenMBeanAttributeInfoSupport.isValue(this, obj);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OpenMBeanParameterInfo)) {
            return false;
        }
        OpenMBeanParameterInfo other = (OpenMBeanParameterInfo)obj;
        return OpenMBeanAttributeInfoSupport.equal(this, other);
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            this.myHashCode = OpenMBeanAttributeInfoSupport.hashCode(this);
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = OpenMBeanAttributeInfoSupport.toString(this);
        }
        return this.myToString;
    }
}

