/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;

public final class ActivationDesc
implements Serializable {
    private ActivationGroupID groupID;
    private String className;
    private String location;
    private MarshalledObject<?> data;
    private boolean restart;
    private static final long serialVersionUID = 7455834104417690957L;

    public ActivationDesc(String className, String location, MarshalledObject<?> data) throws ActivationException {
        this(ActivationGroup.internalCurrentGroupID(), className, location, data, false);
    }

    public ActivationDesc(String className, String location, MarshalledObject<?> data, boolean restart) throws ActivationException {
        this(ActivationGroup.internalCurrentGroupID(), className, location, data, restart);
    }

    public ActivationDesc(ActivationGroupID groupID, String className, String location, MarshalledObject<?> data) {
        this(groupID, className, location, data, false);
    }

    public ActivationDesc(ActivationGroupID groupID, String className, String location, MarshalledObject<?> data, boolean restart) {
        if (groupID == null) {
            throw new IllegalArgumentException("groupID can't be null");
        }
        this.groupID = groupID;
        this.className = className;
        this.location = location;
        this.data = data;
        this.restart = restart;
    }

    public ActivationGroupID getGroupID() {
        return this.groupID;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLocation() {
        return this.location;
    }

    public MarshalledObject<?> getData() {
        return this.data;
    }

    public boolean getRestartMode() {
        return this.restart;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivationDesc) {
            ActivationDesc desc = (ActivationDesc)obj;
            return (this.groupID == null ? desc.groupID == null : this.groupID.equals(desc.groupID)) && (this.className == null ? desc.className == null : this.className.equals(desc.className)) && (this.location == null ? desc.location == null : this.location.equals(desc.location)) && (this.data == null ? desc.data == null : this.data.equals(desc.data)) && this.restart == desc.restart;
        }
        return false;
    }

    public int hashCode() {
        return (this.location == null ? 0 : this.location.hashCode() << 24) ^ (this.groupID == null ? 0 : this.groupID.hashCode() << 16) ^ (this.className == null ? 0 : this.className.hashCode() << 9) ^ (this.data == null ? 0 : this.data.hashCode() << 1) ^ (this.restart ? 1 : 0);
    }
}

