/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FilePermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import sun.nio.fs.DefaultFileSystemProvider;

public final class FilePermission
extends Permission
implements Serializable {
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int READLINK = 16;
    private static final int ALL = 31;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private transient boolean allFiles;
    private transient boolean invalid;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';
    private static final long serialVersionUID = 7930732926638008763L;
    private static final FileSystem builtInFS = DefaultFileSystemProvider.create().getFileSystem(URI.create("file:///"));

    private void init(int mask) {
        int last;
        if ((mask & 0x1F) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = mask;
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.allFiles = true;
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        if (builtInFS != null) {
            try {
                String name = this.cpath.endsWith("*") ? this.cpath.substring(0, this.cpath.length() - 1) + "-" : this.cpath;
                builtInFS.getPath(new File(name).getPath(), new String[0]);
            }
            catch (InvalidPathException ipe) {
                this.invalid = true;
                return;
            }
        }
        this.cpath = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    String path = FilePermission.this.cpath;
                    if (FilePermission.this.cpath.endsWith("*")) {
                        path = path.substring(0, path.length() - 1) + "-";
                        path = new File(path).getCanonicalPath();
                        return path.substring(0, path.length() - 1) + "*";
                    }
                    return new File(path).getCanonicalPath();
                }
                catch (IOException ioe) {
                    return FilePermission.this.cpath;
                }
            }
        });
        int len = this.cpath.length();
        int n = last = len > 0 ? (int)this.cpath.charAt(len - 1) : 0;
        if (last == 45 && this.cpath.charAt(len - 2) == File.separatorChar) {
            this.directory = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --len);
        } else if (last == 42 && this.cpath.charAt(len - 2) == File.separatorChar) {
            this.directory = true;
            this.cpath = this.cpath.substring(0, --len);
        }
    }

    public FilePermission(String path, String actions2) {
        super(path);
        this.init(FilePermission.getMask(actions2));
    }

    FilePermission(String path, int mask) {
        super(path);
        this.init(mask);
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof FilePermission)) {
            return false;
        }
        FilePermission that = (FilePermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(FilePermission that) {
        if (this == that) {
            return true;
        }
        if (this.allFiles) {
            return true;
        }
        if (this.invalid || that.invalid) {
            return false;
        }
        if (that.allFiles) {
            return false;
        }
        if (this.directory) {
            if (this.recursive) {
                if (that.directory) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() > this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.directory) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf(File.separatorChar);
            if (last == -1) {
                return false;
            }
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        if (that.directory) {
            return false;
        }
        return this.cpath.equals(that.cpath);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilePermission)) {
            return false;
        }
        FilePermission that = (FilePermission)obj;
        if (this.invalid || that.invalid) {
            return false;
        }
        return this.mask == that.mask && this.allFiles == that.allFiles && this.cpath.equals(that.cpath) && this.directory == that.directory && this.recursive == that.recursive;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private static int getMask(String actions2) {
        int mask = 0;
        if (actions2 == null) {
            return mask;
        }
        if (actions2 == "read") {
            return 4;
        }
        if (actions2 == "write") {
            return 2;
        }
        if (actions2 == "execute") {
            return 1;
        }
        if (actions2 == "delete") {
            return 8;
        }
        if (actions2 == "readlink") {
            return 16;
        }
        char[] a = actions2.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 3 || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'a' && a[i - 1] != 'A' || a[i] != 'd' && a[i] != 'D')) {
                matchlen = 4;
                mask |= 4;
            } else if (!(i < 4 || a[i - 4] != 'w' && a[i - 4] != 'W' || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'i' && a[i - 2] != 'I' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 5;
                mask |= 2;
            } else if (!(i < 6 || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'x' && a[i - 5] != 'X' || a[i - 4] != 'e' && a[i - 4] != 'E' || a[i - 3] != 'c' && a[i - 3] != 'C' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 7;
                mask |= 1;
            } else if (!(i < 5 || a[i - 5] != 'd' && a[i - 5] != 'D' || a[i - 4] != 'e' && a[i - 4] != 'E' || a[i - 3] != 'l' && a[i - 3] != 'L' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 6;
                mask |= 8;
            } else if (!(i < 7 || a[i - 7] != 'r' && a[i - 7] != 'R' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'a' && a[i - 5] != 'A' || a[i - 4] != 'd' && a[i - 4] != 'D' || a[i - 3] != 'l' && a[i - 3] != 'L' || a[i - 2] != 'i' && a[i - 2] != 'I' || a[i - 1] != 'n' && a[i - 1] != 'N' || a[i] != 'k' && a[i] != 'K')) {
                matchlen = 8;
                mask |= 0x10;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions2);
            }
            boolean seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions2);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        return mask;
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        if ((mask & 4) == 4) {
            comma = true;
            sb.append("read");
        }
        if ((mask & 2) == 2) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("write");
        }
        if ((mask & 1) == 1) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("execute");
        }
        if ((mask & 8) == 8) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("delete");
        }
        if ((mask & 0x10) == 16) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("readlink");
        }
        return sb.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = FilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new FilePermissionCollection();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(FilePermission.getMask(this.actions));
    }
}

